/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=-2147483617)
public final class GradleExcludeBuildFilesDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    private static final Logger LOG = Logger.getInstance(GradleExcludeBuildFilesDataService.class);
    public static final String REGISTRY_KEY = "gradle.exclude.build.files.when.in.source.set";

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<? extends DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(3);
        }
        if (!Registry.get((String)REGISTRY_KEY).asBoolean()) {
            return;
        }
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module = module != null ? module : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't exclude build files from content root. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            GradleExcludeBuildFilesDataService.importData(modelsProvider, (Collection)entry.getValue(), module);
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<? extends DataNode<ContentRootData>> data, @NotNull Module module) {
        if (modelsProvider == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(4);
        }
        if (data == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(5);
        }
        if (module == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(6);
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (DataNode<ContentRootData> dataNode : data) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            String rootPath = contentRoot.getRootPath();
            ContentEntry contentEntry = GradleExcludeBuildFilesDataService.findContentRoot(modifiableRootModel, rootPath);
            if (contentEntry == null) continue;
            HashSet<String> toExclude = new HashSet<String>(GradleConstants.KNOWN_GRADLE_FILES.size());
            for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                VirtualFile sourceFolderRoot = sourceFolder.getFile();
                if (sourceFolderRoot == null || !sourceFolderRoot.isDirectory()) continue;
                for (String knownGradleFile : GradleConstants.KNOWN_GRADLE_FILES) {
                    VirtualFile buildFile = sourceFolderRoot.findChild(knownGradleFile);
                    if (buildFile == null || !buildFile.exists()) continue;
                    toExclude.add(knownGradleFile);
                }
            }
            List existingPatterns = contentEntry.getExcludePatterns();
            for (String toExcludeFile : toExclude) {
                if (existingPatterns.contains(toExcludeFile)) continue;
                GradleExcludeBuildFilesDataService.logDebug("Excluding build file '%s' for module '%s'", toExcludeFile, module.getName());
                contentEntry.addExcludePattern(toExcludeFile);
            }
        }
    }

    @Nullable
    private static ContentEntry findContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        if (model == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(7);
        }
        if (path == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(8);
        }
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(path)) continue;
            return entry;
        }
        return null;
    }

    private static void logDebug(@NotNull String format, Object ... args) {
        if (format == null) {
            GradleExcludeBuildFilesDataService.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(format, args));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/GradleExcludeBuildFilesDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/GradleExcludeBuildFilesDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findContentRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logDebug";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string2);
        };
    }
}

