/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.callback.OpenExternalSystemSettingsCallback;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.ObjectStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.notification.GotoSourceNotificationCallback;
import org.jetbrains.plugins.gradle.service.notification.OpenGradleSettingsCallback;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleNotificationExtension.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    public boolean isInternalError(@NotNull Throwable error) {
        Throwable unwrapped;
        String message;
        if (error == null) {
            GradleNotificationExtension.$$$reportNull$$$0(1);
        }
        if ("Compilation failed; see the compiler error output for details.".equals(message = (unwrapped = RemoteUtil.unwrap((Throwable)error)).getMessage())) {
            return true;
        }
        if (unwrapped.getCause() instanceof ObjectStreamException) {
            return true;
        }
        if (unwrapped instanceof ExternalSystemException) {
            String filePath;
            String name2;
            Throwable cause = unwrapped.getCause();
            if (cause != null && ((name2 = cause.getClass().getName()).startsWith("groovy.lang.") || name2.startsWith("org.gradle.") && !name2.startsWith("org.gradle.cli"))) {
                return ((ExternalSystemException)unwrapped).getQuickFixes().length == 0;
            }
            if (unwrapped instanceof LocationAwareExternalSystemException && (FileUtilRt.extensionEquals((String)(filePath = ((LocationAwareExternalSystemException)unwrapped).getFilePath()), (String)"gradle") || FileUtilRt.extensionEquals((String)filePath, (String)"gradle.kts"))) {
                return ((LocationAwareExternalSystemException)unwrapped).getQuickFixes().length == 0;
            }
        }
        return false;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project2, @NotNull String externalProjectPath2, @Nullable Throwable error) {
        if (notification == null) {
            GradleNotificationExtension.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            GradleNotificationExtension.$$$reportNull$$$0(3);
        }
        if (externalProjectPath2 == null) {
            GradleNotificationExtension.$$$reportNull$$$0(4);
        }
        if (error == null) {
            return;
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof ExternalSystemException) {
            this.updateNotification(notification, project2, (ExternalSystemException)unwrapped);
        }
    }

    protected void updateNotification(@NotNull NotificationData notificationData, @NotNull Project project2, @NotNull ExternalSystemException e) {
        if (notificationData == null) {
            GradleNotificationExtension.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            GradleNotificationExtension.$$$reportNull$$$0(6);
        }
        if (e == null) {
            GradleNotificationExtension.$$$reportNull$$$0(7);
        }
        for (String fix : e.getQuickFixes()) {
            if ("open_gradle_settings".equals(fix)) {
                notificationData.setListener("open_gradle_settings", (NotificationListener)new OpenGradleSettingsCallback(project2));
                continue;
            }
            if ("goto_source".equals(fix)) {
                notificationData.setListener("goto_source", (NotificationListener)new GotoSourceNotificationCallback(notificationData, project2));
                continue;
            }
            if (!"#open_external_system_settings".equals(fix)) continue;
            String linkedProjectPath = e instanceof LocationAwareExternalSystemException ? ((LocationAwareExternalSystemException)e).getFilePath() : null;
            notificationData.setListener("#open_external_system_settings", (NotificationListener)new OpenExternalSystemSettingsCallback(project2, GradleConstants.SYSTEM_ID, linkedProjectPath));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetExternalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInternalError";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

