/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.DefaultOperationResult;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemMessageEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.FailureImpl;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptorImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.gradle.tooling.Failure;
import org.gradle.tooling.FileComparisonTestAssertionFailure;
import org.gradle.tooling.TestAssertionFailure;
import org.gradle.tooling.TestFailure;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.SuccessResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.Destination;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFailureResult;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestOutputDescriptor;
import org.gradle.tooling.events.test.TestOutputEvent;
import org.gradle.tooling.events.test.TestSkippedResult;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.TestSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public final class GradleProgressEventConverter {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.externalSystem.event-processing");
    private static final Charset FILE_COMPARISON_CONTENT_CHARSET = StandardCharsets.UTF_8;

    @NotNull
    private static String createEventId(@NotNull OperationDescriptor descriptor, @NotNull String operationId) {
        if (descriptor == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(0);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(1);
        }
        StringJoiner joiner = new StringJoiner(" > ");
        joiner.add("[" + operationId + "]");
        for (OperationDescriptor currentDescriptor = descriptor; currentDescriptor != null; currentDescriptor = currentDescriptor.getParent()) {
            if (GradleProgressEventConverter.isSkipped(currentDescriptor)) continue;
            joiner.add("[" + currentDescriptor.getDisplayName() + "]");
        }
        String string2 = joiner.toString();
        if (string2 == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    public static ExternalSystemTaskNotificationEvent createTaskNotificationEvent(@NotNull ExternalSystemTaskId taskId, @NotNull String operationId, @NotNull ProgressEvent event) {
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(3);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(4);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(5);
        }
        if (GradleProgressEventConverter.isSkipped(event.getDescriptor())) {
            return null;
        }
        if (event instanceof TaskProgressEvent) {
            TaskProgressEvent taskProgressEvent = (TaskProgressEvent)event;
            return GradleProgressEventConverter.convertTaskProgressEvent(taskProgressEvent, taskId, operationId);
        }
        return GradleProgressEventConverter.convertTestProgressEvent(event, taskId, operationId);
    }

    @NotNull
    private static ExternalSystemTaskNotificationEvent convertTaskProgressEvent(@NotNull TaskProgressEvent event, @NotNull ExternalSystemTaskId taskId, @NotNull String operationId) {
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(6);
        }
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(7);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(8);
        }
        String eventId = GradleProgressEventConverter.createEventId((OperationDescriptor)event.getDescriptor(), operationId);
        long eventTime = event.getEventTime();
        String message = event.getDescriptor().getName();
        if (event instanceof TaskStartEvent) {
            return new ExternalSystemBuildEvent(taskId, (BuildEvent)new StartEventImpl((Object)eventId, (Object)taskId, eventTime, message));
        }
        if (event instanceof TaskFinishEvent) {
            TaskFinishEvent finishEvent = (TaskFinishEvent)event;
            TaskOperationResult result = finishEvent.getResult();
            EventResult eventResult = GradleProgressEventConverter.convertTaskProgressEventResult((OperationResult)result);
            if (eventResult != null) {
                return new ExternalSystemBuildEvent(taskId, (BuildEvent)new FinishEventImpl((Object)eventId, (Object)taskId, eventTime, message, eventResult));
            }
        } else if (event instanceof StatusEvent) {
            StatusEvent statusEvent = (StatusEvent)event;
            long total = statusEvent.getTotal();
            long progress = statusEvent.getProgress();
            String unit = statusEvent.getUnit();
            return new ExternalSystemBuildEvent(taskId, (BuildEvent)new ProgressBuildEventImpl((Object)eventId, (Object)taskId, eventTime, message, total, progress, unit));
        }
        LOG.warn("Undefined Gradle event " + event.getClass().getSimpleName() + " " + event);
        String description2 = event.getDescriptor().getName();
        return new ExternalSystemTaskNotificationEvent(taskId, description2);
    }

    @Nullable
    private static EventResult convertTaskProgressEventResult(@NotNull OperationResult result) {
        if (result == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(9);
        }
        if (result instanceof SuccessResult) {
            boolean isUpToDate = result instanceof TaskSuccessResult && ((TaskSuccessResult)result).isUpToDate();
            return new SuccessResultImpl(isUpToDate);
        }
        if (result instanceof FailureResult) {
            return new FailureResultImpl(null, null);
        }
        if (result instanceof SkippedResult) {
            return new com.intellij.build.events.impl.SkippedResultImpl();
        }
        LOG.warn("Undefined operation result " + result.getClass().getSimpleName() + " " + result);
        return null;
    }

    @Nullable
    private static ExternalSystemTaskNotificationEvent convertTestProgressEvent(@NotNull ProgressEvent event, @NotNull ExternalSystemTaskId taskId, @NotNull String operationId) {
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(10);
        }
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(11);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(12);
        }
        String eventId = GradleProgressEventConverter.createEventId(event.getDescriptor(), operationId);
        String parentEventId = (String)ObjectUtils.doIfNotNull((Object)event.getDescriptor().getParent(), it -> GradleProgressEventConverter.createEventId(it, operationId));
        TestOperationDescriptor descriptor = GradleProgressEventConverter.convertTestDescriptor(event);
        if (event instanceof TestStartEvent) {
            ExternalSystemStartEventImpl esEvent = new ExternalSystemStartEventImpl(eventId, parentEventId, (com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor)descriptor);
            return new ExternalSystemTaskExecutionEvent(taskId, (ExternalSystemProgressEvent)esEvent);
        }
        if (event instanceof TestFinishEvent) {
            TestFinishEvent finishEvent = (TestFinishEvent)event;
            TestOperationResult result = finishEvent.getResult();
            com.intellij.openapi.externalSystem.model.task.event.OperationResult operationResult = GradleProgressEventConverter.convertTestProgressEventResult(result);
            ExternalSystemFinishEventImpl esEvent = new ExternalSystemFinishEventImpl(eventId, parentEventId, (com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor)descriptor, operationResult);
            return new ExternalSystemTaskExecutionEvent(taskId, (ExternalSystemProgressEvent)esEvent);
        }
        if (event instanceof TestOutputEvent) {
            TestOutputEvent outputEvent = (TestOutputEvent)event;
            TestOutputDescriptor outputDescriptor = outputEvent.getDescriptor();
            Destination destination = outputDescriptor.getDestination();
            boolean isStdOut = destination == Destination.StdOut;
            String message = outputDescriptor.getMessage();
            String description2 = (isStdOut ? "StdOut" : "StdErr") + message;
            ExternalSystemMessageEventImpl esEvent = new ExternalSystemMessageEventImpl(eventId, parentEventId, (com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor)descriptor, isStdOut, message, description2);
            return new ExternalSystemTaskExecutionEvent(taskId, (ExternalSystemProgressEvent)esEvent);
        }
        return null;
    }

    @NotNull
    private static com.intellij.openapi.externalSystem.model.task.event.OperationResult convertTestProgressEventResult(@NotNull TestOperationResult result) {
        if (result == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(13);
        }
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        if (result instanceof TestSuccessResult) {
            return new com.intellij.openapi.externalSystem.model.task.event.SuccessResultImpl(startTime, endTime, false);
        }
        if (result instanceof TestFailureResult) {
            TestFailureResult failureResult = (TestFailureResult)result;
            List failures = ContainerUtil.map((Collection)failureResult.getFailures(), it -> GradleProgressEventConverter.convertTestFailure(it));
            return new com.intellij.openapi.externalSystem.model.task.event.FailureResultImpl(startTime, endTime, failures);
        }
        if (result instanceof TestSkippedResult) {
            return new SkippedResultImpl(startTime, endTime);
        }
        LOG.warn("Undefined test operation result " + result.getClass().getName());
        return new DefaultOperationResult(startTime, endTime);
    }

    @NotNull
    private static com.intellij.openapi.externalSystem.model.task.event.Failure convertTestFailure(@NotNull Failure failure) {
        String stackTrace;
        String exceptionName;
        if (failure == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(14);
        }
        String message = failure.getMessage();
        String description2 = failure.getDescription();
        List causes = ContainerUtil.map((Collection)failure.getCauses(), it -> GradleProgressEventConverter.convertTestFailure(it));
        if (failure instanceof FileComparisonTestAssertionFailure) {
            String actualFile;
            FileComparisonTestAssertionFailure comparisonFailure = (FileComparisonTestAssertionFailure)failure;
            exceptionName = comparisonFailure.getClassName();
            stackTrace = comparisonFailure.getStacktrace();
            byte[] expectedContent = comparisonFailure.getExpectedContent();
            String expectedText = expectedContent != null ? new String(expectedContent, FILE_COMPARISON_CONTENT_CHARSET) : comparisonFailure.getExpected();
            String expectedFile = expectedContent != null ? comparisonFailure.getExpected() : null;
            byte[] actualContent = comparisonFailure.getActualContent();
            String actualText = actualContent != null ? new String(actualContent, FILE_COMPARISON_CONTENT_CHARSET) : comparisonFailure.getActual();
            String string2 = actualFile = actualContent != null ? comparisonFailure.getActual() : null;
            if (expectedText != null && actualText != null) {
                return new com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure(exceptionName, message, stackTrace, description2, causes, expectedText, actualText, expectedFile, actualFile);
            }
        }
        if (failure instanceof TestAssertionFailure) {
            TestAssertionFailure assertionFailure = (TestAssertionFailure)failure;
            exceptionName = assertionFailure.getClassName();
            stackTrace = assertionFailure.getStacktrace();
            String expectedText = assertionFailure.getExpected();
            String actualText = assertionFailure.getActual();
            if (expectedText != null && actualText != null) {
                return new com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure(exceptionName, message, stackTrace, description2, causes, expectedText, actualText);
            }
        }
        if (failure instanceof TestFailure) {
            TestFailure testFailure = (TestFailure)failure;
            exceptionName = testFailure.getClassName();
            stackTrace = testFailure.getStacktrace();
            return new com.intellij.openapi.externalSystem.model.task.event.TestFailure(exceptionName, message, stackTrace, description2, causes, false);
        }
        LOG.warn("Undefined test failure type " + failure.getClass().getName());
        return new FailureImpl(message, description2, Collections.emptyList());
    }

    @NotNull
    private static TestOperationDescriptor convertTestDescriptor(@NotNull ProgressEvent event) {
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(15);
        }
        OperationDescriptor descriptor = event.getDescriptor();
        long eventTime = event.getEventTime();
        String displayName = descriptor.getDisplayName();
        if (descriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor jvmDescriptor = (JvmTestOperationDescriptor)descriptor;
            String suiteName = jvmDescriptor.getSuiteName();
            String className = jvmDescriptor.getClassName();
            String methodName = jvmDescriptor.getMethodName();
            return new TestOperationDescriptorImpl(displayName, eventTime, suiteName, className, methodName);
        }
        return new TestOperationDescriptorImpl(displayName, eventTime, null, null, null);
    }

    @Nullable
    public static ExternalSystemTaskNotificationEvent legacyConvertProgressBuildEvent(@NotNull ExternalSystemTaskId taskId, @NotNull Object id, @NotNull String event) {
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(16);
        }
        if (id == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(17);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(18);
        }
        long total = -1L;
        long progress = -1L;
        String unit = "";
        String operationName = GradleProgressEventConverter.legacyConvertBuildEventDisplayName(event);
        if (operationName == null) {
            return null;
        }
        ProgressBuildEventImpl esEvent = new ProgressBuildEventImpl(id, null, 0L, operationName + "...", total, progress, unit);
        return new ExternalSystemBuildEvent(taskId, (BuildEvent)esEvent);
    }

    @Nullable
    @NlsSafe
    public static String legacyConvertBuildEventDisplayName(@NotNull String eventDescription) {
        if (eventDescription == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(19);
        }
        if (eventDescription.startsWith("Download ")) {
            String path = eventDescription.substring("Download ".length());
            return GradleBundle.message("progress.title.download", PathUtil.getFileName((String)path));
        }
        if (eventDescription.startsWith("Task: ")) {
            return GradleBundle.message("progress.title.run.tasks", new Object[0]);
        }
        if (eventDescription.equals("Build")) {
            return GradleBundle.message("progress.title.build", new Object[0]);
        }
        if (eventDescription.startsWith("Build model ")) {
            return GradleBundle.message("progress.title.build.model", new Object[0]);
        }
        if (eventDescription.startsWith("Build parameterized model")) {
            return GradleBundle.message("progress.title.build.model", new Object[0]);
        }
        if (eventDescription.startsWith("Configure project ")) {
            return GradleBundle.message("progress.title.configure.projects", new Object[0]);
        }
        if (eventDescription.startsWith("Cross-configure project ")) {
            return GradleBundle.message("progress.title.configure.projects", new Object[0]);
        }
        return null;
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent legacyConvertTaskNotificationEvent(@NotNull ExternalSystemTaskId taskId, @NotNull String event) {
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(20);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(21);
        }
        return new ExternalSystemTaskNotificationEvent(taskId, event);
    }

    private static boolean isSkipped(@NotNull OperationDescriptor descriptor) {
        String name2;
        if (descriptor == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(22);
        }
        return GradleProgressEventConverter.isMissedProgressEvent(name2 = descriptor.getDisplayName()) || GradleProgressEventConverter.isUnnecessaryTestProgressEvent(name2);
    }

    private static boolean isUnnecessaryTestProgressEvent(@NotNull String name2) {
        if (name2 == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(23);
        }
        return name2.startsWith("Gradle Test Executor") || name2.startsWith("Gradle Test Run");
    }

    private static boolean isMissedProgressEvent(@NotNull String name2) {
        if (name2 == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(24);
        }
        return name2.startsWith("Execute executeTests for") || name2.startsWith("Executing task") || name2.startsWith("Run tasks") || name2.startsWith("Run main tasks") || name2.startsWith("Run build");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventDescription";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEventId";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTaskNotificationEvent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertTaskProgressEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertTaskProgressEventResult";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertTestProgressEvent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertTestProgressEventResult";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertTestFailure";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertTestDescriptor";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "legacyConvertProgressBuildEvent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "legacyConvertBuildEventDisplayName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "legacyConvertTaskNotificationEvent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSkipped";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isUnnecessaryTestProgressEvent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isMissedProgressEvent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

