/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonParametersFactory;
import org.jetbrains.plugins.gradle.internal.daemon.GradleServiceLookup;
import org.jetbrains.plugins.gradle.internal.daemon.GradleServiceLookupProxy;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"getBuildLayoutParameters", "Lorg/gradle/initialization/BuildLayoutParameters;", "myServiceDirectoryPath", "", "getDaemonRequestContextAfter8Dot8", "", "getDaemonServiceFactory", "Lorg/gradle/internal/service/ServiceRegistry;", "daemonClientFactory", "Lorg/gradle/launcher/daemon/client/DaemonClientFactory;", "getDaemonServicesAfter8Dot8", "parameters", "Lorg/gradle/launcher/daemon/configuration/DaemonParameters;", "getDaemonServicesBefore8Dot8", "getGradleServiceLookup", "Lorg/jetbrains/plugins/gradle/internal/daemon/GradleServiceLookup;", "intellij.gradle"})
@JvmName(name="DaemonServicesFactory")
@SourceDebugExtension(value={"SMAP\nDaemonServicesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonServicesFactory.kt\norg/jetbrains/plugins/gradle/internal/daemon/DaemonServicesFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class DaemonServicesFactory {
    @NotNull
    public static final ServiceRegistry getDaemonServiceFactory(@NotNull DaemonClientFactory daemonClientFactory, @Nullable String myServiceDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)daemonClientFactory, (String)"daemonClientFactory");
        BuildLayoutParameters layoutParameters = DaemonServicesFactory.getBuildLayoutParameters(myServiceDirectoryPath);
        DaemonParameters daemonParameters = GradleDaemonParametersFactory.getDaemonParameters(layoutParameters);
        return GradleVersionUtil.isCurrentGradleAtLeast((String)"8.8") ? DaemonServicesFactory.getDaemonServicesAfter8Dot8(daemonClientFactory, daemonParameters) : DaemonServicesFactory.getDaemonServicesBefore8Dot8(daemonClientFactory, daemonParameters);
    }

    private static final ServiceRegistry getDaemonServicesBefore8Dot8(DaemonClientFactory daemonClientFactory, DaemonParameters parameters) {
        try {
            Class[] classArray = new Class[]{OutputEventListener.class, DaemonParameters.class, InputStream.class};
            Method method = DaemonClientFactory.class.getDeclaredMethod("createBuildClientServices", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getDeclaredMethod(...)");
            Method method2 = method;
            Object[] objectArray = new Object[]{OutputEventListener.NO_OP, parameters, new ByteArrayInputStream(new byte[0])};
            Object object = method2.invoke((Object)daemonClientFactory, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            Object invocationResult = object;
            return (ServiceRegistry)invocationResult;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot resolve ServiceRegistry by reflection. Gradle version: " + GradleVersion.current(), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to cast the result of the invocation to ServiceRegistry. Gradle version: " + GradleVersion.current(), e);
        }
    }

    private static final ServiceRegistry getDaemonServicesAfter8Dot8(DaemonClientFactory daemonClientFactory, DaemonParameters parameters) {
        try {
            Class<?> daemonRequestContextClass = Class.forName("org.gradle.launcher.daemon.context.DaemonRequestContext");
            Class<?> serviceLookupClass = Class.forName("org.gradle.internal.service.ServiceLookup");
            Class[] classArray = new Class[]{serviceLookupClass, DaemonParameters.class, daemonRequestContextClass, InputStream.class};
            Method method = DaemonClientFactory.class.getDeclaredMethod("createBuildClientServices", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getDeclaredMethod(...)");
            Method createBuildClientServicesMethod = method;
            GradleServiceLookup serviceLookupDelegate = DaemonServicesFactory.getGradleServiceLookup();
            Object serviceLookup = GradleServiceLookupProxy.INSTANCE.newProxyInstance(serviceLookupDelegate);
            Object requestContext = DaemonServicesFactory.getDaemonRequestContextAfter8Dot8();
            Object[] objectArray = new Object[]{serviceLookup, parameters, requestContext, new ByteArrayInputStream(new byte[0])};
            Object object = createBuildClientServicesMethod.invoke((Object)daemonClientFactory, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.internal.service.ServiceRegistry");
            return (ServiceRegistry)object;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot resolve ServiceRegistry by reflection. Gradle version: " + GradleVersion.current(), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to cast the result of the invocation to ServiceRegistry. Gradle version: " + GradleVersion.current(), e);
        }
    }

    private static final BuildLayoutParameters getBuildLayoutParameters(String myServiceDirectoryPath) {
        BuildLayoutParameters layout = new BuildLayoutParameters();
        CharSequence charSequence = myServiceDirectoryPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            layout.setGradleUserHomeDir(new File(myServiceDirectoryPath));
        }
        return layout;
    }

    private static final GradleServiceLookup getGradleServiceLookup() {
        Class<?> userInputReceiverClass = Class.forName("org.gradle.internal.logging.console.GlobalUserInputReceiver");
        Object object = new Class[]{userInputReceiverClass};
        Object userInputReceiver = Proxy.newProxyInstance(userInputReceiverClass.getClassLoader(), object, DaemonServicesFactory::getGradleServiceLookup$lambda$0);
        Object $this$getGradleServiceLookup_u24lambda_u241 = object = new GradleServiceLookup();
        boolean bl = false;
        Type type = (Type)((Object)OutputEventListener.class);
        OutputEventListener outputEventListener = OutputEventListener.NO_OP;
        Intrinsics.checkNotNullExpressionValue((Object)outputEventListener, (String)"NO_OP");
        ((GradleServiceLookup)$this$getGradleServiceLookup_u24lambda_u241).register(type, outputEventListener);
        Intrinsics.checkNotNull(userInputReceiverClass);
        Type type2 = userInputReceiverClass;
        Intrinsics.checkNotNull((Object)userInputReceiver);
        ((GradleServiceLookup)$this$getGradleServiceLookup_u24lambda_u241).register(type2, userInputReceiver);
        return object;
    }

    private static final Object getDaemonRequestContextAfter8Dot8() {
        Constructor<?> requestContextConstructor;
        Object object;
        Class<?> requestContextClass;
        block4: {
            requestContextClass = Class.forName("org.gradle.launcher.daemon.context.DaemonRequestContext");
            Class<?> nativeServicesClass = Class.forName("org.gradle.internal.nativeintegration.services.NativeServices");
            Class<?>[] classArray = nativeServicesClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            for (Object object2 : (Object[])classArray) {
                Class it = (Class)object2;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"NativeServicesMode", (boolean)false, (int)2, null)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Class clazz = (Class)object;
        if (clazz == null) {
            throw new IllegalStateException("The NativeServicesMode class is not found inside the NativeServices class. Gradle version: " + GradleVersion.current());
        }
        Class nativeServicesModeClass = clazz;
        if (!nativeServicesModeClass.isEnum()) {
            throw new IllegalStateException("NativeServicesMode is expected to be a Enum. Gradle version: " + GradleVersion.current());
        }
        Class<?> daemonJvmCriteriaClass = Class.forName("org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria");
        Object nativeServiceModeValue = nativeServicesModeClass.getEnumConstants()[2];
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"8.9")) {
            Class[] classArray = new Class[]{daemonJvmCriteriaClass, Collection.class, Boolean.TYPE, nativeServicesModeClass, DaemonParameters.Priority.class};
            requestContextConstructor = requestContextClass.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[]{null, CollectionsKt.emptyList(), false, nativeServiceModeValue, DaemonParameters.Priority.NORMAL};
            Object obj = requestContextConstructor.newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
            return obj;
        }
        Class[] classArray = new Class[]{JavaInfo.class, daemonJvmCriteriaClass, Collection.class, Boolean.TYPE, nativeServicesModeClass, DaemonParameters.Priority.class};
        requestContextConstructor = requestContextClass.getDeclaredConstructor(classArray);
        Object[] objectArray = new Object[]{null, null, CollectionsKt.emptyList(), false, nativeServiceModeValue, DaemonParameters.Priority.NORMAL};
        Object obj = requestContextConstructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
        return obj;
    }

    private static final Unit getGradleServiceLookup$lambda$0(Object object, Method method, Object[] objectArray) {
        return Unit.INSTANCE;
    }
}

