/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.ElementTypesKt;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlLiteralTextEscaper;
import org.toml.lang.psi.TomlVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/toml/lang/psi/impl/TomlLiteralImpl;", "Lcom/intellij/psi/impl/source/tree/CompositePsiElement;", "Lorg/toml/lang/psi/TomlLiteral;", "type", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "()[Lcom/intellij/psi/PsiReference;", "isValidHost", "", "toString", "", "updateText", "text", "intellij.toml.core"})
public final class TomlLiteralImpl
extends CompositePsiElement
implements TomlLiteral {
    public TomlLiteralImpl(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(type);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferencesFromProviders(...)");
        return psiReferenceArray;
    }

    @NotNull
    public String toString() {
        return "TomlLiteral";
    }

    public boolean isValidHost() {
        return this.getNode().findChildByType(ElementTypesKt.getTOML_STRING_LITERALS()) != null;
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ASTNode valueNode = this.getNode().getFirstChildNode();
        boolean bl = valueNode instanceof LeafElement;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)valueNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafElement");
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper;
        ASTNode aSTNode = this.getNode().findChildByType(ElementTypesKt.getTOML_STRING_LITERALS());
        if (aSTNode == null || (aSTNode = aSTNode.getElementType()) == null) {
            throw new IllegalStateException((this.getText() + " is not string literal").toString());
        }
        ASTNode tokenType = aSTNode;
        if (ElementTypesKt.getTOML_BASIC_STRINGS().contains((IElementType)tokenType)) {
            literalTextEscaper = new TomlLiteralTextEscaper(this);
        } else {
            LiteralTextEscaper literalTextEscaper2 = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this, (boolean)false);
            literalTextEscaper = literalTextEscaper2;
            Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper2, (String)"createSimple(...)");
        }
        return literalTextEscaper;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (visitor instanceof TomlVisitor) {
            ((TomlVisitor)visitor).visitLiteral(this);
        } else {
            super.accept(visitor);
        }
    }
}

