/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io;

import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.io.FilenameUtils;

public final class IOCase
extends Enum<IOCase> {
    public static final /* enum */ IOCase SENSITIVE = new IOCase("Sensitive", true);
    public static final /* enum */ IOCase INSENSITIVE = new IOCase("Insensitive", false);
    public static final /* enum */ IOCase SYSTEM = new IOCase("System", !FilenameUtils.isSystemWindows());
    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;
    private static final /* synthetic */ IOCase[] $VALUES;

    public static IOCase[] values() {
        return (IOCase[])$VALUES.clone();
    }

    private IOCase(String name, boolean sensitive) {
        this.name = name;
        this.sensitive = sensitive;
    }

    public boolean checkEquals(String str1, String str2) {
        Objects.requireNonNull(str1, "str1");
        Objects.requireNonNull(str2, "str2");
        return this.sensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
    }

    public String toString() {
        return this.name;
    }

    static {
        $VALUES = new IOCase[]{SENSITIVE, INSENSITIVE, SYSTEM};
    }
}

