/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.dependencies.ExternalDependenciesResolver;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import kotlin.script.experimental.dependencies.impl.ResolverUtilsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J4\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00170\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0004*\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\fH\u0002R\"\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlin/script/experimental/dependencies/FileSystemDependenciesResolver;", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver;", "paths", "", "Ljava/io/File;", "([Ljava/io/File;)V", "localRepos", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "acceptsArtifact", "", "artifactCoordinates", "", "acceptsRepository", "repositoryCoordinates", "Lkotlin/script/experimental/dependencies/RepositoryCoordinates;", "addRepository", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "options", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;", "sourceCodeLocation", "Lkotlin/script/experimental/api/SourceCode$LocationWithId;", "resolve", "", "(Ljava/lang/String;Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;Lkotlin/script/experimental/api/SourceCode$LocationWithId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toFilePath", "toRepositoryFileOrNull", "kotlin-scripting-dependencies"})
@SourceDebugExtension(value={"SMAP\nFileSystemDependenciesResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemDependenciesResolver.kt\nkotlin/script/experimental/dependencies/FileSystemDependenciesResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class FileSystemDependenciesResolver
implements ExternalDependenciesResolver {
    @NotNull
    private final ArrayList<File> localRepos;

    public FileSystemDependenciesResolver(File ... paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Object[] objectArray = new File[]{null};
        this.localRepos = CollectionsKt.arrayListOf((Object[])objectArray);
        int n = paths.length;
        for (int i = 0; i < n; ++i) {
            File path = paths[i];
            if (path.exists() && path.isDirectory()) continue;
            boolean bl = false;
            String string = "Invalid flat lib directory repository path '" + path + '\'';
            throw new IllegalArgumentException(string.toString());
        }
        CollectionsKt.addAll((Collection)this.localRepos, (Object[])paths);
    }

    private final File toRepositoryFileOrNull(String $this$toRepositoryFileOrNull) {
        File file;
        File it = file = new File($this$toRepositoryFileOrNull);
        boolean bl = false;
        return it.exists() && it.isDirectory() ? file : null;
    }

    /*
     * Unable to fully structure code
     */
    private final File toFilePath(RepositoryCoordinates $this$toFilePath) {
        v0 = this;
        v1 = ResolverUtilsKt.toRepositoryUrlOrNull($this$toFilePath);
        if (v1 == null) ** GOTO lbl-1000
        var3_3 = var2_2 = v1;
        var5_4 = v0;
        $i$a$-takeIf-FileSystemDependenciesResolver$toFilePath$1 = false;
        var6_6 = Intrinsics.areEqual((Object)it.getProtocol(), (Object)"file");
        v0 = var5_4;
        v1 = var6_6 != false ? var2_2 : null;
        if (v1 != null) {
            v2 = v1.getPath();
        } else lbl-1000:
        // 2 sources

        {
            v2 = v3 = null;
        }
        if (v2 == null) {
            v3 = $this$toFilePath.getString();
        }
        return v0.toRepositoryFileOrNull(v3);
    }

    @Override
    @NotNull
    public ResultWithDiagnostics<Boolean> addRepository(@NotNull RepositoryCoordinates repositoryCoordinates, @NotNull ExternalDependenciesResolver.Options options, @Nullable SourceCode.LocationWithId sourceCodeLocation) {
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!this.acceptsRepository(repositoryCoordinates)) {
            return ErrorHandlingKt.asSuccess$default(false, null, 1, null);
        }
        File file = this.toFilePath(repositoryCoordinates);
        if (file == null) {
            return ResolverUtilsKt.makeResolveFailureResult("Invalid repository location: '" + repositoryCoordinates + '\'', sourceCodeLocation);
        }
        File repoDir = file;
        this.localRepos.add(repoDir);
        return ErrorHandlingKt.asSuccess$default(true, null, 1, null);
    }

    @Override
    @Nullable
    public Object resolve(@NotNull String artifactCoordinates, @NotNull ExternalDependenciesResolver.Options options, @Nullable SourceCode.LocationWithId sourceCodeLocation, @NotNull Continuation<? super ResultWithDiagnostics<? extends List<? extends File>>> $completion) {
        if (!this.acceptsArtifact(artifactCoordinates)) {
            throw new IllegalArgumentException("Path is invalid");
        }
        List messages = new ArrayList();
        for (File repo : this.localRepos) {
            File file = repo == null ? new File(artifactCoordinates) : new File(repo, artifactCoordinates);
            if (!file.exists()) {
                messages.add("File '" + file + "' not found");
                continue;
            }
            if (!file.isFile() && !file.isDirectory()) {
                messages.add("Path '" + file + "' is neither file nor directory");
                continue;
            }
            return new ResultWithDiagnostics.Success(CollectionsKt.listOf((Object)file), null, 2, null);
        }
        return ResolverUtilsKt.makeResolveFailureResult(messages, sourceCodeLocation);
    }

    @Override
    public boolean acceptsArtifact(@NotNull String artifactCoordinates) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinates, (String)"artifactCoordinates");
        return !StringsKt.isBlank((CharSequence)artifactCoordinates);
    }

    @Override
    public boolean acceptsRepository(@NotNull RepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        return this.toFilePath(repositoryCoordinates) != null;
    }
}

