/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;

public class InheritanceCollectorFilter
extends ClassFilter {
    private static final String[] EMPTY = new String[0];
    private static final String[] OBJECT = new String[]{"java.lang.Object"};

    public boolean isApplicable(InstrumentationData context) {
        return context.getProjectContext().shouldCollectInherits();
    }

    /*
     * WARNING - void declaration
     */
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var2_3;
        void inherits2;
        String[] inherits2;
        boolean hasNoSuper;
        super.visit(version, access, name, signature, superName, interfaces);
        int size = (superName == null ? 0 : 1) + (interfaces == null ? 0 : interfaces.length);
        boolean bl = hasNoSuper = (interfaces == null || interfaces.length == 0) && "java/lang/Object".equals(superName);
        if (size == 0) {
            inherits2 = EMPTY;
        } else if (inherits2 != false) {
            inherits2 = OBJECT;
        } else {
            inherits2 = new String[size];
            if (interfaces != null) {
                System.arraycopy(interfaces, 0, inherits2, 0, interfaces.length);
            }
            if (superName != null) {
                inherits2[size - 1] = superName;
            }
            for (int i = 0; i < size; ++i) {
                inherits2[i] = this.myContext.getProjectContext().getFromPool(ClassNameUtil.convertToFQName(inherits2[i]));
            }
        }
        this.myContext.getProjectContext().addInherits(this.myContext.get(Key.CLASS_NAME), (String[])var2_3);
    }
}

