/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import git4idea.GitDisposable;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitModulesFileReader;
import git4idea.repo.GitRecentCheckoutBranches;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.repo.GitTagHolder;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.status.GitStagingAreaHolder;
import git4idea.telemetry.GitTelemetrySpan;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.SemanticAttributes;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020$0(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\fH\u0016J\n\u0010,\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010-\u001a\u0004\u0018\u00010&H\u0016J\n\u0010.\u001a\u0004\u0018\u00010&H\u0016J\b\u0010/\u001a\u00020\u0006H\u0017J\b\u00100\u001a\u00020\u000eH\u0016J\b\u00101\u001a\u00020\u0013H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002030(H\u0016J\b\u00104\u001a\u00020\u0015H\u0016J\b\u00105\u001a\u00020\u001aH\u0016J\b\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u0002090(H\u0016J\b\u0010:\u001a\u00020\u001cH\u0016J\b\u0010;\u001a\u00020\u001eH\u0016J\b\u0010<\u001a\u00020 H\u0016J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020>H\u0016J\b\u0010@\u001a\u00020\u0013H\u0002J\b\u0010A\u001a\u00020&H\u0016J\b\u0010B\u001a\u00020\"H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lgit4idea/repo/GitRepositoryImpl;", "Lcom/intellij/dvcs/repo/RepositoryImpl;", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "gitDir", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/Disposable;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "ignoredRepositoryFilesHolder", "Lgit4idea/ignore/GitRepositoryIgnoredFilesHolder;", "recentCheckoutBranches", "", "Lgit4idea/GitLocalBranch;", "repoInfo", "Lgit4idea/repo/GitRepoInfo;", "repositoryFiles", "Lgit4idea/repo/GitRepositoryFiles;", "Lorg/jetbrains/annotations/NotNull;", "repositoryReader", "Lgit4idea/repo/GitRepositoryReader;", "stagingAreaHolder", "Lgit4idea/status/GitStagingAreaHolder;", "tagHolder", "Lgit4idea/repo/GitTagHolder;", "untrackedFilesHolder", "Lgit4idea/repo/GitUntrackedFilesHolder;", "vcs", "Lgit4idea/GitVcs;", "dispose", "", "getBranchTrackInfo", "Lgit4idea/repo/GitBranchTrackInfo;", "localBranchName", "", "getBranchTrackInfos", "", "getBranches", "Lgit4idea/branch/GitBranchesCollection;", "getCoroutineScope", "getCurrentBranch", "getCurrentBranchName", "getCurrentRevision", "getGitDir", "getIgnoredFilesHolder", "getInfo", "getRemotes", "Lgit4idea/repo/GitRemote;", "getRepositoryFiles", "getStagingAreaHolder", "getState", "Lcom/intellij/dvcs/repo/Repository$State;", "getSubmodules", "Lgit4idea/repo/GitSubmoduleInfo;", "getTagHolder", "getUntrackedFilesHolder", "getVcs", "isOnBranch", "", "isRebaseInProgress", "readRepoInfo", "toLogString", "update", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryImpl.kt\ngit4idea/repo/GitRepositoryImpl\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,273:1\n106#2:274\n32#2:275\n141#2,2:276\n33#2,2:278\n158#2:280\n144#2,12:281\n*S KotlinDebug\n*F\n+ 1 GitRepositoryImpl.kt\ngit4idea/repo/GitRepositoryImpl\n*L\n170#1:274\n170#1:275\n170#1:276,2\n170#1:278,2\n170#1:280\n170#1:281,12\n*E\n"})
public final class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile gitDir;
    @NotNull
    private final GitVcs vcs;
    @NotNull
    private final GitRepositoryFiles repositoryFiles;
    @NotNull
    private final GitRepositoryReader repositoryReader;
    @NotNull
    private final GitStagingAreaHolder stagingAreaHolder;
    @NotNull
    private final GitUntrackedFilesHolder untrackedFilesHolder;
    @NotNull
    private final GitRepositoryIgnoredFilesHolder ignoredRepositoryFilesHolder;
    @NotNull
    private final GitTagHolder tagHolder;
    @NotNull
    private volatile GitRepoInfo repoInfo;
    @NotNull
    private volatile List<GitLocalBranch> recentCheckoutBranches;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger LOG;

    private GitRepositoryImpl(Project project, VirtualFile rootDir, VirtualFile gitDir, Disposable parentDisposable) {
        super(project, rootDir, parentDisposable);
        this.gitDir = gitDir;
        GitVcs gitVcs = GitVcs.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        this.vcs = gitVcs;
        GitRepositoryFiles gitRepositoryFiles = GitRepositoryFiles.createInstance(rootDir, this.gitDir);
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryFiles, (String)"createInstance(...)");
        this.repositoryFiles = gitRepositoryFiles;
        this.repositoryReader = new GitRepositoryReader(this.repositoryFiles);
        this.recentCheckoutBranches = CollectionsKt.emptyList();
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)GitDisposable.Companion.getInstance(project).getCoroutineScope(), (String)"GitRepositoryImpl", null, (boolean)false, (int)6, null);
        this.stagingAreaHolder = new GitStagingAreaHolder(this);
        this.untrackedFilesHolder = new GitUntrackedFilesHolder(this);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.untrackedFilesHolder);
        this.ignoredRepositoryFilesHolder = new GitRepositoryIgnoredFilesHolder(this);
        this.tagHolder = new GitTagHolder(this);
        this.repoInfo = this.readRepoInfo();
        this.tagHolder.updateEnabled();
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public VirtualFile getGitDir() {
        return this.gitDir;
    }

    @Override
    @NotNull
    public GitRepositoryFiles getRepositoryFiles() {
        return this.repositoryFiles;
    }

    @Override
    @NotNull
    public GitStagingAreaHolder getStagingAreaHolder() {
        return this.stagingAreaHolder;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        return this.untrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepositoryIgnoredFilesHolder getIgnoredFilesHolder() {
        return this.ignoredRepositoryFilesHolder;
    }

    @Override
    @NotNull
    public GitTagHolder getTagHolder() {
        return this.tagHolder;
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        return this.repoInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.repoInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.repoInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        return this.repoInfo.getState();
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch;
        GitLocalBranch gitLocalBranch = currentBranch = this.getCurrentBranch();
        return gitLocalBranch != null ? gitLocalBranch.getName() : null;
    }

    @Override
    @NotNull
    public GitVcs getVcs() {
        return this.vcs;
    }

    @Override
    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        return this.repoInfo.getSubmodules();
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.repoInfo;
        return new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes(), this.recentCheckoutBranches);
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        return this.repoInfo.getRemotes();
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.repoInfo.getBranchTrackInfos();
    }

    @Override
    @Nullable
    public GitBranchTrackInfo getBranchTrackInfo(@NotNull String localBranchName) {
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        return this.repoInfo.getBranchTrackInfosMap().get(localBranchName);
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.repoInfo.isOnBranch();
    }

    public void update() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GitRepoInfo previousInfo = this.repoInfo;
        this.repoInfo = this.readRepoInfo();
        GitRepositoryImpl.Companion.notifyIfRepoChanged(this, previousInfo, this.repoInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final GitRepoInfo readRepoInfo() {
        GitRepoInfo gitRepoInfo;
        void tracer$iv;
        Tracer tracer = (Tracer)TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
        String spanName$iv = GitTelemetrySpan.Repository.ReadGitRepositoryInfo.getName();
        boolean $i$f$computeWithSpan = false;
        SpanBuilder spanBuilder = tracer$iv.spanBuilder(spanName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"tracer.spanBuilder(spanName)");
        SpanBuilder $this$use$iv$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan()");
        Span $this$useWithoutActiveScope$iv$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            GitRepoInfo gitRepoInfo2;
            Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span2 = span$iv$iv;
                boolean bl3 = false;
                span2.setAttribute("repository", DvcsUtil.getShortRepositoryName((Repository)this));
                File file2 = this.repositoryFiles.getConfigFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getConfigFile(...)");
                File configFile = file2;
                GitConfig gitConfig = GitConfig.read(configFile);
                Intrinsics.checkNotNullExpressionValue((Object)gitConfig, (String)"read(...)");
                GitConfig config = gitConfig;
                this.repositoryFiles.updateCustomPaths(config.parseCore());
                Collection<GitRemote> collection = config.parseRemotes();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"parseRemotes(...)");
                Collection<GitRemote> remotes = collection;
                GitBranchState gitBranchState = this.repositoryReader.readState(remotes);
                Intrinsics.checkNotNullExpressionValue((Object)gitBranchState, (String)"readState(...)");
                GitBranchState state2 = gitBranchState;
                boolean isShallow = this.repositoryReader.hasShallowCommits();
                Collection<GitBranchTrackInfo> collection2 = config.parseTrackInfos((Collection<? extends GitLocalBranch>)state2.getLocalBranches().keySet(), (Collection<? extends GitRemoteBranch>)state2.getRemoteBranches().keySet());
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"parseTrackInfos(...)");
                Collection<GitBranchTrackInfo> trackInfos = collection2;
                GitHooksInfo gitHooksInfo = this.repositoryReader.readHooksInfo();
                Intrinsics.checkNotNullExpressionValue((Object)gitHooksInfo, (String)"readHooksInfo(...)");
                GitHooksInfo hooksInfo = gitHooksInfo;
                File submoduleFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getRoot()), ".gitmodules");
                Collection<GitSubmoduleInfo> submodules = new GitModulesFileReader().read(submoduleFile);
                Map localBranches2 = new HashMap<GitLocalBranch, Hash>(state2.getLocalBranches());
                this.recentCheckoutBranches = GitRecentCheckoutBranches.collectRecentCheckoutBranches(this, (Function1<? super GitLocalBranch, Boolean>)((Function1)new Function1<GitLocalBranch, Boolean>((Map<GitLocalBranch, ? extends Hash>)localBranches2){
                    final /* synthetic */ Map<GitLocalBranch, Hash> $localBranches;
                    {
                        this.$localBranches = $localBranches;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GitLocalBranch branch) {
                        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                        return this.$localBranches.containsKey(branch);
                    }
                }));
                GitLocalBranch gitLocalBranch = state2.getCurrentBranch();
                String string = state2.getCurrentRevision();
                Repository.State state3 = state2.getState();
                Intrinsics.checkNotNullExpressionValue((Object)state3, (String)"getState(...)");
                gitRepoInfo2 = new GitRepoInfo(gitLocalBranch, string, state3, (Collection<GitRemote>)new LinkedHashSet<GitRemote>(remotes), localBranches2, (Map<GitRemoteBranch, ? extends Hash>)new HashMap<GitRemoteBranch, Hash>(state2.getRemoteBranches()), (Collection<? extends GitBranchTrackInfo>)new LinkedHashSet<GitBranchTrackInfo>(trackInfos), submodules, hooksInfo, isShallow);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            gitRepoInfo = gitRepoInfo2;
        }
        catch (CancellationException e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.recordException((Throwable)e$iv$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv$iv;
        }
        catch (ProcessCanceledException e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.recordException((Throwable)e$iv$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv$iv;
        }
        catch (Throwable e$iv$iv$iv) {
            $this$useWithoutActiveScope$iv$iv$iv.recordException(e$iv$iv$iv, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv$iv.end();
        }
        return gitRepoInfo;
    }

    public void dispose() {
        super.dispose();
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    @NotNull
    public String toLogString() {
        return "GitRepository " + this.getRoot() + " : " + this.repoInfo;
    }

    @JvmStatic
    @Deprecated(message="Use {@link GitRepositoryManager#getRepositoryForRoot} to obtain an instance of a Git repository.")
    @NotNull
    public static final GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        return Companion.getInstance(root, project, listenToRepoChanges);
    }

    @JvmStatic
    @Deprecated(message="Use {@link #createInstance(VirtualFile, Project, Disposable)}")
    @ApiStatus.Internal
    @NotNull
    public static final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        return Companion.createInstance(root, project, parentDisposable, listenToRepoChanges);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
        return Companion.createInstance(root, project, parentDisposable);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final GitRepository createInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable) {
        return Companion.createInstance(root, gitDir, project, parentDisposable);
    }

    public /* synthetic */ GitRepositoryImpl(Project project, VirtualFile rootDir, VirtualFile gitDir, Disposable parentDisposable, DefaultConstructorMarker $constructor_marker) {
        this(project, rootDir, gitDir, parentDisposable);
    }

    static {
        Logger logger = Logger.getInstance(GitRepositoryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/repo/GitRepositoryImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createInstance", "Lgit4idea/repo/GitRepository;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listenToRepoChanges", "", "gitDir", "getInstance", "notifyIfRepoChanged", "", "repository", "previousInfo", "Lgit4idea/repo/GitRepoInfo;", "info", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Deprecated(message="Use {@link GitRepositoryManager#getRepositoryForRoot} to obtain an instance of a Git repository.")
        @NotNull
        public final GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
            Object object = ObjectUtils.notNull((Object)repository, () -> Companion.getInstance$lambda$0(root, project));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"notNull(...)");
            return (GitRepository)object;
        }

        @JvmStatic
        @Deprecated(message="Use {@link #createInstance(VirtualFile, Project, Disposable)}")
        @ApiStatus.Internal
        @NotNull
        public final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            return this.createInstance(root, project, parentDisposable);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
            VirtualFile gitDir;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            VirtualFile virtualFile = gitDir = Objects.requireNonNull(GitUtil.findGitDir(root));
            Intrinsics.checkNotNull((Object)virtualFile);
            return this.createInstance(root, virtualFile, project, parentDisposable);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final GitRepository createInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)gitDir, (String)"gitDir");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ProgressManager.checkCanceled();
            GitRepositoryImpl repository = new GitRepositoryImpl(project, root, gitDir, parentDisposable, null);
            GitRepositoryUpdater updater = new GitRepositoryUpdater(repository, repository.repositoryFiles);
            Disposer.register((Disposable)((Disposable)repository), (Disposable)updater);
            GitRepositoryManager.getInstance(project).notifyListenersAsync(repository);
            return repository;
        }

        private final void notifyIfRepoChanged(GitRepository repository, GitRepoInfo previousInfo, GitRepoInfo info) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (!project2.isDisposed() && !Intrinsics.areEqual((Object)info, (Object)previousInfo)) {
                GitRepositoryManager.getInstance(project2).notifyListenersAsync(repository);
            }
        }

        private static final GitRepository getInstance$lambda$0(VirtualFile $root, Project $project) {
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            return Companion.createInstance($root, $project, GitDisposable.Companion.getInstance($project));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

