/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitPushSpecParser {
    private static final Logger LOG = Logger.getInstance(GitPushSpecParser.class);

    GitPushSpecParser() {
    }

    @Nullable
    static String getTargetRef(@NotNull GitRepository repository, @NotNull String sourceBranchName, @NotNull List<String> specs) {
        if (repository == null) {
            GitPushSpecParser.$$$reportNull$$$0(0);
        }
        if (sourceBranchName == null) {
            GitPushSpecParser.$$$reportNull$$$0(1);
        }
        if (specs == null) {
            GitPushSpecParser.$$$reportNull$$$0(2);
        }
        for (String spec : specs) {
            String target = GitPushSpecParser.getTarget(spec, sourceBranchName);
            if (target == null) {
                LOG.info("Push spec [" + spec + "] in " + repository.getRoot() + " is invalid or doesn't match source branch " + sourceBranchName);
                continue;
            }
            return target;
        }
        return null;
    }

    @Nullable
    private static String getTarget(@NotNull String spec, @NotNull String sourceBranch) {
        String sourceWoStar;
        String[] parts;
        if (spec == null) {
            GitPushSpecParser.$$$reportNull$$$0(3);
        }
        if (sourceBranch == null) {
            GitPushSpecParser.$$$reportNull$$$0(4);
        }
        if ((parts = spec.split(":")).length != 2) {
            return null;
        }
        String source = parts[0].trim();
        String target = parts[1].trim();
        if (!GitPushSpecParser.isStarPositionValid(source = StringUtil.trimStart((String)source, (String)"+"), target)) {
            return null;
        }
        source = GitBranchUtil.stripRefsPrefix(source);
        sourceBranch = GitBranchUtil.stripRefsPrefix(sourceBranch);
        if (source.equals("HEAD") || source.equals(sourceBranch)) {
            return target;
        }
        if (source.endsWith("*") && sourceBranch.startsWith(sourceWoStar = source.substring(0, source.length() - 1))) {
            String starMeaning = sourceBranch.substring(sourceWoStar.length());
            return target.replace("*", starMeaning);
        }
        return null;
    }

    private static boolean isStarPositionValid(@NotNull String source, @NotNull String target) {
        if (source == null) {
            GitPushSpecParser.$$$reportNull$$$0(5);
        }
        if (target == null) {
            GitPushSpecParser.$$$reportNull$$$0(6);
        }
        int sourceStar = source.indexOf(42);
        int targetStar = target.indexOf(42);
        return sourceStar < 0 && targetStar < 0 || sourceStar == source.length() - 1 && targetStar == target.length() - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranchName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "git4idea/push/GitPushSpecParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetRef";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTarget";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isStarPositionValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

