/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import git4idea.GitVcs;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitCompressedDetailsCollector;
import git4idea.history.GitLogUtil;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H\u0016J6\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgit4idea/log/GitLogIndexer;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;)V", "getGitCommitRequirements", "Lgit4idea/history/GitCommitRequirements;", "repository", "Lgit4idea/repo/GitRepository;", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "readAllFullDetails", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "encoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "commitConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$CompressedDetails;", "readFullDetails", "hashes", "", "", "intellij.vcs.git"})
public final class GitLogIndexer
implements VcsLogIndexer {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;

    public GitLogIndexer(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        this.project = project;
        this.repositoryManager = repositoryManager;
    }

    public void readAllFullDetails(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder encoder, @NotNull Consumer<? super VcsLogIndexer.CompressedDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = GitLogProvider.getRepository(this.repositoryManager, root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitCommitRequirements requirements = this.getGitCommitRequirements(repository);
        GitCompressedDetailsCollector gitCompressedDetailsCollector = new GitCompressedDetailsCollector(this.project, root, encoder);
        java.util.function.Consumer<Object> consumer2 = arg_0 -> GitLogIndexer.readAllFullDetails$lambda$0((Function1)new Function1<VcsLogIndexer.CompressedDetails, Unit>(commitConsumer){

            public final void invoke(VcsLogIndexer.CompressedDetails p0) {
                ((Consumer)this.receiver).consume((Object)p0);
            }
        }, arg_0);
        String[] stringArray = ArrayUtil.toStringArray((Collection)GitLogUtil.LOG_ALL);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        String[] stringArray2 = stringArray;
        gitCompressedDetailsCollector.readFullDetails(consumer2, requirements, true, Arrays.copyOf(stringArray2, stringArray2.length));
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull VcsLogIndexer.PathsEncoder encoder, @NotNull Consumer<? super VcsLogIndexer.CompressedDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes2, (String)"hashes");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = GitLogProvider.getRepository(this.repositoryManager, root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitCommitRequirements requirements = this.getGitCommitRequirements(repository);
        new GitCompressedDetailsCollector(this.project, root, encoder).readFullDetailsForHashes(hashes2, requirements, true, arg_0 -> GitLogIndexer.readFullDetails$lambda$1((Function1)new Function1<VcsLogIndexer.CompressedDetails, Unit>(commitConsumer){

            public final void invoke(VcsLogIndexer.CompressedDetails p0) {
                ((Consumer)this.receiver).consume((Object)p0);
            }
        }, arg_0));
    }

    private final GitCommitRequirements getGitCommitRequirements(GitRepository repository) {
        return new GitCommitRequirements(GitLogProvider.shouldIncludeRootChanges(repository), GitCommitRequirements.DiffRenames.Limit.Exact.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    private static final void readAllFullDetails$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void readFullDetails$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

