/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitDeleteTagOperation
extends GitBranchOperation {
    @NotNull
    private final String myTagName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final Map<GitRepository, String> myDeletedTagTips;

    GitDeleteTagOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories2, @NotNull String tagName) {
        if (project == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(2);
        }
        if (repositories2 == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(3);
        }
        if (tagName == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories2);
        this.myDeletedTagTips = new HashMap<GitRepository, String>();
        this.myTagName = tagName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    public void execute() {
        for (GitRepository repository : this.getRepositories()) {
            try {
                GitRevisionNumber revisionNumber = GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "refs/tags/" + this.myTagName);
                this.myDeletedTagTips.put(repository, revisionNumber.asString());
            }
            catch (VcsException e) {
                String title = !GitUtil.justOneGitRepository(this.myProject) ? GitBundle.message("delete.tag.operation.could.not.find.tag.in", repository.getPresentableUrl()) : GitBundle.message("delete.tag.operation.could.not.find.tag", this.myTagName);
                this.fatalError(title, "");
                return;
            }
        }
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.deleteTag(repository, this.myTagName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.getRepositoryFiles().refreshTagsFiles();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(GitBundle.message("delete.tag.operation.tag.was.not.deleted", this.myTagName), result2);
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void notifySuccess() {
        String message = GitBundle.message("delete.tag.operation.deleted.tag", this.myTagName);
        Notification notification2 = VcsNotifier.standardNotification().createNotification("", message, NotificationType.INFORMATION);
        notification2.setDisplayId("git.tag.deleted");
        notification2.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.GitDeleteTagOperation.text.restore", new Object[0]), () -> this.restoreInBackground(notification2)));
        int remotes = 0;
        for (GitRepository repository : this.getRepositories()) {
            remotes += repository.getRemotes().size();
        }
        if (remotes > 0) {
            String text2 = GitBundle.message("delete.tag.operation.delete.on.remote", remotes);
            notification2.addAction((AnAction)NotificationAction.createSimple((String)text2, () -> this.pushRemotesInBackground()));
        }
        this.myNotifier.notify(notification2);
    }

    private void restoreInBackground(final @NotNull Notification notification2) {
        if (notification2 == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(5);
        }
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.tag.operation.restoring.tag.process", this.myTagName)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitDeleteTagOperation.this.rollbackTagDeletion(notification2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteTagOperation$1", "run"));
            }
        }.queue();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (result2.totalSuccess()) {
            Notification notification2 = VcsNotifier.standardNotification().createNotification(GitBundle.message("delete.tag.operation.rollback.successful", new Object[0]), GitBundle.message("delete.tag.operation.restored.tag", this.myTagName), NotificationType.INFORMATION);
            notification2.setDisplayId("git.tag.restored");
            this.myNotifier.notify(notification2);
        } else {
            this.myNotifier.notifyError("git.tag.deletion.rollback.error", GitBundle.message("delete.tag.operation.error.during.rollback.of.tag.deletion", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    private void rollbackTagDeletion(@NotNull Notification notification2) {
        GitCompoundResult result2;
        if (notification2 == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(6);
        }
        if ((result2 = this.doRollback()).totalSuccess()) {
            notification2.expire();
        } else {
            this.myNotifier.notifyError("git.tag.deletion.rollback.error", GitBundle.message("delete.tag.operation.could.not.restore.tag", GitUIUtil.code(this.myTagName)), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult res = this.myGit.createNewTag(repository, this.myTagName, null, this.myDeletedTagTips.get(repository));
            result2.append(repository, res);
            repository.getRepositoryFiles().refreshTagsFiles();
        }
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(7);
        }
        return gitCompoundResult;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message("delete.tag.operation.however.tag.deletion.has.succeeded.for.the.following", this.getSkippedRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("delete.tag.operation.you.may.rollback.not.to.let.tags.diverge", this.myTagName)).toString();
        if (string == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    private void pushRemotesInBackground() {
        GitBrancher.getInstance(this.myProject).deleteRemoteTag(this.myTagName, ContainerUtil.map2Map(this.getRepositories(), it -> Pair.create((Object)it, (Object)this.myDeletedTagTips.get(it))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitDeleteTagOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitDeleteTagOperation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRollback";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreInBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rollbackTagDeletion";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

