/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.CompareWithLocalDialog;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitReference;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCompareBranchesUi;
import git4idea.branch.GitShowDiffWithBranchPanel;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;

    GitBrancherImpl(@NotNull Project project) {
        if (project == null) {
            GitBrancherImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories2) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(1);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(2);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.new.branch.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$1", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(3);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(4);
        }
        this.createBranch(name, startPoints, null);
    }

    @NotNull
    private GitBranchWorker newWorker(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GitBrancherImpl.$$$reportNull$$$0(5);
        }
        return new GitBranchWorker(this.myProject, Git.getInstance(), new GitBranchUiHandlerImpl(this.myProject, indicator));
    }

    @NotNull
    private GitBranchWorker newWorkerWithoutRollback(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GitBrancherImpl.$$$reportNull$$$0(6);
        }
        return new GitBranchWorker(this.myProject, Git.getInstance(), new GitBranchUiHandlerImpl(this.myProject, indicator){

            @Override
            public boolean showUnmergedFilesMessageWithRollback(@NotNull String operationName, @NotNull String rollbackProposal) {
                if (operationName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (rollbackProposal == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "operationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rollbackProposal";
                        break;
                    }
                }
                objectArray[1] = "git4idea/branch/GitBrancherImpl$2";
                objectArray[2] = "showUnmergedFilesMessageWithRollback";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(7);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(8);
        }
        this.createBranch(name, startPoints, false, callInAwtLater);
    }

    @Override
    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints, boolean force) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(9);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(10);
        }
        this.createBranch(name, startPoints, force, null);
    }

    @Override
    public void createBranch(final @NotNull String name, final @NotNull Map<GitRepository, String> startPoints, final boolean force, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(11);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(12);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.creating.branch.process", name), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createBranch(name, startPoints, force);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$3", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<? extends GitRepository> repositories2, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(13);
        }
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(14);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(15);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.new.branch.process", name), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$4", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<? extends GitRepository> repositories2, @Nullable Runnable callInAwtLater) {
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(16);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(17);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.process", reference), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$5", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<? extends GitRepository> repositories2, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(18);
        }
        if (startPoint == null) {
            GitBrancherImpl.$$$reportNull$$$0(19);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(20);
        }
        this.checkoutNewBranchStartingFrom(newBranchName, startPoint, false, repositories2, callInAwtLater);
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final boolean overwriteIfNeeded, final @NotNull List<? extends GitRepository> repositories2, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(21);
        }
        if (startPoint == null) {
            GitBrancherImpl.$$$reportNull$$$0(22);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(23);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.branch.from.process", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, overwriteIfNeeded, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$6", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(24);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(25);
        }
        this.deleteBranches(Collections.singletonMap(branchName, repositories2), null);
    }

    @Override
    public void deleteBranches(final @NotNull Map<String, List<? extends GitRepository>> branchesToContainingRepositories, @Nullable Runnable callInAwtAfterExecution) {
        if (branchesToContainingRepositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(26);
        }
        if (branchesToContainingRepositories.isEmpty()) {
            return;
        }
        final Set<String> branchNames = branchesToContainingRepositories.keySet();
        String branchMsg = branchNames.size() == 1 ? branchNames.iterator().next() : StringUtil.join(branchNames, (String)", ");
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.branch.process", branchMsg), callInAwtAfterExecution){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                GitBranchWorker worker = GitBrancherImpl.this.newWorker(indicator);
                for (String branchName : branchNames) {
                    worker.deleteBranch(branchName, branchesToContainingRepositories.getOrDefault(branchName, Collections.emptyList()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$7", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(27);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(28);
        }
        this.deleteRemoteBranches(Collections.singletonList(branchName), repositories2);
    }

    @Override
    public void deleteRemoteBranches(final @NotNull List<String> branchNames, final @NotNull List<? extends GitRepository> repositories2) {
        if (branchNames == null) {
            GitBrancherImpl.$$$reportNull$$$0(29);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(30);
        }
        if (branchNames.isEmpty()) {
            return;
        }
        String branchMsg = branchNames.size() == 1 ? branchNames.iterator().next() : StringUtil.join(branchNames, (String)", ");
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.remote.branch", branchMsg), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    8.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranches(branchNames, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$8", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void compare(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(31);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(32);
        }
        new GitCompareBranchesUi(this.myProject, repositories2, branchName).open();
    }

    @Override
    public void compareAny(@NotNull String branchName, @NotNull String otherBranchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(33);
        }
        if (otherBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(34);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(35);
        }
        new GitCompareBranchesUi(this.myProject, repositories2, branchName, otherBranchName).open();
    }

    @Override
    public void showDiffWithLocal(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(36);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(37);
        }
        new GitShowDiffWithBranchPanel(this.myProject, branchName, repositories2, GitBranchUtil.getCurrentBranchOrRev(repositories2)).showAsTab();
    }

    @Override
    public void showDiff(@NotNull String branchName, @NotNull String otherBranchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(38);
        }
        if (otherBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(39);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(40);
        }
        String dialogTitle = GitBundle.message("git.log.diff.handler.changes.between.revisions.title", branchName, otherBranchName);
        CompareWithLocalDialog.showChanges((Project)this.myProject, (String)dialogTitle, (CompareWithLocalDialog.LocalContent)CompareWithLocalDialog.LocalContent.NONE, () -> {
            ArrayList<Change> changes = new ArrayList<Change>();
            for (GitRepository repository : repositories2) {
                VirtualFile root = repository.getRoot();
                changes.addAll(GitChangeUtils.getDiff(this.myProject, root, branchName, otherBranchName, Collections.singleton(VcsUtil.getFilePath((VirtualFile)root))));
            }
            return changes;
        });
    }

    @Override
    public void merge(@NotNull GitReference reference, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull @NotNull List<? extends @NotNull GitRepository> repositories2) {
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(41);
        }
        if (deleteOnMerge == null) {
            GitBrancherImpl.$$$reportNull$$$0(42);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(43);
        }
        this.merge(reference, deleteOnMerge, repositories2, true);
    }

    @Override
    public void merge(final @NotNull GitReference reference, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull @NotNull List<? extends @NotNull GitRepository> repositories2, final @NotNull Boolean allowRollback) {
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(44);
        }
        if (deleteOnMerge == null) {
            GitBrancherImpl.$$$reportNull$$$0(45);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(46);
        }
        if (allowRollback == null) {
            GitBrancherImpl.$$$reportNull$$$0(47);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.merging.process", reference.getName()), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    9.$$$reportNull$$$0(0);
                }
                GitBranchWorker worker = allowRollback != false ? GitBrancherImpl.this.newWorker(indicator) : GitBrancherImpl.this.newWorkerWithoutRollback(indicator);
                worker.merge(reference, deleteOnMerge, (List<? extends GitRepository>)repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$9", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(48);
        }
        if (deleteOnMerge == null) {
            GitBrancherImpl.$$$reportNull$$$0(49);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(50);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.merging.process", branchName), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    10.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, (List<? extends GitRepository>)repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$10", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories2, final @NotNull String branchName) {
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(51);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(52);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.rebasing.onto.process", branchName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    11.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories2, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$11", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebaseOnCurrent(@NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(53);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(54);
        }
        this.rebase(repositories2, "HEAD", branchName);
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories2, final @NotNull String upstream, final @NotNull String branchName) {
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(55);
        }
        if (upstream == null) {
            GitBrancherImpl.$$$reportNull$$$0(56);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(57);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.rebasing.process", branchName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    12.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories2, upstream, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$12", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void renameBranch(final @NotNull String currentName, final @NotNull String newName, final @NotNull List<? extends GitRepository> repositories2) {
        if (currentName == null) {
            GitBrancherImpl.$$$reportNull$$$0(58);
        }
        if (newName == null) {
            GitBrancherImpl.$$$reportNull$$$0(59);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(60);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.renaming.branch.process", currentName, newName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    13.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).renameBranch(currentName, newName, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$13", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteTag(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories2) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(61);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(62);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.tag.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    14.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteTag(name, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$14", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteTag(final @NotNull String name, final @NotNull Map<GitRepository, String> repositories2) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(63);
        }
        if (repositories2 == null) {
            GitBrancherImpl.$$$reportNull$$$0(64);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.tag.on.remote.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    15.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteTag(name, repositories2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$15", "execute"));
            }
        }.runInBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoints";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: 
            case 16: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 48: 
            case 52: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesToContainingRepositories";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNames";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranchName";
                break;
            }
            case 42: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteOnMerge";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowRollback";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstream";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "git4idea/branch/GitBrancherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkoutNewBranch";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createBranch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "newWorker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "newWorkerWithoutRollback";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewTag";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkout";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkoutNewBranchStartingFrom";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBranch";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBranches";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteBranch";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteBranches";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAny";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiffWithLocal";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiff";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "rebase";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "rebaseOnCurrent";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[2] = "renameBranch";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteTag";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @Nls @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            if (title == null) {
                CommonBackgroundTask.$$$reportNull$$$0(0);
            }
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CommonBackgroundTask.$$$reportNull$$$0(1);
            }
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                application.invokeAndWait(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "git4idea/branch/GitBrancherImpl$CommonBackgroundTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

