/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotatedLineModificationDetails;
import com.intellij.openapi.vcs.annotate.AnnotationTooltipBuilder;
import com.intellij.openapi.vcs.annotate.DefaultLineModificationDetailsProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.log.GitCommitTooltipLinkHandler;
import git4idea.repo.GitRepository;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitFileAnnotation
extends FileAnnotation {
    private static final Logger LOG = Logger.getInstance(GitFileAnnotation.class);
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    @Nullable
    private Object2IntMap<VcsRevisionNumber> myRevisionMap;
    @NotNull
    private final Map<VcsRevisionNumber, String> myCommitMessageMap;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        if (project == null) {
            GitFileAnnotation.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GitFileAnnotation.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            GitFileAnnotation.$$$reportNull$$$0(2);
        }
        if (lines == null) {
            GitFileAnnotation.$$$reportNull$$$0(3);
        }
        super(project);
        this.myCommitMessageMap = new HashMap<VcsRevisionNumber, String>();
        this.DATE_ASPECT = new GitAnnotationAspect("Date", VcsBundle.message((String)"line.annotation.aspect.date", (Object[])new Object[0]), true){

            @Override
            public String doGetValue(LineInfo info) {
                Date date = GitFileAnnotation.getDate(info);
                return FileAnnotation.formatDate((Date)date);
            }
        };
        this.REVISION_ASPECT = new GitAnnotationAspect("Revision", VcsBundle.message((String)"line.annotation.aspect.revision", (Object[])new Object[0]), false){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return lineInfo.getRevisionNumber().getShortRev();
            }
        };
        this.AUTHOR_ASPECT = new GitAnnotationAspect("Author", VcsBundle.message((String)"line.annotation.aspect.author", (Object[])new Object[0]), true){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return VcsUserUtil.toExactString((VcsUser)lineInfo.getAuthorUser());
            }
        };
        this.myProject = project;
        this.myFile = file2;
        this.myFilePath = filePath;
        this.myVcs = GitVcs.getInstance(this.myProject);
        this.myBaseRevision = revision;
        this.myLines = lines;
    }

    public LineAnnotationAspect @NotNull [] getAspects() {
        LineAnnotationAspect[] lineAnnotationAspectArray = new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
        if (lineAnnotationAspectArray == null) {
            GitFileAnnotation.$$$reportNull$$$0(4);
        }
        return lineAnnotationAspectArray;
    }

    @NotNull
    private static Date getDate(LineInfo info) {
        VcsLogApplicationSettings logSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
        Date date = Boolean.TRUE.equals(logSettings.get(CommonUiProperties.PREFER_COMMIT_DATE)) ? info.getCommitterDate() : info.getAuthorDate();
        if (date == null) {
            GitFileAnnotation.$$$reportNull$$$0(5);
        }
        return date;
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFilePath, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        if (revisions == null) {
            GitFileAnnotation.$$$reportNull$$$0(6);
        }
        this.myRevisions = revisions;
        this.myRevisionMap = new Object2IntOpenHashMap();
        for (int i = 0; i < this.myRevisions.size(); ++i) {
            this.myRevisionMap.put((Object)this.myRevisions.get(i).getRevisionNumber(), i);
        }
    }

    public void setCommitMessage(@NotNull VcsRevisionNumber revisionNumber, @NotNull String message) {
        if (revisionNumber == null) {
            GitFileAnnotation.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GitFileAnnotation.$$$reportNull$$$0(8);
        }
        this.myCommitMessageMap.put(revisionNumber, message);
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @NlsContexts.Tooltip
    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        Object commitMessage;
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        if (lineInfo == null) {
            return null;
        }
        AnnotationTooltipBuilder atb = new AnnotationTooltipBuilder(this.myProject, asHtml);
        GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
        atb.appendRevisionLine((VcsRevisionNumber)revisionNumber, it -> GitCommitTooltipLinkHandler.createLink(it.asString(), it));
        atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.author", (Object[])new Object[]{VcsUserUtil.toExactString((VcsUser)lineInfo.getAuthorUser())}));
        atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.date", (Object[])new Object[]{DateFormatUtil.formatDateTime((Date)GitFileAnnotation.getDate(lineInfo))}));
        if (!this.myFilePath.equals(lineInfo.getFilePath())) {
            String path = VcsUtil.getPresentablePath((Project)this.myProject, (FilePath)lineInfo.getFilePath(), (boolean)true, (boolean)false);
            atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.path", (Object[])new Object[]{path}));
        }
        if ((commitMessage = this.getCommitMessage((VcsRevisionNumber)revisionNumber)) == null) {
            commitMessage = lineInfo.getSubject() + "\n...";
        }
        atb.appendCommitMessageBlock((String)commitMessage);
        return atb.toString();
    }

    @NlsSafe
    @Nullable
    public String getCommitMessage(@NotNull VcsRevisionNumber revisionNumber) {
        if (revisionNumber == null) {
            GitFileAnnotation.$$$reportNull$$$0(9);
        }
        if (this.myRevisions != null && this.myRevisionMap != null && this.myRevisionMap.containsKey((Object)revisionNumber)) {
            VcsFileRevision fileRevision = this.myRevisions.get(this.myRevisionMap.getInt((Object)revisionNumber));
            return fileRevision.getCommitMessage();
        }
        return this.myCommitMessageMap.get(revisionNumber);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? GitFileAnnotation.getDate(lineInfo) : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        List<LineInfo> list2 = this.myLines;
        if (list2 == null) {
            GitFileAnnotation.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GitFileAnnotation.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            GitFileAnnotation.$$$reportNull$$$0(12);
        }
        return filePath;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        if (number == null) {
            GitFileAnnotation.$$$reportNull$$$0(13);
        }
        if (!this.myFile.isInLocalFileSystem()) {
            return false;
        }
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @NotNull
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return new GitCurrentFileRevisionProvider();
    }

    @NotNull
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new GitPreviousFileRevisionProvider();
    }

    @NotNull
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        return new GitAuthorsMappingProvider();
    }

    @NotNull
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        return new GitRevisionsOrderProvider();
    }

    @NotNull
    public FileAnnotation.RevisionChangesProvider getRevisionsChangesProvider() {
        return new GitRevisionChangesProvider();
    }

    @NotNull
    public FileAnnotation.LineModificationDetailsProvider getLineModificationDetailsProvider() {
        return new GitLineModificationDetailsProvider();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/annotate/GitFileAnnotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/annotate/GitFileAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspects";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRevisions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCommitMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommitMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBaseRevisionChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class LineInfo {
        @NotNull
        private final CommitInfo myCommitInfo;
        private final int myLineNumber;
        private final int myOriginalLineNumber;

        public LineInfo(@NotNull CommitInfo commitInfo, int lineNumber, int originalLineNumber) {
            if (commitInfo == null) {
                LineInfo.$$$reportNull$$$0(0);
            }
            this.myCommitInfo = commitInfo;
            this.myLineNumber = lineNumber;
            this.myOriginalLineNumber = originalLineNumber;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getOriginalLineNumber() {
            return this.myOriginalLineNumber;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            GitRevisionNumber gitRevisionNumber = this.myCommitInfo.getRevisionNumber();
            if (gitRevisionNumber == null) {
                LineInfo.$$$reportNull$$$0(1);
            }
            return gitRevisionNumber;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myCommitInfo.getFilePath();
            if (filePath == null) {
                LineInfo.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            VcsFileRevision vcsFileRevision = this.myCommitInfo.getFileRevision();
            if (vcsFileRevision == null) {
                LineInfo.$$$reportNull$$$0(3);
            }
            return vcsFileRevision;
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            return this.myCommitInfo.getPreviousFileRevision();
        }

        @NotNull
        public Date getCommitterDate() {
            Date date = this.myCommitInfo.getCommitterDate();
            if (date == null) {
                LineInfo.$$$reportNull$$$0(4);
            }
            return date;
        }

        @NotNull
        public Date getAuthorDate() {
            Date date = this.myCommitInfo.getAuthorDate();
            if (date == null) {
                LineInfo.$$$reportNull$$$0(5);
            }
            return date;
        }

        @NotNull
        @Nls
        public String getAuthor() {
            String string = this.myCommitInfo.getAuthor();
            if (string == null) {
                LineInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public VcsUser getAuthorUser() {
            VcsUser vcsUser = this.myCommitInfo.getAuthorUser();
            if (vcsUser == null) {
                LineInfo.$$$reportNull$$$0(7);
            }
            return vcsUser;
        }

        @NlsSafe
        @NotNull
        public String getSubject() {
            String string = this.myCommitInfo.getSubject();
            if (string == null) {
                LineInfo.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/annotate/GitFileAnnotation$LineInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/annotate/GitFileAnnotation$LineInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileRevision";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitterDate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorDate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorUser";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private class GitCurrentFileRevisionProvider
    implements FileAnnotation.CurrentFileRevisionProvider {
        private GitCurrentFileRevisionProvider() {
        }

        @Nullable
        public VcsFileRevision getRevision(int lineNumber) {
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        }
    }

    private class GitPreviousFileRevisionProvider
    implements FileAnnotation.PreviousFileRevisionProvider {
        private GitPreviousFileRevisionProvider() {
        }

        @Nullable
        public VcsFileRevision getPreviousRevision(int lineNumber) {
            int index;
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            VcsFileRevision previousFileRevision = lineInfo.getPreviousFileRevision();
            if (previousFileRevision != null) {
                return previousFileRevision;
            }
            GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
            if (GitFileAnnotation.this.myRevisions != null && GitFileAnnotation.this.myRevisionMap != null && GitFileAnnotation.this.myRevisionMap.containsKey((Object)revisionNumber) && (index = GitFileAnnotation.this.myRevisionMap.getInt((Object)revisionNumber)) + 1 < GitFileAnnotation.this.myRevisions.size()) {
                return GitFileAnnotation.this.myRevisions.get(index + 1);
            }
            return null;
        }

        @Nullable
        public VcsFileRevision getLastRevision() {
            if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                return new GitFileRevision(GitFileAnnotation.this.myProject, GitFileAnnotation.this.myFilePath, (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
            }
            return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
        }
    }

    private class GitAuthorsMappingProvider
    implements FileAnnotation.AuthorsMappingProvider {
        private final Map<VcsRevisionNumber, String> myAuthorsMap = new HashMap<VcsRevisionNumber, String>();

        GitAuthorsMappingProvider() {
            for (int i = 0; i < GitFileAnnotation.this.getLineCount(); ++i) {
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(i);
                if (lineInfo == null || this.myAuthorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
                this.myAuthorsMap.put((VcsRevisionNumber)lineInfo.getRevisionNumber(), lineInfo.getAuthor());
            }
        }

        @NotNull
        public Map<VcsRevisionNumber, String> getAuthors() {
            Map<VcsRevisionNumber, String> map2 = this.myAuthorsMap;
            if (map2 == null) {
                GitAuthorsMappingProvider.$$$reportNull$$$0(0);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$GitAuthorsMappingProvider", "getAuthors"));
        }
    }

    private class GitRevisionsOrderProvider
    implements FileAnnotation.RevisionsOrderProvider {
        private final List<List<VcsRevisionNumber>> myOrderedRevisions = new ArrayList<List<VcsRevisionNumber>>();

        GitRevisionsOrderProvider() {
            ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
            for (int i = 0; i < GitFileAnnotation.this.getLineCount(); ++i) {
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(i);
                if (lineInfo == null) continue;
                GitRevisionNumber number = lineInfo.getRevisionNumber();
                Date date = lineInfo.getCommitterDate();
                dates.putValue((Object)date, (Object)number);
            }
            NavigableSet orderedDates = dates.navigableKeySet();
            for (Date date : orderedDates.descendingSet()) {
                Collection revisionNumbers = dates.get((Object)date);
                this.myOrderedRevisions.add(new ArrayList(revisionNumbers));
            }
        }

        @NotNull
        public List<List<VcsRevisionNumber>> getOrderedRevisions() {
            List<List<VcsRevisionNumber>> list2 = this.myOrderedRevisions;
            if (list2 == null) {
                GitRevisionsOrderProvider.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$GitRevisionsOrderProvider", "getOrderedRevisions"));
        }
    }

    private class GitRevisionChangesProvider
    implements FileAnnotation.RevisionChangesProvider {
        private GitRevisionChangesProvider() {
        }

        @NotNull
        public Pair<? extends CommittedChangeList, FilePath> getChangesIn(int lineNumber) throws VcsException {
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                throw new IllegalArgumentException(VcsBundle.message((String)"error.annotated.line.out.of.bounds", (Object[])new Object[]{lineNumber, GitFileAnnotation.this.getLineCount()}));
            }
            GitRepository repository = GitUtil.getRepositoryForFile(GitFileAnnotation.this.myProject, lineInfo.getFilePath());
            GitCommittedChangeList changeList2 = GitCommittedChangeListProvider.getCommittedChangeList(GitFileAnnotation.this.myProject, repository.getRoot(), lineInfo.getRevisionNumber());
            Pair pair = Pair.create((Object)((Object)changeList2), (Object)lineInfo.getFilePath());
            if (pair == null) {
                GitRevisionChangesProvider.$$$reportNull$$$0(0);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$GitRevisionChangesProvider", "getChangesIn"));
        }
    }

    private class GitLineModificationDetailsProvider
    implements FileAnnotation.LineModificationDetailsProvider {
        private GitLineModificationDetailsProvider() {
        }

        @Nullable
        public AnnotatedLineModificationDetails getDetails(int lineNumber) throws VcsException {
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            String afterContent = DefaultLineModificationDetailsProvider.loadRevision((Project)GitFileAnnotation.this.myProject, (VcsFileRevision)lineInfo.getFileRevision(), (FilePath)GitFileAnnotation.this.myFilePath);
            if (afterContent == null) {
                return null;
            }
            String beforeContent = DefaultLineModificationDetailsProvider.loadRevision((Project)GitFileAnnotation.this.myProject, (VcsFileRevision)lineInfo.getPreviousFileRevision(), (FilePath)GitFileAnnotation.this.myFilePath);
            int originalLineNumber = lineInfo.getOriginalLineNumber() - 1;
            return DefaultLineModificationDetailsProvider.createDetailsFor((String)beforeContent, (String)afterContent, (int)originalLineNumber);
        }
    }

    public static class CommitInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myCommitterDate;
        @NotNull
        private final Date myAuthorDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        @NlsSafe
        private final String mySubject;

        public CommitInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date committerDate, @NotNull Date authorDate, @NotNull VcsUser author, @NotNull @NlsSafe String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            if (project == null) {
                CommitInfo.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                CommitInfo.$$$reportNull$$$0(1);
            }
            if (path == null) {
                CommitInfo.$$$reportNull$$$0(2);
            }
            if (committerDate == null) {
                CommitInfo.$$$reportNull$$$0(3);
            }
            if (authorDate == null) {
                CommitInfo.$$$reportNull$$$0(4);
            }
            if (author == null) {
                CommitInfo.$$$reportNull$$$0(5);
            }
            if (subject == null) {
                CommitInfo.$$$reportNull$$$0(6);
            }
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myCommitterDate = committerDate;
            this.myAuthorDate = authorDate;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            GitRevisionNumber gitRevisionNumber = this.myRevision;
            if (gitRevisionNumber == null) {
                CommitInfo.$$$reportNull$$$0(7);
            }
            return gitRevisionNumber;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                CommitInfo.$$$reportNull$$$0(8);
            }
            return filePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getCommitterDate() {
            Date date = this.myCommitterDate;
            if (date == null) {
                CommitInfo.$$$reportNull$$$0(9);
            }
            return date;
        }

        @NotNull
        public Date getAuthorDate() {
            Date date = this.myAuthorDate;
            if (date == null) {
                CommitInfo.$$$reportNull$$$0(10);
            }
            return date;
        }

        @NotNull
        @Nls
        public String getAuthor() {
            String string = this.myAuthor.getName();
            if (string == null) {
                CommitInfo.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        public VcsUser getAuthorUser() {
            VcsUser vcsUser = this.myAuthor;
            if (vcsUser == null) {
                CommitInfo.$$$reportNull$$$0(12);
            }
            return vcsUser;
        }

        @NotNull
        @Nls
        public String getSubject() {
            String string = this.mySubject;
            if (string == null) {
                CommitInfo.$$$reportNull$$$0(13);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "committerDate";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authorDate";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subject";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/annotate/GitFileAnnotation$CommitInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/annotate/GitFileAnnotation$CommitInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitterDate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorDate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorUser";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        GitAnnotationAspect(@NlsContexts.ListItem String id, String displayName, boolean showByDefault) {
            super(id, displayName, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue(GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                CompletableFuture shownInLog;
                LineInfo info = GitFileAnnotation.this.myLines.get(lineNum);
                VirtualFile root = ProjectLevelVcsManager.getInstance((Project)GitFileAnnotation.this.myProject).getVcsRootFor(GitFileAnnotation.this.myFilePath);
                if (root == null) {
                    return;
                }
                if (ModalityState.current() == ModalityState.nonModal() && Registry.is((String)"vcs.blame.show.affected.files.in.log")) {
                    Hash hash = HashImpl.build((String)info.getRevisionNumber().asString());
                    shownInLog = VcsLogNavigationUtil.jumpToRevisionAsync((Project)GitFileAnnotation.this.myProject, (VirtualFile)root, (Hash)hash, (FilePath)info.getFilePath());
                } else {
                    shownInLog = CompletableFuture.completedFuture(false);
                }
                shownInLog.whenCompleteAsync((success2, ex) -> {
                    if (ex instanceof CancellationException) {
                        return;
                    }
                    if (ex != null) {
                        LOG.error(ex);
                    }
                    if (!Boolean.TRUE.equals(success2)) {
                        AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (FilePath)GitFileAnnotation.this.myFilePath, (boolean)false, () -> GitFileAnnotation.this.getRevisionsChangesProvider().getChangesIn(lineNum));
                    }
                }, (Executor)EdtExecutorService.getInstance());
            }
        }
    }
}

