/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.tag;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitReference;
import git4idea.GitTag;
import git4idea.actions.tag.GitSingleTagAction;
import git4idea.branch.GitBrancher;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/tag/GitMergeTagAction;", "Lgit4idea/actions/tag/GitSingleTagAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "reference", "Lgit4idea/GitTag;", "updateIfEnabledAndVisible", "intellij.vcs.git"})
public final class GitMergeTagAction
extends GitSingleTagAction {
    public GitMergeTagAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.merge.into.current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitTag reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        super.updateIfEnabledAndVisible(e, project, repositories2, (GitReference)reference);
        String string = reference.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String selectedTagName = string;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        Object[] objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(selectedTagName), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        String string2 = GitBundle.message("branches.merge.into", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String description2 = string2;
        presentation3.setDescription(description2);
        GitBranchPopupActions.addTooltipText(presentation3, description2);
        Object[] objectArray2 = new Object[]{GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, selectedTagName), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        String string3 = GitBundle.message("branches.merge.into", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String name = string3;
        presentation3.setText(name);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitTag reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        GitBrancher.getInstance(project).merge(reference, GitBrancher.DeleteOnMergeOption.NOTHING, repositories2);
    }
}

