/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.actions.tag.GitSingleRefAction;
import git4idea.branch.GitBrancher;
import git4idea.config.GitSharedSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lgit4idea/actions/branch/GitMergeRefAction;", "Lgit4idea/actions/tag/GitSingleRefAction;", "Lgit4idea/GitReference;", "()V", "disabledForCurrent", "", "getDisabledForCurrent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "reference", "deleteOnMerge", "Lgit4idea/branch/GitBrancher$DeleteOnMergeOption;", "updateIfEnabledAndVisible", "intellij.vcs.git"})
public final class GitMergeRefAction
extends GitSingleRefAction<GitReference> {
    private final boolean disabledForCurrent;

    public GitMergeRefAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.merge.into.current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
        this.disabledForCurrent = true;
    }

    @Override
    public boolean getDisabledForCurrent() {
        return this.disabledForCurrent;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitReference reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        GitBrancher.getInstance(project).merge(reference, this.deleteOnMerge(reference, project), repositories2);
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitReference reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        Object[] objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, reference.getName()), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setText(GitBundle.message("branches.merge.into", objectArray));
        objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(reference.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message("branches.merge.into", objectArray));
        objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(reference.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        GitBranchPopupActions.addTooltipText($this$updateIfEnabledAndVisible_u24lambda_u240, GitBundle.message("branches.merge.into", objectArray));
    }

    private final GitBrancher.DeleteOnMergeOption deleteOnMerge(GitReference reference, Project project) {
        return reference instanceof GitBranch && !((GitBranch)reference).isRemote() && !GitSharedSettings.getInstance(project).isBranchProtected(((GitBranch)reference).getName()) ? GitBrancher.DeleteOnMergeOption.PROPOSE : GitBrancher.DeleteOnMergeOption.NOTHING;
    }
}

