/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.tools.projectWizard.KotlinModuleBuilder;
import org.jetbrains.kotlin.tools.projectWizard.Versions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000bH\u0014J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/KotlinModuleBuilder;", "Lcom/intellij/ide/util/projectWizard/JavaModuleBuilder;", "existingKotlinStdLib", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "isCreatingNewProject", "", "useCompactProjectStructure", "(Lcom/intellij/openapi/roots/LibraryOrderEntry;ZZ)V", "applyKotlinCodeStyle", "", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "applyKotlinCompilerArguments", "modifiableRootModel", "createKotlinJavaRuntime", "createKotlinSourcePaths", "contentEntry", "Lcom/intellij/openapi/roots/ContentEntry;", "doAddContentEntry", "enableNewProjectInspections", "project", "Lcom/intellij/openapi/project/Project;", "resolveRelativePath", "Ljava/io/File;", "relativePath", "", "setupKotlinLibrary", "setupRootModel", "Companion", "KotlinSourceEntry", "kotlin.project-wizard.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleBuilder.kt\norg/jetbrains/kotlin/tools/projectWizard/KotlinModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1855#2,2:221\n*S KotlinDebug\n*F\n+ 1 KotlinModuleBuilder.kt\norg/jetbrains/kotlin/tools/projectWizard/KotlinModuleBuilder\n*L\n139#1:221,2\n*E\n"})
public final class KotlinModuleBuilder
extends JavaModuleBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final LibraryOrderEntry existingKotlinStdLib;
    private final boolean isCreatingNewProject;
    private final boolean useCompactProjectStructure;
    @NotNull
    private static final String DEFAULT_JVM_TARGET = "1.8";
    @NotNull
    private static final String REPLACE_UNTIL_WITH_RANGE_UNTIL_INSPECTION_NAME = "ReplaceUntilWithRangeUntil";

    public KotlinModuleBuilder(@Nullable LibraryOrderEntry existingKotlinStdLib, boolean isCreatingNewProject, boolean useCompactProjectStructure2) {
        this.existingKotlinStdLib = existingKotlinStdLib;
        this.isCreatingNewProject = isCreatingNewProject;
        this.useCompactProjectStructure = useCompactProjectStructure2;
        this.setSourcePaths(CollectionsKt.emptyList());
    }

    private final File resolveRelativePath(String relativePath) {
        String string = this.getContentEntryPath();
        if (string == null) {
            return null;
        }
        String contentEntryPath = string;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        return new File(contentEntryPath, StringsKt.replace$default((String)relativePath, (String)"/", (String)string2, (boolean)false, (int)4, null));
    }

    private final void createKotlinSourcePaths(ContentEntry contentEntry) {
        List list2;
        if (this.useCompactProjectStructure) {
            var3_2 = new KotlinSourceEntry[4];
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"SOURCE");
            var3_2[0] = new KotlinSourceEntry("src", (JpsModuleSourceRootType)javaSourceRootType, false, 4, null);
            JavaResourceRootType javaResourceRootType = JavaResourceRootType.RESOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaResourceRootType, (String)"RESOURCE");
            var3_2[1] = new KotlinSourceEntry("resources", (JpsModuleSourceRootType)javaResourceRootType, false);
            JavaSourceRootType javaSourceRootType2 = JavaSourceRootType.TEST_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType2, (String)"TEST_SOURCE");
            var3_2[2] = new KotlinSourceEntry("test", (JpsModuleSourceRootType)javaSourceRootType2, false);
            JavaResourceRootType javaResourceRootType2 = JavaResourceRootType.TEST_RESOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaResourceRootType2, (String)"TEST_RESOURCE");
            var3_2[3] = new KotlinSourceEntry("testResources", (JpsModuleSourceRootType)javaResourceRootType2, false);
            list2 = CollectionsKt.listOf((Object[])var3_2);
        } else {
            var3_2 = new KotlinSourceEntry[4];
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"SOURCE");
            var3_2[0] = new KotlinSourceEntry("src/main/kotlin", (JpsModuleSourceRootType)javaSourceRootType, false, 4, null);
            JavaResourceRootType javaResourceRootType = JavaResourceRootType.RESOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaResourceRootType, (String)"RESOURCE");
            var3_2[1] = new KotlinSourceEntry("src/main/resources", (JpsModuleSourceRootType)javaResourceRootType, false, 4, null);
            JavaSourceRootType javaSourceRootType3 = JavaSourceRootType.TEST_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType3, (String)"TEST_SOURCE");
            var3_2[2] = new KotlinSourceEntry("src/test/kotlin", (JpsModuleSourceRootType)javaSourceRootType3, false, 4, null);
            JavaResourceRootType javaResourceRootType3 = JavaResourceRootType.TEST_RESOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaResourceRootType3, (String)"TEST_RESOURCE");
            var3_2[3] = new KotlinSourceEntry("src/test/resources", (JpsModuleSourceRootType)javaResourceRootType3, false, 4, null);
            list2 = CollectionsKt.listOf((Object[])var3_2);
        }
        List entries2 = list2;
        for (KotlinSourceEntry entry : entries2) {
            File path2;
            if (this.resolveRelativePath(entry.getPath()) == null) continue;
            if (entry.getShouldCreate()) {
                path2.mkdirs();
            }
            contentEntry.addSourceFolder(VfsUtil.pathToUrl((String)path2.getPath()), entry.getType());
        }
    }

    @Nullable
    protected ContentEntry doAddContentEntry(@NotNull ModifiableRootModel modifiableRootModel) {
        Intrinsics.checkNotNullParameter((Object)modifiableRootModel, (String)"modifiableRootModel");
        ContentEntry contentEntry = super.doAddContentEntry(modifiableRootModel);
        if (contentEntry == null) {
            return null;
        }
        ContentEntry contentEntry2 = contentEntry;
        this.createKotlinSourcePaths(contentEntry2);
        return contentEntry2;
    }

    private final LibraryOrderEntry createKotlinJavaRuntime(ModifiableRootModel rootModel) {
        LibraryEx.ModifiableModelEx modifiableModelEx;
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(rootModel.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        LibraryTable projectLibraryTable = libraryTable;
        Library library2 = projectLibraryTable.createLibrary("KotlinJavaRuntime");
        LibraryEx libraryEx = library2 instanceof LibraryEx ? (LibraryEx)library2 : null;
        if (libraryEx == null) {
            return null;
        }
        LibraryEx kotlinJavaRuntime = libraryEx;
        LibraryEx.ModifiableModelEx $this$createKotlinJavaRuntime_u24lambda_u241 = modifiableModelEx = kotlinJavaRuntime.getModifiableModel();
        boolean bl = false;
        $this$createKotlinJavaRuntime_u24lambda_u241.setKind(RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties repositoryProperties = new RepositoryLibraryProperties("org.jetbrains.kotlin", "kotlin-stdlib", Versions.INSTANCE.getKOTLIN().getText(), true, CollectionsKt.emptyList());
        $this$createKotlinJavaRuntime_u24lambda_u241.setProperties((LibraryProperties)repositoryProperties);
        Collection dependencies2 = JarRepositoryManager.loadDependenciesModal((Project)rootModel.getProject(), (RepositoryLibraryProperties)repositoryProperties, (boolean)true, (boolean)true, null, null);
        Intrinsics.checkNotNull((Object)dependencies2);
        Iterable $this$forEach$iv = dependencies2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrderRoot it = (OrderRoot)element$iv;
            boolean bl2 = false;
            $this$createKotlinJavaRuntime_u24lambda_u241.addRoot(it.getFile(), it.getType());
        }
        modifiableModelEx.commit();
        return rootModel.addLibraryEntry((Library)kotlinJavaRuntime);
    }

    private final void setupKotlinLibrary(ModifiableRootModel rootModel) {
        block1: {
            LibraryOrderEntry stdLib;
            LibraryOrderEntry libraryOrderEntry;
            LibraryOrderEntry libraryOrderEntry2 = this.existingKotlinStdLib;
            if (libraryOrderEntry2 == null) {
                libraryOrderEntry2 = this.createKotlinJavaRuntime(rootModel);
            }
            if ((libraryOrderEntry = (stdLib = libraryOrderEntry2)) == null || (libraryOrderEntry = libraryOrderEntry.getLibrary()) == null) break block1;
            LibraryOrderEntry it = libraryOrderEntry;
            boolean bl = false;
            rootModel.addLibraryEntry((Library)it);
        }
    }

    private final void applyKotlinCompilerArguments(ModifiableRootModel modifiableRootModel) {
        Project project2 = modifiableRootModel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Kotlin2JvmCompilerArgumentsHolder jvmCompilerArgumentsHolder = Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(project2);
        if (((K2JVMCompilerArguments)jvmCompilerArgumentsHolder.getSettings()).getJvmTarget() == null) {
            jvmCompilerArgumentsHolder.update(applyKotlinCompilerArguments.1.INSTANCE);
        }
        Project project3 = modifiableRootModel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        KotlinCommonCompilerArgumentsHolder commonCompilerArgumentsHolder = KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project3);
        CommonCompilerArguments commonSettings = (CommonCompilerArguments)commonCompilerArgumentsHolder.getSettings();
        Object object = IdeKotlinVersion.Companion.parse-IoAF18A(Versions.INSTANCE.getKOTLIN().getText());
        IdeKotlinVersion kotlinVersion2 = (IdeKotlinVersion)(Result.isFailure-impl((Object)object) ? null : object);
        if (commonSettings.getApiVersion() == null && commonSettings.getLanguageVersion() == null && kotlinVersion2 != null) {
            commonCompilerArgumentsHolder.update((Function1)new Function1<CommonCompilerArguments, Unit>(kotlinVersion2){
                final /* synthetic */ IdeKotlinVersion $kotlinVersion;
                {
                    this.$kotlinVersion = $kotlinVersion;
                    super(1);
                }

                public final void invoke(@NotNull CommonCompilerArguments $this$update) {
                    Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                    KotlinFacetSettingsKt.setApiVersionView((CommonCompilerArguments)$this$update, (VersionView)((VersionView)new VersionView.Specific((LanguageOrApiVersion)this.$kotlinVersion.getApiVersion())));
                    KotlinFacetSettingsKt.setLanguageVersionView((CommonCompilerArguments)$this$update, (VersionView)((VersionView)new VersionView.Specific((LanguageOrApiVersion)this.$kotlinVersion.getLanguageVersion())));
                }
            });
        }
    }

    private final void applyKotlinCodeStyle(ModifiableRootModel rootModel) {
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)rootModel.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        CodeStyleSettings existingSettings = codeStyleSettings;
        if (CodeStyleUtilsKt.kotlinCodeStyleDefaults((CodeStyleSettings)existingSettings) != null) {
            return;
        }
        Project project2 = rootModel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProjectCodeStyleImporter.INSTANCE.apply(project2, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
    }

    private final void enableNewProjectInspections(Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String projectProfile = ProjectInspectionProfileManager.Companion.getInstance(project2).getProjectProfile();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)REPLACE_UNTIL_WITH_RANGE_UNTIL_INSPECTION_NAME);
        if (projectProfile != null && key != null) {
            InspectionProfileManager.getInstance((Project)project2).getProfile(projectProfile).setErrorLevel(key, HighlightDisplayLevel.WEAK_WARNING, project2);
        }
    }

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) {
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        super.setupRootModel(rootModel);
        this.setupKotlinLibrary(rootModel);
        this.applyKotlinCompilerArguments(rootModel);
        this.applyKotlinCodeStyle(rootModel);
        if (this.isCreatingNewProject) {
            Project project2 = rootModel.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            this.enableNewProjectInspections(project2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/KotlinModuleBuilder$Companion;", "", "()V", "DEFAULT_JVM_TARGET", "", "REPLACE_UNTIL_WITH_RANGE_UNTIL_INSPECTION_NAME", "kotlin.project-wizard.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/KotlinModuleBuilder$KotlinSourceEntry;", "", "path", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "shouldCreate", "", "(Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;Z)V", "getPath", "()Ljava/lang/String;", "getShouldCreate", "()Z", "getType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.project-wizard.idea"})
    private static final class KotlinSourceEntry {
        @NotNull
        private final String path;
        @NotNull
        private final JpsModuleSourceRootType<?> type;
        private final boolean shouldCreate;

        public KotlinSourceEntry(@NotNull String path2, @NotNull JpsModuleSourceRootType<?> type2, boolean shouldCreate) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(type2, (String)"type");
            this.path = path2;
            this.type = type2;
            this.shouldCreate = shouldCreate;
        }

        public /* synthetic */ KotlinSourceEntry(String string, JpsModuleSourceRootType jpsModuleSourceRootType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(string, jpsModuleSourceRootType, bl);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> getType() {
            return this.type;
        }

        public final boolean getShouldCreate() {
            return this.shouldCreate;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.shouldCreate;
        }

        @NotNull
        public final KotlinSourceEntry copy(@NotNull String path2, @NotNull JpsModuleSourceRootType<?> type2, boolean shouldCreate) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(type2, (String)"type");
            return new KotlinSourceEntry(path2, type2, shouldCreate);
        }

        public static /* synthetic */ KotlinSourceEntry copy$default(KotlinSourceEntry kotlinSourceEntry, String string, JpsModuleSourceRootType jpsModuleSourceRootType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = kotlinSourceEntry.path;
            }
            if ((n & 2) != 0) {
                jpsModuleSourceRootType = kotlinSourceEntry.type;
            }
            if ((n & 4) != 0) {
                bl = kotlinSourceEntry.shouldCreate;
            }
            return kotlinSourceEntry.copy(string, jpsModuleSourceRootType, bl);
        }

        @NotNull
        public String toString() {
            return "KotlinSourceEntry(path=" + this.path + ", type=" + this.type + ", shouldCreate=" + this.shouldCreate + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.shouldCreate);
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof KotlinSourceEntry)) {
                return false;
            }
            KotlinSourceEntry kotlinSourceEntry = (KotlinSourceEntry)other2;
            if (!Intrinsics.areEqual((Object)this.path, (Object)kotlinSourceEntry.path)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.type, kotlinSourceEntry.type)) {
                return false;
            }
            return this.shouldCreate == kotlinSourceEntry.shouldCreate;
        }
    }
}

