/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeNullability;
import org.jetbrains.kotlin.asJava.elements.KtLightDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0012H\u0000\"-\u0010\u0000\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"METHOD_NULLABILITY_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/codeInsight/Nullability;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getExpressionDfaNullability", "Lcom/intellij/codeInspection/dataFlow/DfaNullability;", "expr", "Lcom/intellij/psi/PsiExpression;", "getMethodNullabilityByDfa", "method", "Lcom/intellij/psi/PsiMethod;", "getTypeParameterNullability", "psiTypeParameter", "Lcom/intellij/psi/PsiTypeParameter;", "isUsedInAutoUnboxingContext", "", "Lcom/intellij/psi/PsiReferenceExpression;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nnullabilityUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nullabilityUtils.kt\norg/jetbrains/kotlin/nj2k/NullabilityUtilsKt\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,72:1\n28#2,2:73\n36#3,8:75\n*S KotlinDebug\n*F\n+ 1 nullabilityUtils.kt\norg/jetbrains/kotlin/nj2k/NullabilityUtilsKt\n*L\n34#1:73,2\n34#1:75,8\n*E\n"})
public final class NullabilityUtilsKt {
    @NotNull
    private static final Key<CachedValue<Nullability>> METHOD_NULLABILITY_KEY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Nullability getTypeParameterNullability(@NotNull PsiTypeParameter psiTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)psiTypeParameter, (String)"psiTypeParameter");
        KtLightDeclaration ktLightDeclaration = psiTypeParameter instanceof KtLightDeclaration ? (KtLightDeclaration)psiTypeParameter : null;
        KtDeclaration ktDeclaration = ktLightDeclaration != null ? (KtDeclaration)ktLightDeclaration.getKotlinOrigin() : null;
        KtTypeParameter ktTypeParameter = ktDeclaration instanceof KtTypeParameter ? (KtTypeParameter)ktDeclaration : null;
        if (ktTypeParameter == null) {
            return Nullability.UNKNOWN;
        }
        KtTypeParameter ktTypeParameter2 = ktTypeParameter;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)ktTypeParameter2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktTypeParameter2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)ktTypeParameter2);
        try {
            KaSession $this$getTypeParameterNullability_u24lambda_u240 = analysisSession$iv$iv;
            boolean bl = false;
            for (KaType upperBound : $this$getTypeParameterNullability_u24lambda_u240.getSymbol(ktTypeParameter2).getUpperBounds()) {
                if (upperBound.getNullability() != KaTypeNullability.NON_NULLABLE) continue;
                Nullability nullability = Nullability.NOT_NULL;
                return nullability;
            }
            Nullability nullability = Nullability.NULLABLE;
            return nullability;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)ktTypeParameter2);
        }
    }

    public static final boolean isUsedInAutoUnboxingContext(@NotNull PsiReferenceExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        PsiType exprType = expr.getType();
        if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)exprType)) {
            return false;
        }
        PsiType psiType = ExpectedTypeUtils.findExpectedType((PsiExpression)((PsiExpression)expr), (boolean)false);
        if (psiType == null) {
            return false;
        }
        PsiType expectedType = psiType;
        if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType)) {
            return false;
        }
        PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)exprType);
        if (psiPrimitiveType == null) {
            return false;
        }
        PsiPrimitiveType unboxedType = psiPrimitiveType;
        return expectedType.isAssignableFrom((PsiType)unboxedType);
    }

    @Nullable
    public static final DfaNullability getExpressionDfaNullability(@NotNull PsiExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        CommonDataflow.DataflowResult dataflowResult = CommonDataflow.getDataflowResult((PsiElement)((PsiElement)expr));
        if (dataflowResult == null) {
            return null;
        }
        CommonDataflow.DataflowResult dataflowResult2 = dataflowResult;
        DfType dfType = dataflowResult2.getDfType(expr);
        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
        DfType dfType2 = dfType;
        if (!(dfType2 instanceof DfReferenceType)) {
            return null;
        }
        return ((DfReferenceType)dfType2).getNullability();
    }

    @NotNull
    public static final Nullability getMethodNullabilityByDfa(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object object = CachedValuesManager.getManager((Project)method.getProject()).getCachedValue((UserDataHolder)method, METHOD_NULLABILITY_KEY, () -> NullabilityUtilsKt.getMethodNullabilityByDfa$lambda$1(method), false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Nullability)object;
    }

    private static final CachedValueProvider.Result getMethodNullabilityByDfa$lambda$1(PsiMethod $method) {
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return new CachedValueProvider.Result((Object)DfaUtil.inferMethodNullability((PsiMethod)$method), objectArray);
    }

    static {
        Key key = Key.create((String)"METHOD_NULLABILITY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        METHOD_NULLABILITY_KEY = key;
    }
}

