/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structuralsearch.filters;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.ui.SimpleColoredComponent;
import java.awt.Container;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0014J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/structuralsearch/filters/OneStateFilter;", "Lcom/intellij/structuralsearch/plugin/ui/filters/FilterAction;", "name", "Ljava/util/function/Supplier;", "", "label", "constraintName", "(Ljava/util/function/Supplier;Ljava/lang/String;Ljava/lang/String;)V", "getConstraintName", "()Ljava/lang/String;", "getLabel", "getName", "()Ljava/util/function/Supplier;", "clearFilter", "", "getEditor", "Lcom/intellij/structuralsearch/plugin/ui/filters/FilterEditor;", "Lcom/intellij/structuralsearch/NamedScriptableDefinition;", "hasFilter", "", "isApplicable", "nodes", "", "Lcom/intellij/psi/PsiElement;", "completePattern", "target", "setLabel", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "Companion", "kotlin.code-insight.structural-search.k1"})
public abstract class OneStateFilter
extends FilterAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<String> name;
    @NotNull
    private final String label;
    @NotNull
    private final String constraintName;
    @NotNull
    public static final String ENABLED = "enabled";

    public OneStateFilter(@Nls @NotNull Supplier<String> name2, @Nls @NotNull String label2, @NonNls @NotNull String constraintName) {
        Intrinsics.checkNotNullParameter(name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)constraintName, (String)"constraintName");
        super(name2);
        this.name = name2;
        this.label = label2;
        this.constraintName = constraintName;
    }

    @NotNull
    public final Supplier<String> getName() {
        return this.name;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final String getConstraintName() {
        return this.constraintName;
    }

    protected void setLabel(@Nullable SimpleColoredComponent component2) {
        this.myLabel.append(this.label);
    }

    public boolean hasFilter() {
        MatchVariableConstraint matchVariableConstraint = this.myTable.getMatchVariable();
        if (matchVariableConstraint == null) {
            return false;
        }
        MatchVariableConstraint variable2 = matchVariableConstraint;
        return Intrinsics.areEqual((Object)variable2.getAdditionalConstraint(this.constraintName), (Object)ENABLED);
    }

    public void clearFilter() {
        block0: {
            MatchVariableConstraint matchVariableConstraint = this.myTable.getMatchVariable();
            if (matchVariableConstraint == null) break block0;
            matchVariableConstraint.putAdditionalConstraint(this.constraintName, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isApplicable(@NotNull List<? extends PsiElement> nodes, boolean completePattern, boolean target2) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        if (!(this.myTable.getVariable() instanceof MatchVariableConstraint)) return false;
        StructuralSearchProfile structuralSearchProfile = this.myTable.getProfile();
        Intrinsics.checkNotNull((Object)structuralSearchProfile);
        if (!structuralSearchProfile.isApplicableConstraint(this.constraintName, nodes, completePattern, target2)) return false;
        return true;
    }

    @NotNull
    public FilterEditor<? extends NamedScriptableDefinition> getEditor() {
        MatchVariableConstraint matchVariableConstraint = this.myTable.getMatchVariable();
        Runnable runnable = this.myTable.getConstraintChangedCallback();
        return (FilterEditor)new FilterEditor<MatchVariableConstraint>(this, matchVariableConstraint, runnable){
            @NotNull
            private final JLabel myLabel;
            final /* synthetic */ OneStateFilter this$0;
            {
                this.this$0 = $receiver;
                super((NamedScriptableDefinition)$super_call_param$1, $super_call_param$2);
                this.myLabel = new JLabel($receiver.getLabel());
            }

            @NotNull
            public final JLabel getMyLabel() {
                return this.myLabel;
            }

            @NotNull
            public JComponent getPreferredFocusedComponent() {
                return this.myLabel;
            }

            @NotNull
            public JComponent[] getFocusableComponents() {
                JComponent[] jComponentArray = new JComponent[]{this.myLabel};
                return jComponentArray;
            }

            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myLabel)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel)));
            }

            protected void loadValues() {
            }

            protected void saveValues() {
                ((MatchVariableConstraint)this.myConstraint).putAdditionalConstraint(this.this$0.getConstraintName(), "enabled");
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/structuralsearch/filters/OneStateFilter$Companion;", "", "()V", "ENABLED", "", "kotlin.code-insight.structural-search.k1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

