/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.projectView.KtDeclarationTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public final class KotlinRunConfigurationEditor
extends SettingsEditor<KotlinRunConfiguration>
implements PanelWithAnchor {
    private JPanel mainPanel;
    private LabeledComponent<ClassEditorField> mainClass;
    private CommonJavaParametersPanel commonProgramParameters;
    private LabeledComponent<ModuleDescriptionsComboBox> moduleChooser;
    private JrePathEditor jrePathEditor;
    private LabeledComponent<ShortenCommandLineModeCombo> shortenClasspathModeCombo;
    private JComponent anchor;
    private final ConfigurationModuleSelector moduleSelector;
    private final Project project;

    private static ClassBrowser createApplicationClassBrowser(Project project2, Computable<? extends Module> moduleSelector, final LabeledComponent<ModuleDescriptionsComboBox> moduleChooser) {
        final ClassFilter applicationClass = new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return aClass instanceof KtLightClass && ConfigurationUtil.MAIN_CLASS.value((Object)aClass) && 1.findMainMethod(aClass) != null;
            }

            @Nullable
            private static PsiMethod findMainMethod(PsiClass aClass) {
                return (PsiMethod)ReadAction.compute(() -> PsiMethodUtil.findMainMethod((PsiClass)aClass));
            }
        };
        return new ClassBrowser.MainClassBrowser(project2, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0])){

            protected ClassFilter createFilter(Module module2) {
                return applicationClass;
            }

            protected void onClassChosen(@NotNull PsiClass psiClass2) {
                Module module2;
                if (psiClass2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass2)) != null && ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module2))) {
                    ((ModuleDescriptionsComboBox)moduleChooser.getComponent()).setSelectedModule(module2);
                }
            }

            protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
                Project project2 = this.getProject();
                return new TreeJavaClassChooserDialog(this.myTitle, project2, classFilter.getScope(), (ClassFilter)classFilter, null, null, true){

                    @Nullable
                    protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node2) {
                        PsiNamedElement element3;
                        PsiClass parent2;
                        List elements2;
                        Object treeNode;
                        Object userObject = node2.getUserObject();
                        if (userObject instanceof ClassTreeNode) {
                            ClassTreeNode treeNode2 = (ClassTreeNode)userObject;
                            return treeNode2.getPsiClass();
                        }
                        KtFile ktElement = null;
                        if (userObject instanceof KtFileTreeNode) {
                            treeNode = (KtFileTreeNode)((Object)userObject);
                            ktElement = ((KtFileTreeNode)((Object)treeNode)).getKtFile();
                        }
                        if (userObject instanceof KtDeclarationTreeNode) {
                            treeNode = (KtDeclarationTreeNode)((Object)userObject);
                            ktElement = ((KtDeclarationTreeNode)((Object)treeNode)).getDeclaration();
                        }
                        if (ktElement != null && !(elements2 = LightClassUtilsKt.toLightElements((KtElement)ktElement)).isEmpty() && (parent2 = (PsiClass)PsiUtilsKt.getParentOfTypes((PsiElement)(element3 = (PsiNamedElement)elements2.get(0)), (boolean)false, (Class[])new Class[]{PsiClass.class})) != null) {
                            return parent2;
                        }
                        return null;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/run/KotlinRunConfigurationEditor$2", "onClassChosen"));
            }
        };
    }

    public KotlinRunConfigurationEditor(Project project2) {
        this.project = project2;
        this.$$$setupUI$$$();
        this.moduleSelector = new ConfigurationModuleSelector(project2, (ModuleDescriptionsComboBox)this.moduleChooser.getComponent());
        this.jrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies((ModuleDescriptionsComboBox)((ModuleDescriptionsComboBox)this.moduleChooser.getComponent()), (boolean)false));
        this.commonProgramParameters.setModuleContext(this.moduleSelector.getModule());
        ((ModuleDescriptionsComboBox)this.moduleChooser.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinRunConfigurationEditor.this.commonProgramParameters.setModuleContext(KotlinRunConfigurationEditor.this.moduleSelector.getModule());
            }
        });
        this.anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.mainClass, this.commonProgramParameters, this.jrePathEditor, this.jrePathEditor, this.moduleChooser, this.shortenClasspathModeCombo});
        this.shortenClasspathModeCombo.setComponent((JComponent)new ShortenCommandLineModeCombo(project2, this.jrePathEditor, (ModuleDescriptionsComboBox)this.moduleChooser.getComponent()));
    }

    protected void applyEditorTo(@NotNull KotlinRunConfiguration configuration2) {
        if (configuration2 == null) {
            KotlinRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.commonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration2);
        this.moduleSelector.applyTo((ModuleBasedConfiguration)configuration2);
        configuration2.setRunClass(((ClassEditorField)this.mainClass.getComponent()).getClassName());
        configuration2.setAlternativeJrePath(this.jrePathEditor.getJrePathOrName());
        configuration2.setAlternativeJrePathEnabled(this.jrePathEditor.isAlternativeJreSelected());
        configuration2.setShortenCommandLine(((ShortenCommandLineModeCombo)this.shortenClasspathModeCombo.getComponent()).getSelectedItem());
    }

    protected void resetEditorFrom(@NotNull KotlinRunConfiguration configuration2) {
        if (configuration2 == null) {
            KotlinRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.commonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration2);
        this.moduleSelector.reset((ModuleBasedConfiguration)configuration2);
        String runClass = configuration2.getRunClass();
        ((ClassEditorField)this.mainClass.getComponent()).setText(runClass != null ? runClass.replaceAll("\\$", "\\.") : "");
        this.jrePathEditor.setPathOrName(configuration2.getAlternativeJrePath(), configuration2.isAlternativeJrePathEnabled());
        ((ShortenCommandLineModeCombo)this.shortenClasspathModeCombo.getComponent()).setSelectedItem((Object)configuration2.getShortenCommandLine());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            KotlinRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.mainClass = new LabeledComponent();
        this.mainClass.setComponent((JComponent)ClassEditorField.createClassField((Project)this.project, () -> this.moduleSelector.getModule(), (declaration2, place) -> {
            KtLightClass aClass;
            if (declaration2 instanceof KtLightClass && ConfigurationUtil.MAIN_CLASS.value((Object)(aClass = (KtLightClass)declaration2)) && (PsiMethodUtil.findMainMethod((PsiClass)aClass) != null || place.getParent() != null) && this.moduleSelector.findClass(((PsiClass)declaration2).getQualifiedName()) != null) {
                return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
            }
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }, (BrowseModuleValueActionListener)KotlinRunConfigurationEditor.createApplicationClassBrowser(this.project, (Computable<? extends Module>)((Computable)() -> this.moduleSelector.getModule()), this.moduleChooser)));
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mainClass.setAnchor(anchor);
        this.commonProgramParameters.setAnchor(anchor);
        this.jrePathEditor.setAnchor(anchor);
        this.moduleChooser.setAnchor(anchor);
        this.shortenClasspathModeCombo.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent2;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<ClassEditorField> labeledComponent3 = this.mainClass;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinRunConfigurationEditor.class).getString("application.configuration.main.class.label"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.commonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.moduleChooser = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinRunConfigurationEditor.class).getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.jrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.shortenClasspathModeCombo = labeledComponent = new LabeledComponent();
        labeledComponent.setEnabled(true);
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinRunConfigurationEditor.class).getString("application.configuration.shorten.command.line.label"));
        jPanel.add((Component)labeledComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/run/KotlinRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

