/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.reporter;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.reporter.ITNReporterCompat;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002JI\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016J?\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001f0\u001eH\u0016\u00a2\u0006\u0002\u0010 R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter;", "Lorg/jetbrains/kotlin/idea/reporter/ITNReporterCompat;", "()V", "isIdeaAndKotlinRelease", "", "()Z", "isIdeaAndKotlinRelease$delegate", "Lkotlin/Lazy;", "markEventForK2", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "event", "showDialog", "", "parent", "Ljava/awt/Component;", "message", "", "title", "options", "", "defaultOptionIndex", "icon", "Ljavax/swing/Icon;", "(Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ILjavax/swing/Icon;)I", "showErrorInRelease", "submitCompat", "events", "additionalInfo", "parentComponent", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "([Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/util/Consumer;)Z", "kotlin.base.plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinReportSubmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,114:1\n81#2:115\n73#2:116\n254#3:117\n*S KotlinDebug\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter\n*L\n44#1:115\n49#1:116\n73#1:117\n*E\n"})
public final class KotlinReportSubmitter
extends ITNReporterCompat {
    @NotNull
    private final Lazy isIdeaAndKotlinRelease$delegate = LazyKt.lazy((Function0)isIdeaAndKotlinRelease.2.INSTANCE);

    private final boolean isIdeaAndKotlinRelease() {
        Lazy lazy = this.isIdeaAndKotlinRelease$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean showErrorInRelease(@NotNull IdeaLoggingEvent event) {
        boolean kotlinNotificationEnabled;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal()) {
            return true;
        }
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean bl = kotlinNotificationEnabled = !Intrinsics.areEqual((Object)"disabled", (Object)System.getProperty("kotlin.fatal.error.notification", "enabled"));
        if (!kotlinNotificationEnabled) {
            return false;
        }
        if (!this.isIdeaAndKotlinRelease()) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean submitCompat(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @Nullable Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> consumer) {
        IdeaLoggingEvent[] ideaLoggingEventArray;
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (KotlinPluginModeProvider.Companion.isK2Mode()) {
            IdeaLoggingEvent[] $this$map2Array$iv = events;
            boolean $i$f$map2Array = false;
            int n = 0;
            int n2 = $this$map2Array$iv.length;
            IdeaLoggingEvent[] ideaLoggingEventArray2 = new IdeaLoggingEvent[n2];
            while (n < n2) {
                void p0;
                IdeaLoggingEvent ideaLoggingEvent;
                int n3 = n++;
                IdeaLoggingEvent ideaLoggingEvent2 = $this$map2Array$iv[n3];
                int n4 = n3;
                IdeaLoggingEvent[] ideaLoggingEventArray3 = ideaLoggingEventArray2;
                boolean bl = false;
                ideaLoggingEventArray3[n4] = ideaLoggingEvent = this.markEventForK2((IdeaLoggingEvent)p0);
            }
            ideaLoggingEventArray = ideaLoggingEventArray2;
        } else {
            ideaLoggingEventArray = events;
        }
        IdeaLoggingEvent[] effectiveEvents = ideaLoggingEventArray;
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (KotlinIdePlugin.INSTANCE.getHasPatchedVersion()) {
            ReportMessages.GROUP.createNotification(KotlinBasePluginBundle.message("reporter.text.can.t.report.exception.from.patched.plugin", new Object[0]), NotificationType.INFORMATION).setImportant(false).notify(project2);
            return true;
        }
        return super.submitCompat(effectiveEvents, additionalInfo, parentComponent, consumer);
    }

    private final IdeaLoggingEvent markEventForK2(IdeaLoggingEvent event) {
        if (event instanceof IdeaReportingEvent) {
            AbstractMessage abstractMessage = ((IdeaReportingEvent)event).getData();
            String string = ((IdeaReportingEvent)event).getMessage();
            if (string == null) {
                string = "";
            }
            return (IdeaLoggingEvent)new IdeaReportingEvent(abstractMessage, KotlinReportSubmitter.markEventForK2$patchMessage(string), ((IdeaReportingEvent)event).getThrowableText(), ((IdeaReportingEvent)event).getPlugin());
        }
        if (Intrinsics.areEqual(event.getClass(), IdeaLoggingEvent.class)) {
            String string = event.getMessage();
            if (string == null) {
                string = "";
            }
            return new IdeaLoggingEvent(KotlinReportSubmitter.markEventForK2$patchMessage(string), event.getThrowable(), event.getData());
        }
        return event;
    }

    public final int showDialog(@Nullable Component parent2, @Nls @NotNull String message2, @Nls @NotNull String title, @NotNull String[] options2, int defaultOptionIndex, @Nullable Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return parent2 != null ? Messages.showDialog((Component)parent2, (String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon2) : Messages.showDialog((String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon2);
    }

    private static final String markEventForK2$patchMessage(String message2) {
        return StringsKt.isBlank((CharSequence)message2) ? "This report is from the K2 Kotlin plugin." : message2 + "\nThis report is from the K2 Kotlin plugin.";
    }
}

