/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.MoveDestination;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper;", "", "()V", "getOrCreateDirectory", "Lcom/intellij/psi/PsiDirectory;", "source", "getPackageName", "", "ByMoveDestination", "ByPsiDirectory", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper$ByMoveDestination;", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper$ByPsiDirectory;", "kotlin.idea"})
public abstract class AutoCreatingPsiDirectoryWrapper {
    private AutoCreatingPsiDirectoryWrapper() {
    }

    @NotNull
    public abstract String getPackageName();

    @NotNull
    public abstract PsiDirectory getOrCreateDirectory(@NotNull PsiDirectory var1);

    public /* synthetic */ AutoCreatingPsiDirectoryWrapper(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper$ByMoveDestination;", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper;", "moveDestination", "Lcom/intellij/refactoring/MoveDestination;", "(Lcom/intellij/refactoring/MoveDestination;)V", "getOrCreateDirectory", "Lcom/intellij/psi/PsiDirectory;", "source", "getPackageName", "", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class ByMoveDestination
    extends AutoCreatingPsiDirectoryWrapper {
        @NotNull
        private final MoveDestination moveDestination;

        public ByMoveDestination(@NotNull MoveDestination moveDestination) {
            Intrinsics.checkNotNullParameter((Object)moveDestination, (String)"moveDestination");
            super(null);
            this.moveDestination = moveDestination;
        }

        @Override
        @NotNull
        public String getPackageName() {
            String string = this.moveDestination.getTargetPackage().getQualifiedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
            return string;
        }

        @Override
        @NotNull
        public PsiDirectory getOrCreateDirectory(@NotNull PsiDirectory source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            PsiDirectory psiDirectory = this.moveDestination.getTargetDirectory(source);
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getTargetDirectory(...)");
            return psiDirectory;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper$ByPsiDirectory;", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper;", "psiDirectory", "Lcom/intellij/psi/PsiDirectory;", "(Lcom/intellij/psi/PsiDirectory;)V", "getOrCreateDirectory", "source", "getPackageName", "", "kotlin.idea"})
    public static final class ByPsiDirectory
    extends AutoCreatingPsiDirectoryWrapper {
        @NotNull
        private final PsiDirectory psiDirectory;

        public ByPsiDirectory(@NotNull PsiDirectory psiDirectory) {
            Intrinsics.checkNotNullParameter((Object)psiDirectory, (String)"psiDirectory");
            super(null);
            this.psiDirectory = psiDirectory;
        }

        @Override
        @NotNull
        public String getPackageName() {
            JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
            Intrinsics.checkNotNull((Object)javaDirectoryService);
            PsiPackage psiPackage = javaDirectoryService.getPackage(this.psiDirectory);
            String string = psiPackage != null ? psiPackage.getQualifiedName() : null;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @Override
        @NotNull
        public PsiDirectory getOrCreateDirectory(@NotNull PsiDirectory source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return this.psiDirectory;
        }
    }
}

