/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "sourceRetention", "", "sourceRetentionAnnotation", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findExpressionTargetArgument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "targetAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotation", "Lorg/jetbrains/kotlin/psi/KtClass;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "AddSourceRetentionFix", "ChangeRetentionToSourceFix", "RemoveExpressionTargetFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRestrictedRetentionForExpressionAnnotationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestrictedRetentionForExpressionAnnotationFactory.kt\norg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n288#2,2:117\n*S KotlinDebug\n*F\n+ 1 RestrictedRetentionForExpressionAnnotationFactory.kt\norg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory\n*L\n40#1:117,2\n*E\n"})
public final class RestrictedRetentionForExpressionAnnotationFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final RestrictedRetentionForExpressionAnnotationFactory INSTANCE = new RestrictedRetentionForExpressionAnnotationFactory();
    @NotNull
    private static final String sourceRetention = StandardNames.FqNames.annotationRetention.asString() + ".SOURCE";
    @NotNull
    private static final String sourceRetentionAnnotation = "@" + StandardNames.FqNames.retention.asString() + "(" + sourceRetention + ")";

    private RestrictedRetentionForExpressionAnnotationFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KtAnnotationEntry targetAnnotation;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        KtAnnotationEntry ktAnnotationEntry = psiElement2 instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement2 : null;
        if (ktAnnotationEntry == null) {
            return CollectionsKt.emptyList();
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)annotationEntry2));
        if (ktClass2 == null) {
            return CollectionsKt.emptyList();
        }
        KtClass containingClass = ktClass2;
        KtAnnotationEntry retentionAnnotation = this.annotation(containingClass, StandardNames.FqNames.retention);
        KtAnnotationEntry ktAnnotationEntry2 = targetAnnotation = this.annotation(containingClass, StandardNames.FqNames.target);
        KtValueArgument expressionTargetArgument = ktAnnotationEntry2 != null ? this.findExpressionTargetArgument(ktAnnotationEntry2) : null;
        Object[] objectArray = new KotlinQuickFixAction[]{expressionTargetArgument != null ? new RemoveExpressionTargetFix(expressionTargetArgument) : null, retentionAnnotation == null ? (KotlinQuickFixAction)new AddSourceRetentionFix(containingClass) : (KotlinQuickFixAction)new ChangeRetentionToSourceFix(retentionAnnotation)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KtAnnotationEntry annotation(KtClass $this$annotation, FqName fqName2) {
        Object element$iv;
        Object v1;
        boolean bl;
        List list2 = $this$annotation.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        Iterable $this$firstOrNull$iv = list2;
        boolean $i$f$firstOrNull = false;
        Iterator iterator2 = $this$firstOrNull$iv.iterator();
        do {
            boolean bl2;
            String string;
            if (!iterator2.hasNext()) {
                v1 = null;
                return v1;
            }
            element$iv = iterator2.next();
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
            boolean bl3 = false;
            Object object = it.getTypeReference();
            if (object != null && (object = (string = object.getText())) != null) {
                Intrinsics.checkNotNull((Object)object);
                String string2 = fqName2.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                bl2 = StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
            } else {
                bl2 = false;
            }
            if (bl2) {
                FqName fqName3;
                ClassifierDescriptor classifierDescriptor;
                KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze$default((KtElement)$this$annotation, null, 1, null).get((ReadOnlySlice)BindingContext.TYPE, (Object)it.getTypeReference());
                if (kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = (classifierDescriptor = kotlinType.getDeclarationDescriptor())) != null) {
                    Intrinsics.checkNotNull((Object)kotlinType);
                    fqName3 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
                } else {
                    fqName3 = null;
                }
                if (Intrinsics.areEqual(fqName3, (Object)fqName2)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v1 = element$iv;
        return v1;
    }

    private final KtValueArgument findExpressionTargetArgument(KtAnnotationEntry targetAnnotation) {
        KtValueArgumentList ktValueArgumentList = targetAnnotation.getValueArgumentList();
        if (ktValueArgumentList == null) {
            return null;
        }
        KtValueArgumentList valueArgumentList2 = ktValueArgumentList;
        List list2 = targetAnnotation.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        if (!((Collection)list2).isEmpty()) {
            return null;
        }
        for (KtValueArgument valueArgument : valueArgumentList2.getArguments()) {
            KtExpression argumentExpression2;
            if (valueArgument.getArgumentExpression() == null) continue;
            String string = argumentExpression2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)KotlinTarget.EXPRESSION.toString(), (boolean)false, (int)2, null)) continue;
            return valueArgument;
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory$AddSourceRetentionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtClass;", "element", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    private static final class AddSourceRetentionFix
    extends KotlinQuickFixAction<KtClass> {
        public AddSourceRetentionFix(@NotNull KtClass element3) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            super((PsiElement)element3);
        }

        @NotNull
        public String getText() {
            return KotlinBundle.message((String)"add.source.retention", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtClass ktClass2 = (KtClass)this.getElement();
            if (ktClass2 == null) {
                return;
            }
            KtClass element3 = ktClass2;
            KtAnnotationEntry ktAnnotationEntry = element3.addAnnotationEntry(new KtPsiFactory(project2, false, 2, null).createAnnotationEntry(sourceRetentionAnnotation));
            Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"addAnnotationEntry(...)");
            KtAnnotationEntry added = ktAnnotationEntry;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)added, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory$ChangeRetentionToSourceFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "retentionAnnotation", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    private static final class ChangeRetentionToSourceFix
    extends KotlinQuickFixAction<KtAnnotationEntry> {
        public ChangeRetentionToSourceFix(@NotNull KtAnnotationEntry retentionAnnotation) {
            Intrinsics.checkNotNullParameter((Object)retentionAnnotation, (String)"retentionAnnotation");
            super((PsiElement)retentionAnnotation);
        }

        @NotNull
        public String getText() {
            return KotlinBundle.message((String)"change.existent.retention.to.source", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            KtElementImplStub added;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry retentionAnnotation = ktAnnotationEntry;
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            if (retentionAnnotation.getValueArgumentList() == null) {
                PsiElement psiElement2 = retentionAnnotation.add((PsiElement)psiFactory.createCallArguments("(" + sourceRetention + ")"));
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgumentList");
                v2 = (KtElementImplStub)((KtValueArgumentList)psiElement2);
            } else {
                List list2 = retentionAnnotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                if (!((Collection)list2).isEmpty()) {
                    KtValueArgumentList ktValueArgumentList = retentionAnnotation.getValueArgumentList();
                    if (ktValueArgumentList != null) {
                        ktValueArgumentList.removeArgument(0);
                    }
                }
                KtValueArgumentList ktValueArgumentList = retentionAnnotation.getValueArgumentList();
                v2 = added = (KtElementImplStub)(ktValueArgumentList != null ? ktValueArgumentList.addArgument(psiFactory.createArgument(sourceRetention)) : null);
            }
            if (added != null) {
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)added, null, 2, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory$RemoveExpressionTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "expressionTargetArgument", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    private static final class RemoveExpressionTargetFix
    extends KotlinQuickFixAction<KtValueArgument> {
        public RemoveExpressionTargetFix(@NotNull KtValueArgument expressionTargetArgument) {
            Intrinsics.checkNotNullParameter((Object)expressionTargetArgument, (String)"expressionTargetArgument");
            super((PsiElement)expressionTargetArgument);
        }

        @NotNull
        public String getText() {
            return KotlinBundle.message((String)"remove.expression.target", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtValueArgument ktValueArgument = (KtValueArgument)this.getElement();
            if (ktValueArgument == null) {
                return;
            }
            KtValueArgument expressionTargetArgument = ktValueArgument;
            PsiElement psiElement2 = expressionTargetArgument.getParent();
            KtValueArgumentList ktValueArgumentList = psiElement2 instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement2 : null;
            if (ktValueArgumentList == null) {
                return;
            }
            KtValueArgumentList argumentList2 = ktValueArgumentList;
            if (argumentList2.getArguments().size() == 1) {
                PsiElement psiElement3 = argumentList2.getParent();
                KtAnnotationEntry ktAnnotationEntry = psiElement3 instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement3 : null;
                if (ktAnnotationEntry == null) {
                    return;
                }
                KtAnnotationEntry annotation = ktAnnotationEntry;
                annotation.delete();
            } else {
                argumentList2.removeArgument(expressionTargetArgument);
            }
        }
    }
}

