/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hierarchy.types;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/types/KotlinTypeHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "parentDescriptor", "classOrFunctionalExpression", "Lcom/intellij/psi/PsiElement;", "isBase", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Lcom/intellij/psi/PsiElement;Z)V", "update", "Companion", "kotlin.code-insight.k2"})
public final class KotlinTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinTypeHierarchyNodeDescriptor(@NotNull Project project2, @Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement classOrFunctionalExpression, boolean isBase) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)classOrFunctionalExpression, (String)"classOrFunctionalExpression");
        super(project2, (NodeDescriptor)parentDescriptor, classOrFunctionalExpression, isBase);
    }

    public boolean update() {
        boolean changes = super.update();
        if (this.getPsiElement() == null) {
            return this.invalidElement();
        }
        if (changes && this.myIsBase) {
            this.setIcon(this.getBaseMarkerIcon(this.getIcon()));
        }
        PsiElement psiElement2 = this.getPsiElement();
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance oldText = compositeAppearance;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (psiElement2 instanceof KtClassOrObject) {
            TargetPresentation targetPresentation = GotoTargetHandler.computePresentation((PsiElement)psiElement2, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"computePresentation(...)");
            TargetPresentation targetPresentation2 = targetPresentation;
            this.myHighlightedText.getEnding().addText(targetPresentation2.getPresentableText(), classNameAttributes);
            CompositeAppearance.DequeEnd dequeEnd = this.myHighlightedText.getEnding();
            String string = targetPresentation2.getContainerText();
            if (string == null) {
                string = "";
            }
            dequeEnd.addText(" (" + string + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/types/KotlinTypeHierarchyNodeDescriptor$Companion;", "", "()V", "createTypeHierarchyDescriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "klass", "Lcom/intellij/psi/PsiElement;", "descriptor", "kotlin.code-insight.k2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HierarchyNodeDescriptor createTypeHierarchyDescriptor(@NotNull PsiElement klass2, @Nullable HierarchyNodeDescriptor descriptor2) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor;
            Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
            if (klass2 instanceof KtClassOrObject) {
                Project project2 = ((KtClassOrObject)klass2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                hierarchyNodeDescriptor = new KotlinTypeHierarchyNodeDescriptor(project2, descriptor2, klass2, false);
            } else {
                hierarchyNodeDescriptor = (HierarchyNodeDescriptor)new TypeHierarchyNodeDescriptor(klass2.getProject(), descriptor2, klass2, false);
            }
            return hierarchyNodeDescriptor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

