/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionToPropertyIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "startInWriteAction", "Converter", "kotlin.idea"})
public final class ConvertFunctionToPropertyIntention
extends SelfTargetingIntention<KtNamedFunction>
implements LowPriorityAction {
    public ConvertFunctionToPropertyIntention() {
        super(KtNamedFunction.class, KotlinBundle.lazyMessage((String)"convert.function.to.property", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtNamedFunction element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getFunKeyword();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement funKeyword = psiElement2;
        PsiElement psiElement3 = element3.getNameIdentifier();
        if (psiElement3 == null) {
            return false;
        }
        PsiElement identifier2 = psiElement3;
        if (!new TextRange(PsiUtilsKt.getStartOffset((PsiElement)funKeyword), PsiUtilsKt.getEndOffset((PsiElement)identifier2)).containsOffset(caretOffset)) {
            return false;
        }
        KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)element3));
        boolean bl = ktClass2 != null ? KotlinPsiUtilsKt.isFunInterface(ktClass2) : false;
        if (bl && !element3.hasBody()) {
            return false;
        }
        List list2 = element3.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        if (!((Collection)list2).isEmpty() || element3.isLocal()) {
            return false;
        }
        String string = element3.getName();
        Intrinsics.checkNotNull((Object)string);
        String name2 = string;
        if (Intrinsics.areEqual((Object)name2, (Object)"invoke") || Intrinsics.areEqual((Object)name2, (Object)"iterator") || ((ImmutableSet)OperatorConventions.UNARY_OPERATION_NAMES.inverse().keySet()).contains((Object)Name.identifier((String)name2))) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType2 = kotlinType;
        return !KotlinBuiltIns.isUnit((KotlinType)returnType2) && !KotlinBuiltIns.isNothing((KotlinType)returnType2);
    }

    @Override
    public void applyTo(@NotNull KtNamedFunction element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)element3, BodyResolveMode.PARTIAL);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtFile ktFile2 = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        new Converter(project2, ktFile2, editor2, descriptor2).run();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0016\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 H\u0014R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "descriptor", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "elementsToShorten", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lkotlin/collections/ArrayList;", "newName", "", "getNewName", "()Ljava/lang/String;", "newName$delegate", "Lkotlin/Lazy;", "convertFunction", "", "originalFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "moveCaret", "", "findMainElement", "Lcom/intellij/psi/PsiElement;", "callables", "", "performRefactoring", "descriptorsForChange", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nConvertFunctionToPropertyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionToPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,198:1\n1549#2:199\n1620#2,3:200\n1549#2:204\n1620#2,3:205\n1#3:203\n26#4,7:208\n193#5,2:215\n125#5:217\n142#5:218\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionToPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter\n*L\n62#1:199\n62#1:200,3\n66#1:204\n66#1:205,3\n80#1:208,7\n113#1:215,2\n113#1:217\n114#1:218\n*E\n"})
    private final class Converter
    extends CallableRefactoring<FunctionDescriptor> {
        @NotNull
        private final KtFile file;
        @NotNull
        private final ArrayList<KtElement> elementsToShorten;
        @NotNull
        private final Lazy newName$delegate;

        public Converter(@NotNull Project project2, @Nullable KtFile file2, @NotNull Editor editor2, FunctionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            super(project2, editor2, (CallableDescriptor)descriptor2, ConvertFunctionToPropertyIntention.this.getText());
            this.file = file2;
            this.elementsToShorten = new ArrayList();
            this.newName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Converter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    Name name2 = ((FunctionDescriptor)this.this$0.getCallableDescriptor()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    Name name3 = name2;
                    Name name4 = PropertiesConventionUtilKt.propertyNameByGetMethodName((Name)name3);
                    if (name4 == null) {
                        name4 = name3;
                    }
                    String string = name4.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    return string;
                }
            }));
        }

        private final String getNewName() {
            Lazy lazy = this.newName$delegate;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void convertFunction(KtNamedFunction originalFunction, KtPsiFactory psiFactory, boolean moveCaret) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            Object it;
            KtTypeConstraint it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            KtPsiFactory.CallableBuilder callableBuilder;
            KtPsiFactory.CallableBuilder $this$convertFunction_u24lambda_u245 = callableBuilder = new KtPsiFactory.CallableBuilder(KtPsiFactory.CallableBuilder.Target.READ_ONLY_PROPERTY);
            boolean bl = false;
            String string = originalFunction.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Object object = string;
            int n = 0;
            PsiElement psiElement3 = originalFunction.getFunKeyword();
            Intrinsics.checkNotNull((Object)psiElement3);
            int n2 = PsiUtilsKt.getStartOffsetIn((PsiElement)psiElement3, (PsiElement)((PsiElement)originalFunction));
            String string2 = ((String)object).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            $this$convertFunction_u24lambda_u245.modifier(string2);
            List list2 = originalFunction.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
            object = list2;
            KtPsiFactory.CallableBuilder callableBuilder2 = $this$convertFunction_u24lambda_u245;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KtTypeParameter ktTypeParameter = (KtTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getText());
            }
            callableBuilder2.typeParams((Collection)((List)destination$iv$iv));
            KtTypeReference ktTypeReference = originalFunction.getReceiverTypeReference();
            if (ktTypeReference != null) {
                it = ktTypeReference;
                boolean bl3 = false;
                String string3 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                $this$convertFunction_u24lambda_u245.receiver(string3);
            }
            $this$convertFunction_u24lambda_u245.name(this.getNewName());
            KtTypeReference ktTypeReference2 = KotlinPsiUtils.getReturnTypeReference((KtNamedDeclaration)originalFunction);
            if (ktTypeReference2 != null) {
                it = ktTypeReference2;
                boolean bl4 = false;
                String string4 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                $this$convertFunction_u24lambda_u245.returnType(string4);
            }
            List list3 = originalFunction.getTypeConstraints();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypeConstraints(...)");
            $this$map$iv = list3;
            callableBuilder2 = $this$convertFunction_u24lambda_u245;
            $i$f$map = false;
            it = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (KtTypeConstraint)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it2.getText());
            }
            callableBuilder2.typeConstraints((Collection)((List)destination$iv$iv));
            if (originalFunction.getEqualsToken() != null) {
                KtExpression ktExpression = originalFunction.getBodyExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                String string5 = ktExpression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                $this$convertFunction_u24lambda_u245.getterExpression(string5, originalFunction.getTypeReference() != null);
            } else {
                KtBlockExpression ktBlockExpression = originalFunction.getBodyBlockExpression();
                if (ktBlockExpression != null) {
                    KtBlockExpression body2 = ktBlockExpression;
                    boolean bl6 = false;
                    $this$convertFunction_u24lambda_u245.transform((Function1)new Function1<StringBuilder, Unit>(body2){
                        final /* synthetic */ KtBlockExpression $body;
                        {
                            this.$body = $body;
                            super(1);
                        }

                        public final void invoke(@NotNull StringBuilder $this$transform) {
                            Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$this$transform");
                            $this$transform.append("\nget() ");
                            $this$transform.append(this.$body.getText());
                        }
                    });
                }
            }
            String propertyString2 = callableBuilder.asString();
            $this$convertFunction_u24lambda_u245 = (PsiElement)originalFunction;
            PsiElement newElement$iv = (PsiElement)psiFactory.createDeclaration(propertyString2);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtProperty) {
                    psiElement2 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                    }
                    psiElement2 = (PsiElement)((KtProperty)ktExpression);
                }
            }
            KtProperty replaced2 = (KtProperty)psiElement2;
            if (this.getEditor() != null && moveCaret) {
                CaretModel caretModel = this.getEditor().getCaretModel();
                PsiElement psiElement4 = replaced2.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement4);
                caretModel.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)psiElement4));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkNotNullParameter(descriptorsForChange, (String)"descriptorsForChange");
            MultiMap conflicts2 = new MultiMap();
            String string = ((FunctionDescriptor)this.getCallableDescriptor()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String getterName = JvmAbi.getterName((String)string);
            Collection<PsiElement> callables2 = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            PsiElement mainElement = this.findMainElement(callables2);
            ArrayList<KtCallElement> kotlinCalls = new ArrayList<KtCallElement>();
            ArrayList<PsiReference> kotlinRefsToRename = new ArrayList<PsiReference>();
            ArrayList<PsiReference> foreignRefs = new ArrayList<PsiReference>();
            for (PsiElement callable2 : callables2) {
                Query usages2;
                LexicalScope lexicalScope;
                if (!(callable2 instanceof PsiNamedElement)) continue;
                if (!this.checkModifiable(callable2)) {
                    KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)conflicts2, callable2, (Function1<? super String, String>)((Function1)performRefactoring.1.INSTANCE));
                }
                if (callable2 instanceof KtNamedFunction && (lexicalScope = CallableRefactoringKt.getContainingScope((DeclarationDescriptor)this.getCallableDescriptor())) != null) {
                    HierarchicalScope hierarchicalScope = (HierarchicalScope)lexicalScope;
                    Name name2 = ((FunctionDescriptor)this.getCallableDescriptor()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    Iterator iterator2 = ScopeUtilsKt.findVariable$default((HierarchicalScope)hierarchicalScope, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), null, (int)4, null);
                    if (iterator2 != null) {
                        Iterator iterator3;
                        Iterator iterator4;
                        Iterator it = iterator4 = iterator2;
                        boolean bl = false;
                        Iterator iterator5 = iterator3 = Intrinsics.areEqual((Object)UtilsKt.receiverType((CallableDescriptor)it), (Object)UtilsKt.receiverType(this.getCallableDescriptor())) ? iterator4 : null;
                        if (iterator3 != null) {
                            Iterator it2 = iterator3;
                            boolean bl2 = false;
                            iterator4 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.getProject(), (DeclarationDescriptor)it2);
                            if (iterator4 != null) {
                                it2 = iterator4;
                                boolean bl3 = false;
                                KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)conflicts2, (PsiElement)it2, (Function1<? super String, String>)((Function1)performRefactoring.4.1.INSTANCE));
                            }
                        }
                    }
                }
                if (callable2 instanceof PsiMethod) {
                    KotlinRefactoringUtilKt.checkDeclarationConflict((PsiMethod)callable2, getterName, (MultiMap<PsiElement, String>)conflicts2, callables2);
                }
                Intrinsics.checkNotNullExpressionValue((Object)ReferencesSearch.search((PsiElement)callable2), (String)"search(...)");
                for (PsiReference usage : usages2) {
                    if (usage instanceof KtSimpleNameReference) {
                        void $this$getParentOfTypeAndBranch_u24default$iv;
                        KtSimpleNameExpression expression2 = (KtSimpleNameExpression)((KtSimpleNameReference)usage).getExpression();
                        PsiElement it = (PsiElement)expression2;
                        Function1 branch$iv = performRefactoring.callElement.1.INSTANCE;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfTypeAndBranch = false;
                        void $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch_u24default$iv;
                        boolean $i$f$getParentOfType = false;
                        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallElement.class, (boolean)strict$iv);
                        KtCallElement callElement2 = (KtCallElement)(psiElement2 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement2, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv) : null);
                        if (callElement2 != null) {
                            PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression2;
                            boolean $i$f$getStrictParentOfType = false;
                            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableReferenceExpression.class, (boolean)true) == null) {
                                Object[] objectArray;
                                List list2 = callElement2.getTypeArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArguments(...)");
                                if (!((Collection)list2).isEmpty()) {
                                    objectArray = new Object[1];
                                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.htmlEmphasize((String)callElement2.getText()), (String)"htmlEmphasize(...)");
                                    conflicts2.putValue((Object)callElement2, (Object)KotlinBundle.message((String)"type.arguments.will.be.lost.after.conversion.0", (Object[])objectArray));
                                }
                                List list3 = callElement2.getValueArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
                                if (!((Collection)list3).isEmpty()) {
                                    objectArray = new Object[1];
                                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.htmlEmphasize((String)callElement2.getText()), (String)"htmlEmphasize(...)");
                                    conflicts2.putValue((Object)callElement2, (Object)KotlinBundle.message((String)"call.with.arguments.will.be.skipped.0", (Object[])objectArray));
                                    continue;
                                }
                                kotlinCalls.add(callElement2);
                                continue;
                            }
                        }
                        kotlinRefsToRename.add(usage);
                        continue;
                    }
                    foreignRefs.add(usage);
                }
            }
            KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts2, null, (Function0)new Function0<Unit>(this, ConvertFunctionToPropertyIntention.this, kotlinCalls, kotlinRefsToRename, foreignRefs, callables2, mainElement){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ ConvertFunctionToPropertyIntention this$1;
                final /* synthetic */ ArrayList<KtCallElement> $kotlinCalls;
                final /* synthetic */ ArrayList<PsiReference> $kotlinRefsToRename;
                final /* synthetic */ ArrayList<PsiReference> $foreignRefs;
                final /* synthetic */ Collection<PsiElement> $callables;
                final /* synthetic */ PsiElement $mainElement;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$kotlinCalls = $kotlinCalls;
                    this.$kotlinRefsToRename = $kotlinRefsToRename;
                    this.$foreignRefs = $foreignRefs;
                    this.$callables = $callables;
                    this.$mainElement = $mainElement;
                    super(0);
                }

                public final void invoke() {
                    ApplicationUtilsKt.executeWriteCommand(this.this$0.getProject(), this.this$1.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$kotlinCalls, this.$kotlinRefsToRename, this.$foreignRefs, this.$callables, this.$mainElement){
                        final /* synthetic */ Converter this$0;
                        final /* synthetic */ ArrayList<KtCallElement> $kotlinCalls;
                        final /* synthetic */ ArrayList<PsiReference> $kotlinRefsToRename;
                        final /* synthetic */ ArrayList<PsiReference> $foreignRefs;
                        final /* synthetic */ Collection<PsiElement> $callables;
                        final /* synthetic */ PsiElement $mainElement;
                        {
                            this.this$0 = $receiver;
                            this.$kotlinCalls = $kotlinCalls;
                            this.$kotlinRefsToRename = $kotlinRefsToRename;
                            this.$foreignRefs = $foreignRefs;
                            this.$callables = $callables;
                            this.$mainElement = $mainElement;
                            super(0);
                        }

                        public final void invoke() {
                            KtCallElement it;
                            KtPsiFactory psiFactory = new KtPsiFactory(this.this$0.getProject(), false, 2, null);
                            String newGetterName = JvmAbi.getterName((String)Converter.access$getNewName(this.this$0));
                            KtExpression newRefExpr = psiFactory.createExpression(Converter.access$getNewName(this.this$0));
                            Iterable $this$forEach$iv = this.$kotlinCalls;
                            boolean $i$f$forEach22 = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (KtCallElement)element$iv;
                                boolean bl = false;
                                it.replace((PsiElement)newRefExpr);
                            }
                            $this$forEach$iv = this.$kotlinRefsToRename;
                            Converter $i$f$forEach22 = this.this$0;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                PsiReference it2 = (PsiReference)element$iv;
                                boolean bl = false;
                                it2.handleElementRename(Converter.access$getNewName($i$f$forEach22));
                            }
                            $this$forEach$iv = this.$foreignRefs;
                            boolean $i$f$forEach3 = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (PsiReference)element$iv;
                                boolean bl = false;
                                it.handleElementRename(newGetterName);
                            }
                            $this$forEach$iv = this.$callables;
                            Converter converter = this.this$0;
                            PsiElement psiElement2 = this.$mainElement;
                            boolean $i$f$forEach4 = false;
                            for (T element$iv : $this$forEach$iv) {
                                PsiElement it3 = (PsiElement)element$iv;
                                boolean bl = false;
                                PsiElement psiElement3 = it3;
                                if (psiElement3 instanceof KtNamedFunction) {
                                    Converter.access$convertFunction(converter, (KtNamedFunction)it3, psiFactory, Intrinsics.areEqual((Object)it3, (Object)psiElement2));
                                    continue;
                                }
                                if (!(psiElement3 instanceof PsiMethod)) continue;
                                ((PsiMethod)it3).setName(newGetterName);
                            }
                            ShortenReferences.process$default(ShortenReferences.DEFAULT, Converter.access$getElementsToShorten$p(this.this$0), null, false, 6, null);
                        }
                    }));
                }
            }, 2, null);
        }

        private final PsiElement findMainElement(Collection<? extends PsiElement> callables2) {
            Object v0;
            block2: {
                if (this.getEditor() == null) {
                    return null;
                }
                int offset2 = this.getEditor().getCaretModel().getOffset();
                Iterable iterable = callables2;
                for (Object t : iterable) {
                    PsiElement it = (PsiElement)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)this.file, (Object)it.getContainingFile()) && it.getTextRange().contains(offset2))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            return v0;
        }

        public static final /* synthetic */ String access$getNewName(Converter $this) {
            return $this.getNewName();
        }

        public static final /* synthetic */ ArrayList access$getElementsToShorten$p(Converter $this) {
            return $this.elementsToShorten;
        }

        public static final /* synthetic */ void access$convertFunction(Converter $this, KtNamedFunction originalFunction, KtPsiFactory psiFactory, boolean moveCaret) {
            $this.convertFunction(originalFunction, psiFactory, moveCaret);
        }
    }
}

