/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantSpreadOperatorInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantSpreadOperatorQuickfix;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantSpreadOperatorInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class RemoveRedundantSpreadOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.valueArgumentVisitor((Function1)((Function1)new Function1<KtValueArgument, Unit>(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
                super(1);
            }

            public final void invoke(@NotNull KtValueArgument argument2) {
                int n;
                Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                LeafPsiElement leafPsiElement = argument2.getSpreadElement();
                if (leafPsiElement == null) {
                    return;
                }
                LeafPsiElement spreadElement = leafPsiElement;
                if (argument2.isNamed()) {
                    return;
                }
                KtExpression ktExpression = argument2.getArgumentExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression argumentExpression2 = ktExpression;
                int argumentOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)argument2));
                int startOffset = spreadElement.getStartOffset() - argumentOffset;
                KtExpression ktExpression2 = argumentExpression2;
                if (ktExpression2 instanceof KtCallExpression) {
                    int argumentIndex;
                    BindingContext bindingContext2;
                    KtCallExpression call2;
                    block12: {
                        int n2;
                        if (!UtilsKt.isArrayOfFunction((KtCallExpression)argumentExpression2)) {
                            return;
                        }
                        PsiElement $this$getStrictParentOfType$iv = (PsiElement)argument2;
                        boolean $i$f$getStrictParentOfType = false;
                        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                        if (ktCallExpression == null) {
                            return;
                        }
                        call2 = ktCallExpression;
                        bindingContext2 = ResolutionUtils.analyze((KtElement)call2, BodyResolveMode.PARTIAL);
                        List list2 = call2.getValueArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                        List $this$indexOfFirst$iv = list2;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (E item$iv : $this$indexOfFirst$iv) {
                            KtValueArgument it = (KtValueArgument)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it, (Object)argument2)) {
                                n2 = index$iv;
                                break block12;
                            }
                            ++index$iv;
                        }
                        n2 = argumentIndex = -1;
                    }
                    if (KotlinRefactoringUtilKt.replaceWithCopyWithResolveCheck$default((KtExpression)call2, buildVisitor.endOffset.1.INSTANCE, bindingContext2, (Function1)new Function1<KtCallExpression, Unit>(argumentIndex, argumentExpression2){
                        final /* synthetic */ int $argumentIndex;
                        final /* synthetic */ KtExpression $argumentExpression;
                        {
                            this.$argumentIndex = $argumentIndex;
                            this.$argumentExpression = $argumentExpression;
                            super(1);
                        }

                        public final void invoke(@NotNull KtCallExpression $this$replaceWithCopyWithResolveCheck) {
                            block1: {
                                Intrinsics.checkNotNullParameter((Object)$this$replaceWithCopyWithResolveCheck, (String)"$this$replaceWithCopyWithResolveCheck");
                                Object object = $this$replaceWithCopyWithResolveCheck.getValueArgumentList();
                                KtValueArgument anchor = object != null && (object = object.getArguments()) != null ? (KtValueArgument)CollectionsKt.getOrNull((List)object, (int)this.$argumentIndex) : null;
                                List list2 = ((KtCallExpression)this.$argumentExpression).getValueArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                                Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)list2);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    KtValueArgument it = (KtValueArgument)element$iv;
                                    boolean bl = false;
                                    KtValueArgumentList ktValueArgumentList = $this$replaceWithCopyWithResolveCheck.getValueArgumentList();
                                    if (ktValueArgumentList == null) continue;
                                    ktValueArgumentList.addArgumentAfter(it, anchor);
                                }
                                KtValueArgumentList ktValueArgumentList = $this$replaceWithCopyWithResolveCheck.getValueArgumentList();
                                if (ktValueArgumentList == null) break block1;
                                ktValueArgumentList.removeArgument(this.$argumentIndex);
                            }
                        }
                    }, null, 8, null) == null) {
                        return;
                    }
                    KtExpression ktExpression3 = ((KtCallExpression)argumentExpression2).getCalleeExpression();
                    Intrinsics.checkNotNull((Object)ktExpression3);
                    n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression3)) - argumentOffset;
                } else if (ktExpression2 instanceof KtCollectionLiteralExpression) {
                    n = startOffset + 1;
                } else {
                    return;
                }
                int endOffset2 = n;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveRedundantSpreadOperatorQuickfix()};
                ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor((PsiElement)argument2, new TextRange(startOffset, endOffset2), KotlinBundle.message((String)"remove.redundant.spread.operator.quickfix.text", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$isOnTheFly, localQuickFixArray);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problemDescriptor2 = problemDescriptor;
                this.$holder.registerProblem(problemDescriptor2);
            }
        }));
    }
}

