/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfFix;
import org.jetbrains.kotlin.idea.inspections.RemoveFix;
import org.jetbrains.kotlin.idea.inspections.SimplifyFix;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0002\u001a\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\f\u001a$\u0010\r\u001a\u00020\u000e*\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"collectFixes", "", "Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfFix;", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "constantValue", "", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Ljava/lang/Boolean;)Ljava/util/List;", "branch", "Lorg/jetbrains/kotlin/psi/KtExpression;", "thenBranch", "getConditionConstantValueIfAny", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/lang/Boolean;", "replaceWithBranch", "", "isUsedAsExpression", "keepBraces", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConstantConditionIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantConditionIfInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,196:1\n1#2:197\n26#3,7:198\n26#3,7:205\n26#3,7:212\n*S KotlinDebug\n*F\n+ 1 ConstantConditionIfInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspectionKt\n*L\n159#1:198,7\n161#1:205,7\n168#1:212,7\n*E\n"})
public final class ConstantConditionIfInspectionKt {
    private static final Boolean getConditionConstantValueIfAny(KtIfExpression $this$getConditionConstantValueIfAny) {
        KtExpression expr = $this$getConditionConstantValueIfAny.getCondition();
        while (expr instanceof KtParenthesizedExpression) {
            expr = ((KtParenthesizedExpression)expr).getExpression();
        }
        if (!(expr instanceof KtConstantExpression)) {
            return null;
        }
        KtExpression ktExpression = $this$getConditionConstantValueIfAny.getCondition();
        if (ktExpression == null || (ktExpression = ResolutionUtils.analyze((KtElement)ktExpression, BodyResolveMode.PARTIAL_WITH_CFA)) == null) {
            return null;
        }
        KtExpression context2 = ktExpression;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)expr, (BindingContext)context2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expr, (BindingContext)context2);
        if (compileTimeConstant == null || (compileTimeConstant = compileTimeConstant.toConstantValue(type2)) == null) {
            return null;
        }
        CompileTimeConstant constant = compileTimeConstant;
        Object object = constant.getValue();
        return object instanceof Boolean ? (Boolean)object : null;
    }

    private static final List<ConstantConditionIfFix> collectFixes(KtIfExpression expression2, Boolean constantValue) {
        if (constantValue == null) {
            return CollectionsKt.emptyList();
        }
        List fixes2 = new ArrayList();
        if (ConstantConditionIfInspectionKt.branch(expression2, constantValue) != null) {
            boolean keepBraces = IfThenUtilsKt.isElseIf((KtExpression)expression2) && ConstantConditionIfInspectionKt.branch(expression2, constantValue) instanceof KtBlockExpression;
            ((Collection)fixes2).add(new SimplifyFix(constantValue, BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)expression2), (BindingContext)ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA)), keepBraces));
        }
        if (!constantValue.booleanValue() && expression2.getElse() == null) {
            ((Collection)fixes2).add(new RemoveFix());
        }
        return fixes2;
    }

    static /* synthetic */ List collectFixes$default(KtIfExpression ktIfExpression, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = ConstantConditionIfInspectionKt.getConditionConstantValueIfAny(ktIfExpression);
        }
        return ConstantConditionIfInspectionKt.collectFixes(ktIfExpression, bl);
    }

    private static final KtExpression branch(KtIfExpression $this$branch, boolean thenBranch) {
        return thenBranch ? $this$branch.getThen() : $this$branch.getElse();
    }

    public static final void replaceWithBranch(@NotNull KtExpression $this$replaceWithBranch, @NotNull KtExpression branch2, boolean isUsedAsExpression2, boolean keepBraces) {
        block41: {
            PsiElement replaced2;
            KtWhenExpression ktWhenExpression;
            KtWhenExpression property2;
            Intrinsics.checkNotNullParameter((Object)$this$replaceWithBranch, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)branch2, (String)"branch");
            Editor editor2 = EditorUtilsKt.findExistingEditor((PsiElement)$this$replaceWithBranch);
            CaretModel caretModel = editor2 != null ? editor2.getCaretModel() : null;
            KtWhenExpression ktWhenExpression2 = $this$replaceWithBranch instanceof KtWhenExpression ? (KtWhenExpression)$this$replaceWithBranch : null;
            if (ktWhenExpression2 != null && (ktWhenExpression2 = ktWhenExpression2.getSubjectVariable()) != null) {
                property2 = ktWhenExpression2;
                boolean bl = false;
                List list2 = property2.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
                if (!((Collection)list2).isEmpty()) {
                    ktWhenExpression = property2;
                } else {
                    KtExpression ktExpression = property2.getInitializer();
                    if (ktExpression == null) {
                        ktWhenExpression = property2;
                    } else {
                        KtExpression ktExpression2 = ktExpression;
                        Intrinsics.checkNotNull((Object)ktExpression2);
                        KtExpression initializer2 = ktExpression2;
                        Query query = ReferencesSearch.search((PsiElement)((PsiElement)property2), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)$this$replaceWithBranch)));
                        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                        List references2 = CollectionsKt.toList((Iterable)((Iterable)query));
                        switch (references2.size()) {
                            case 0: {
                                KtWhenExpression ktWhenExpression3;
                                KtWhenExpression it = ktWhenExpression3 = property2;
                                boolean bl2 = false;
                                if (!ExpressionExtKt.hasNoSideEffects(initializer2)) {
                                    ktWhenExpression = ktWhenExpression3;
                                    break;
                                }
                                ktWhenExpression = null;
                                break;
                            }
                            case 1: {
                                if (ExpressionExtKt.hasNoSideEffects(initializer2)) {
                                    ((PsiReference)CollectionsKt.first((List)references2)).getElement().replace((PsiElement)initializer2);
                                    ktWhenExpression = null;
                                    break;
                                }
                                ktWhenExpression = property2;
                                break;
                            }
                            default: {
                                ktWhenExpression = property2;
                            }
                        }
                    }
                }
            } else {
                ktWhenExpression = null;
            }
            KtWhenExpression subjectVariable = ktWhenExpression;
            Project project2 = $this$replaceWithBranch.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            PsiElement parent2 = $this$replaceWithBranch.getParent();
            if (!(branch2 instanceof KtBlockExpression)) {
                KtExpression ktExpression;
                if (subjectVariable != null) {
                    PsiElement psiElement2;
                    property2 = (PsiElement)$this$replaceWithBranch;
                    Object[] bl = new Object[]{subjectVariable, branch2};
                    PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"run { $0\n$1 }", (Object[])bl, (boolean)false, (int)4, null);
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement2 = newElement$iv;
                    } else {
                        result$iv = $this$replaced$iv.replace(newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement2 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement2 = (PsiElement)ktExpression3;
                        }
                    }
                    ktExpression = (KtExpression)psiElement2;
                } else {
                    PsiElement psiElement3;
                    $this$replaced$iv = (PsiElement)$this$replaceWithBranch;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)branch2))) {
                        psiElement3 = (PsiElement)branch2;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)branch2);
                        if (result$iv instanceof KtExpression) {
                            psiElement3 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression4 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement3 = (PsiElement)ktExpression4;
                        }
                    }
                    ktExpression = (KtExpression)psiElement3;
                }
                v12 = (PsiElement)ktExpression;
            } else if (isUsedAsExpression2) {
                if (subjectVariable != null) {
                    PsiElement psiElement4 = psiFactory.createNewLine();
                    PsiElement psiElement5 = (PsiElement)subjectVariable;
                    List list3 = ((KtBlockExpression)branch2).getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStatements(...)");
                    branch2.addAfter(psiElement4, branch2.addBefore(psiElement5, (PsiElement)CollectionsKt.firstOrNull((List)list3)));
                }
                $this$replaced$iv = (PsiElement)$this$replaceWithBranch;
                Object[] $i$f$replaced = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)((KtBlockExpression)branch2).getText(), (String)"getText(...)");
                PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"run $0", (Object[])$i$f$replaced, (boolean)false, (int)4, null);
                boolean $i$f$replaced2 = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                    v12 = newElement$iv;
                } else {
                    result$iv = $this$replaced$iv.replace(newElement$iv);
                    if (result$iv instanceof KtExpression) {
                        v12 = result$iv;
                    } else {
                        Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                        if (ktExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        v12 = (PsiElement)ktExpression;
                    }
                }
            } else {
                PsiElement psiElement6;
                PsiElement lastChild;
                PsiElement firstChildSibling = ((KtBlockExpression)branch2).getFirstChild().getNextSibling();
                if (!Intrinsics.areEqual((Object)firstChildSibling, (Object)(lastChild = ((KtBlockExpression)branch2).getLastChild()))) {
                    if (keepBraces) {
                        psiElement6 = parent2.addAfter((PsiElement)branch2, (PsiElement)$this$replaceWithBranch);
                    } else if (subjectVariable != null) {
                        branch2.addAfter((PsiElement)subjectVariable, ((KtBlockExpression)branch2).getLBrace());
                        psiElement6 = parent2.addAfter((PsiElement)psiFactory.createExpression("run " + ((KtBlockExpression)branch2).getText()), (PsiElement)$this$replaceWithBranch);
                    } else {
                        psiElement6 = parent2.addRangeAfter(firstChildSibling, lastChild.getPrevSibling(), (PsiElement)$this$replaceWithBranch);
                    }
                } else {
                    psiElement6 = null;
                }
                PsiElement replaced3 = psiElement6;
                $this$replaceWithBranch.delete();
                v12 = replaced2 = replaced3;
            }
            if (replaced2 == null) break block41;
            CaretModel caretModel2 = caretModel;
            if (caretModel2 != null) {
                caretModel2.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)replaced2));
            }
        }
    }

    public static /* synthetic */ void replaceWithBranch$default(KtExpression ktExpression, KtExpression ktExpression2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        ConstantConditionIfInspectionKt.replaceWithBranch(ktExpression, ktExpression2, bl, bl2);
    }

    public static final /* synthetic */ Boolean access$getConditionConstantValueIfAny(KtIfExpression $receiver) {
        return ConstantConditionIfInspectionKt.getConditionConstantValueIfAny($receiver);
    }

    public static final /* synthetic */ List access$collectFixes(KtIfExpression expression2, Boolean constantValue) {
        return ConstantConditionIfInspectionKt.collectFixes(expression2, constantValue);
    }

    public static final /* synthetic */ KtExpression access$branch(KtIfExpression $receiver, boolean thenBranch) {
        return ConstantConditionIfInspectionKt.branch($receiver, thenBranch);
    }
}

