/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.TrailingCommaUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.visitor.TrailingCommaVisitor;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaPostFormatProcessorKt;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaPostFormatVisitor;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaState;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\n2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/visitor/TrailingCommaVisitor;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "myPostProcessor", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper;", "correctCommaPosition", "", "parent", "Lorg/jetbrains/kotlin/psi/KtElement;", "process", "Lcom/intellij/psi/PsiElement;", "formatted", "", "trailingCommaContext", "Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaContext;", "processCommaOwner", "processIfInRange", "element", "block", "Lkotlin/Function0;", "processText", "Lcom/intellij/openapi/util/TextRange;", "source", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "updatePsi", "updater", "Companion", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nTrailingCommaPostFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailingCommaPostFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1549#2:145\n1620#2,3:146\n*S KotlinDebug\n*F\n+ 1 TrailingCommaPostFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor\n*L\n98#1:145\n98#1:146,3\n*E\n"})
final class TrailingCommaPostFormatVisitor
extends TrailingCommaVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final PostFormatProcessorHelper myPostProcessor;
    @NotNull
    private static final Logger LOG;

    public TrailingCommaPostFormatVisitor(@NotNull CodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this.settings = settings2;
        this.myPostProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings));
    }

    @Override
    protected void process(@NotNull TrailingCommaContext trailingCommaContext) {
        Intrinsics.checkNotNullParameter((Object)trailingCommaContext, (String)"trailingCommaContext");
        this.processIfInRange(trailingCommaContext.getKtElement(), (Function0<Unit>)((Function0)new Function0<Unit>(this, trailingCommaContext){
            final /* synthetic */ TrailingCommaPostFormatVisitor this$0;
            final /* synthetic */ TrailingCommaContext $trailingCommaContext;
            {
                this.this$0 = $receiver;
                this.$trailingCommaContext = $trailingCommaContext;
                super(0);
            }

            public final void invoke() {
                TrailingCommaPostFormatVisitor.access$processCommaOwner(this.this$0, this.$trailingCommaContext);
            }
        }));
    }

    private final void processIfInRange(KtElement element3, Function0<Unit> block2) {
        if (this.myPostProcessor.isElementPartlyInRange((PsiElement)element3)) {
            block2.invoke();
        }
    }

    static /* synthetic */ void processIfInRange$default(TrailingCommaPostFormatVisitor trailingCommaPostFormatVisitor, KtElement ktElement, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = processIfInRange.1.INSTANCE;
        }
        trailingCommaPostFormatVisitor.processIfInRange(ktElement, (Function0<Unit>)function0);
    }

    private final void processCommaOwner(TrailingCommaContext trailingCommaContext) {
        KtElement ktElement = trailingCommaContext.getKtElement();
        PsiElement psiElement2 = TrailingCommaHelper.INSTANCE.trailingCommaOrLastElement(ktElement);
        if (psiElement2 == null) {
            return;
        }
        PsiElement lastElementOrComma = psiElement2;
        this.updatePsi(ktElement, (Function0<Boolean>)((Function0)new Function0<Boolean>(trailingCommaContext, this, ktElement, lastElementOrComma){
            final /* synthetic */ TrailingCommaContext $trailingCommaContext;
            final /* synthetic */ TrailingCommaPostFormatVisitor this$0;
            final /* synthetic */ KtElement $ktElement;
            final /* synthetic */ PsiElement $lastElementOrComma;
            {
                this.$trailingCommaContext = $trailingCommaContext;
                this.this$0 = $receiver;
                this.$ktElement = $ktElement;
                this.$lastElementOrComma = $lastElementOrComma;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                TrailingCommaState state = this.$trailingCommaContext.getState();
                if (state == TrailingCommaState.MISSING && UtilKt.addTrailingCommaIsAllowedFor((KotlinCodeStyleSettings)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)TrailingCommaPostFormatVisitor.access$getSettings$p(this.this$0)), (PsiElement)((PsiElement)this.$ktElement))) {
                    boolean hasChange;
                    if (TrailingCommaUtilsKt.trailingCommaAllowedInModule((PsiElement)this.$ktElement)) {
                        Project project2 = this.$ktElement.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        TrailingCommaPostFormatProcessorKt.access$addCommaAfter(this.$lastElementOrComma, new KtPsiFactory(project2, false, 2, null));
                        v1 = true;
                    } else {
                        v1 = hasChange = false;
                    }
                    bl = TrailingCommaPostFormatVisitor.access$correctCommaPosition(this.this$0, this.$ktElement) || hasChange;
                } else if (state == TrailingCommaState.EXISTS) {
                    bl = TrailingCommaPostFormatVisitor.access$correctCommaPosition(this.this$0, this.$ktElement);
                } else if (state == TrailingCommaState.REDUNDANT) {
                    this.$lastElementOrComma.delete();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }));
    }

    private final void updatePsi(KtElement element3, Function0<Boolean> updater2) {
        int oldLength = element3.getParent().getTextLength();
        if (!((Boolean)updater2.invoke()).booleanValue()) {
            return;
        }
        PsiElement resultElement = GenericPsiUtils.reformatted((PsiElement)element3, true);
        this.myPostProcessor.updateResultRange(oldLength, resultElement.getParent().getTextLength());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean correctCommaPosition(KtElement parent2) {
        void $this$mapTo$iv$iv;
        boolean hasChange = false;
        Iterable $this$map$iv = TrailingCommaHelper.INSTANCE.findInvalidCommas(parent2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement2 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SmartPointersKt.createSmartPointer((PsiElement)it));
        }
        for (SmartPsiElementPointer pointerToComma : (List)destination$iv$iv) {
            PsiElement it;
            if (pointerToComma.getElement() == null) continue;
            boolean bl = false;
            TrailingCommaPostFormatProcessorKt.access$correctComma(it);
            hasChange = true;
        }
        return hasChange || TrailingCommaHelper.INSTANCE.lineBreakIsMissing(parent2);
    }

    @NotNull
    public final PsiElement process(@NotNull PsiElement formatted) {
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        LOG.assertTrue(formatted.isValid());
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    @NotNull
    public final TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        TextRange textRange = this.myPostProcessor.getResultTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getResultTextRange(...)");
        return textRange;
    }

    public static final /* synthetic */ void access$processCommaOwner(TrailingCommaPostFormatVisitor $this, TrailingCommaContext trailingCommaContext) {
        $this.processCommaOwner(trailingCommaContext);
    }

    public static final /* synthetic */ CodeStyleSettings access$getSettings$p(TrailingCommaPostFormatVisitor $this) {
        return $this.settings;
    }

    public static final /* synthetic */ boolean access$correctCommaPosition(TrailingCommaPostFormatVisitor $this, KtElement parent2) {
        return $this.correctCommaPosition(parent2);
    }

    static {
        Logger logger = Logger.getInstance(TrailingCommaVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.code-insight.impl-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

