/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;

public final class MemberMatching {
    @Nullable
    private static KtTypeReference getReceiverType(@NotNull KtNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            MemberMatching.$$$reportNull$$$0(0);
        }
        if (propertyOrFunction instanceof KtCallableDeclaration) {
            return ((KtCallableDeclaration)propertyOrFunction).getReceiverTypeReference();
        }
        throw new IllegalArgumentException("Not a callable declaration: " + propertyOrFunction.getClass().getName());
    }

    @NotNull
    private static List<KtParameter> getValueParameters(@NotNull KtNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            MemberMatching.$$$reportNull$$$0(1);
        }
        if (propertyOrFunction instanceof KtCallableDeclaration) {
            List list2 = ((KtCallableDeclaration)propertyOrFunction).getValueParameters();
            if (list2 == null) {
                MemberMatching.$$$reportNull$$$0(2);
            }
            return list2;
        }
        throw new IllegalArgumentException("Not a callable declaration: " + propertyOrFunction.getClass().getName());
    }

    private static String getTypeShortName(@NotNull KtTypeReference typeReference2) {
        if (typeReference2 == null) {
            MemberMatching.$$$reportNull$$$0(3);
        }
        KtTypeElement typeElement2 = typeReference2.getTypeElement();
        assert (typeElement2 != null);
        return (String)typeElement2.accept((KtVisitor)new KtVisitor<String, Void>(){

            public String visitDeclaration(@NotNull KtDeclaration declaration2, Void data) {
                if (declaration2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new IllegalStateException("This visitor shouldn't be invoked for " + declaration2.getClass());
            }

            public String visitUserType(@NotNull KtUserType type2, Void data) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                KtSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                assert (referenceExpression != null);
                return referenceExpression.getReferencedName();
            }

            public String visitFunctionType(@NotNull KtFunctionType type2, Void data) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return StandardNames.getFunctionName((int)(type2.getParameters().size() + (type2.getReceiverTypeReference() != null ? 1 : 0)));
            }

            public String visitNullableType(@NotNull KtNullableType nullableType, Void data) {
                if (nullableType == null) {
                    1.$$$reportNull$$$0(3);
                }
                KtTypeElement innerType = nullableType.getInnerType();
                assert (innerType != null) : "No inner type: " + nullableType;
                return (String)innerType.accept((KtVisitor)this, null);
            }

            public String visitDynamicType(@NotNull KtDynamicType type2, Void data) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return "dynamic";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nullableType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitUserType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNullableType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDynamicType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static boolean typesHaveSameShortName(@NotNull KtTypeReference a, @NotNull KtTypeReference b2) {
        if (a == null) {
            MemberMatching.$$$reportNull$$$0(4);
        }
        if (b2 == null) {
            MemberMatching.$$$reportNull$$$0(5);
        }
        return MemberMatching.getTypeShortName(a).equals(MemberMatching.getTypeShortName(b2));
    }

    static boolean sameReceiverPresenceAndParametersCount(@NotNull KtNamedDeclaration a, @NotNull KtNamedDeclaration b2) {
        if (a == null) {
            MemberMatching.$$$reportNull$$$0(6);
        }
        if (b2 == null) {
            MemberMatching.$$$reportNull$$$0(7);
        }
        boolean sameReceiverPresence = MemberMatching.getReceiverType(a) == null == (MemberMatching.getReceiverType(b2) == null);
        boolean sameParametersCount = MemberMatching.getValueParameters(a).size() == MemberMatching.getValueParameters(b2).size();
        return sameReceiverPresence && sameParametersCount;
    }

    static boolean receiverAndParametersShortTypesMatch(@NotNull KtNamedDeclaration a, @NotNull KtNamedDeclaration b2) {
        KtTypeReference bReceiver;
        KtTypeReference aReceiver;
        if (a == null) {
            MemberMatching.$$$reportNull$$$0(8);
        }
        if (b2 == null) {
            MemberMatching.$$$reportNull$$$0(9);
        }
        if ((aReceiver = MemberMatching.getReceiverType(a)) == null != ((bReceiver = MemberMatching.getReceiverType(b2)) == null)) {
            return false;
        }
        if (aReceiver != null && !MemberMatching.typesHaveSameShortName(aReceiver, bReceiver)) {
            return false;
        }
        List<KtParameter> aParameters = MemberMatching.getValueParameters(a);
        List<KtParameter> bParameters = MemberMatching.getValueParameters(b2);
        if (aParameters.size() != bParameters.size()) {
            return false;
        }
        for (int i2 = 0; i2 < aParameters.size(); ++i2) {
            KtTypeReference aType = aParameters.get(i2).getTypeReference();
            KtTypeReference bType = bParameters.get(i2).getTypeReference();
            assert (aType != null);
            assert (bType != null);
            if (MemberMatching.typesHaveSameShortName(aType, bType)) continue;
            return false;
        }
        return true;
    }

    private MemberMatching() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyOrFunction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getValueParameters";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeShortName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "typesHaveSameShortName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sameReceiverPresenceAndParametersCount";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "receiverAndParametersShortTypesMatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

