/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.PsiUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\u0012\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "element", "Lcom/intellij/psi/PsiElement;", "lines", "Lcom/intellij/util/Range;", "", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "elementPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "declarationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "getCallingExpressionLines", "getMethodName", "", "getSkipCount", "locationMatches", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "nameMatches", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nKotlinMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,144:1\n28#2,2:145\n36#3,8:147\n526#4:155\n511#4,6:156\n187#5,3:162\n*S KotlinDebug\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter\n*L\n56#1:145,2\n56#1:147,8\n109#1:155\n109#1:156,6\n110#1:162,3\n*E\n"})
public class KotlinMethodFilter
implements NamedMethodFilter {
    @Nullable
    private final Range<Integer> lines;
    @NotNull
    private final CallableMemberInfo methodInfo;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> elementPtr;

    public KotlinMethodFilter(@Nullable PsiElement element3, @Nullable Range<Integer> lines, @NotNull CallableMemberInfo methodInfo) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        this.lines = lines;
        this.methodInfo = methodInfo;
        PsiElement psiElement2 = element3;
        this.elementPtr = psiElement2 != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement2) : null;
    }

    public int getSkipCount() {
        return this.methodInfo.getOrdinal();
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @Nullable Location location2, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        if (location2 == null || !this.nameMatches(location2, frameProxy)) {
            return false;
        }
        Object object = ReadAction.nonBlocking(() -> KotlinMethodFilter.locationMatches$lambda$0(this, process2, location2)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Boolean)object;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.locationMatches(process2, location2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean declarationMatches(DebugProcessImpl process2, Location location2) {
        void this_$iv$iv;
        CompoundPositionManager compoundPositionManager = process2.getPositionManager();
        Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"getPositionManager(...)");
        KtDeclaration ktDeclaration = KotlinMethodFilterKt.access$getCurrentDeclaration((PositionManager)compoundPositionManager, location2);
        if (ktDeclaration == null) {
            return false;
        }
        KtDeclaration currentDeclaration = ktDeclaration;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)currentDeclaration).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)currentDeclaration);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)currentDeclaration);
        try {
            KaSession $this$declarationMatches_u24lambda_u241 = analysisSession$iv$iv;
            boolean bl = false;
            boolean bl2 = this.declarationMatches($this$declarationMatches_u24lambda_u241, currentDeclaration);
            return bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)currentDeclaration);
        }
    }

    private final boolean declarationMatches(KaSession $context_receiver_0, KtDeclaration currentDeclaration) {
        KaDeclarationSymbol currentSymbol = $context_receiver_0.getSymbol(currentDeclaration);
        if (!(currentSymbol instanceof KaCallableSymbol) && !(currentSymbol instanceof KaClassSymbol)) {
            return false;
        }
        if (this.methodInfo.isInvoke()) {
            return true;
        }
        PsiElement psiElement2 = this.elementPtr;
        if (psiElement2 == null || (psiElement2 = psiElement2.getElement()) == null) {
            return true;
        }
        PsiElement element3 = psiElement2;
        if (!(element3 instanceof KtDeclaration)) {
            return false;
        }
        if (PsiUtilsKt.areElementsEquivalent((KtDeclaration)element3, currentDeclaration)) {
            return true;
        }
        if (!(currentSymbol instanceof KaCallableSymbol)) {
            return false;
        }
        for (KaCallableSymbol overriddenSymbol : $context_receiver_0.getAllOverriddenSymbols((KaCallableSymbol)currentSymbol)) {
            KtDeclaration overriddenDeclaration;
            PsiElement psiElement3 = overriddenSymbol.getPsi();
            KtDeclaration ktDeclaration = psiElement3 instanceof KtDeclaration ? (KtDeclaration)psiElement3 : null;
            if (ktDeclaration == null || !PsiUtilsKt.areElementsEquivalent((KtDeclaration)element3, overriddenDeclaration = ktDeclaration)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.lines;
    }

    @NotNull
    public String getMethodName() {
        return this.methodInfo.getName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean nameMatches(Location location2, StackFrameProxyImpl frameProxy) {
        boolean bl;
        void $this$any$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        String targetMethodName = this.getMethodName();
        boolean isNameMangledInBytecode = this.methodInfo.isNameMangledInBytecode();
        String string = method2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String actualMethodName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(string, isNameMangledInBytecode);
        boolean isGeneratedLambda = DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(actualMethodName);
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)targetMethodName)) return true;
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)(targetMethodName + "$default"))) return true;
        if (isGeneratedLambda) {
            if (Intrinsics.areEqual((Object)KotlinMethodFilterKt.access$getMethodNameInCallerFrame(frameProxy), (Object)targetMethodName)) return true;
        }
        Map<LocalVariable, ClosedRange<Location>> map2 = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method2);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl2 = false;
            if (!((ClosedRange)it.getValue()).contains((Comparable)location2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            bl = false;
        } else {
            iterator2 = $this$any$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl3 = false;
                if (!KotlinMethodFilterKt.access$isInlinedFromFunction((LocalVariable)it.getKey(), targetMethodName, isNameMangledInBytecode, this.methodInfo.isInternalMethod())) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (isGeneratedLambda) return false;
        if (!this.methodInfo.isInternalMethod()) return false;
        if (!KotlinMethodFilterKt.access$internalNameMatches(actualMethodName, targetMethodName)) return false;
        return true;
    }

    private static final Boolean locationMatches$lambda$0(KotlinMethodFilter this$0, DebugProcessImpl $process, Location $location) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
        return this$0.declarationMatches($process, $location);
    }
}

