/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/DebugContextProvider;", "", "()V", "DEBUG_CONTEXT_FOR_TEST", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getDebuggerContext", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiElement;", "supplyTestDebugContext", "", "contextElement", "kotlin.jvm-debugger.evaluation"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDebugContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugContextProvider.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/DebugContextProvider\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,29:1\n73#2:30\n*S KotlinDebug\n*F\n+ 1 DebugContextProvider.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/DebugContextProvider\n*L\n23#1:30\n*E\n"})
public final class DebugContextProvider {
    @NotNull
    public static final DebugContextProvider INSTANCE = new DebugContextProvider();
    @NotNull
    private static final Key<DebuggerContextImpl> DEBUG_CONTEXT_FOR_TEST;

    private DebugContextProvider() {
    }

    @TestOnly
    public final void supplyTestDebugContext(@NotNull PsiElement contextElement, @NotNull DebuggerContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        contextElement.putCopyableUserData(DEBUG_CONTEXT_FOR_TEST, (Object)context2);
    }

    @Nullable
    public final DebuggerContextImpl getDebuggerContext(@NotNull Project project2, @Nullable PsiElement context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement psiElement2 = context2;
            object = psiElement2 != null ? (DebuggerContextImpl)psiElement2.getCopyableUserData(DEBUG_CONTEXT_FOR_TEST) : null;
        } else {
            object = DebuggerManagerEx.getInstanceEx((Project)project2).getContext();
        }
        return object;
    }

    static {
        Key key = Key.create((String)"DEBUG_CONTEXT_FOR_TESTS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DEBUG_CONTEXT_FOR_TEST = key;
    }
}

