/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a+\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\b\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u001aJ\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u00172\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001a\u0012\u0004\u0012\u00020\u001b0\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017H\u0002\u001a2\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017\u001a8\u0010!\u001a\u00020\u0015*\u00020\"2\u0006\u0010\u0004\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u001a\n\u0010#\u001a\u00020\u0015*\u00020$\u001a\u0014\u0010%\u001a\u00020\u0015*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006&"}, d2={"getElementsAtLineIfAny", "", "T", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "getLambdasAtLine", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getLambdasAtLineIfAny", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getTopmostParentOnLineOrSelf", "element", "document", "Lcom/intellij/openapi/editor/Document;", "getTopmostParentWithinOffsetRangeOrSelf", "startOffset", "endOffset", "hasExecutableCodeImpl", "", "checker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitElements", "Lcom/intellij/util/Processor;", "", "getParentToAnalyze", "isBreakpointApplicable", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "hasExecutableCodeInsideOnLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInlineOnly", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "isStartingOrEndingOnLine", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nbreakpointTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,177:1\n800#2,11:178\n766#2:189\n857#2,2:190\n766#2:193\n857#2,2:194\n1747#2,3:196\n67#3:192\n125#4:199\n*S KotlinDebug\n*F\n+ 1 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n*L\n139#1:178,11\n143#1:189\n143#1:190,2\n164#1:193\n164#1:194,2\n175#1:196,3\n155#1:192\n74#1:199\n*E\n"})
public final class BreakpointTypeUtilsKt {
    public static final boolean isBreakpointApplicable(@NotNull VirtualFile file2, int line, @NotNull Project project2, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(checker, (String)"checker");
                PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
                if (psiFile2 == null) break block4;
                VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                if (Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getFileType() : null), (Object)KotlinFileType.INSTANCE)) break block5;
            }
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(checker, project2, document2, line){
            final /* synthetic */ Function1<PsiElement, ApplicabilityResult> $checker;
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $line;
            {
                this.$checker = $checker;
                this.$project = $project;
                this.$document = $document;
                this.$line = $line;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return BreakpointTypeUtilsKt.access$hasExecutableCodeImpl(this.$checker, (Function1)new Function1<Processor<PsiElement>, Unit>(this.$project, this.$document, this.$line){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ int $line;
                    {
                        this.$project = $project;
                        this.$document = $document;
                        this.$line = $line;
                        super(1);
                    }

                    public final void invoke(@NotNull Processor<PsiElement> processor2) {
                        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                        XDebuggerUtil.getInstance().iterateLine(this.$project, this.$document, this.$line, processor2);
                    }
                }, (Function1)new Function1<PsiElement, PsiElement>(this.$document, this.$line){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ int $line;
                    {
                        this.$document = $document;
                        this.$line = $line;
                        super(1);
                    }

                    @NotNull
                    public final PsiElement invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return BreakpointTypeUtilsKt.access$getTopmostParentOnLineOrSelf(it, this.$document, this.$line);
                    }
                });
            }
        }));
    }

    public static final boolean hasExecutableCodeInsideOnLine(@NotNull KtElement $this$hasExecutableCodeInsideOnLine, @NotNull VirtualFile file2, int line, @NotNull Project project2, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker) {
        Intrinsics.checkNotNullParameter((Object)$this$hasExecutableCodeInsideOnLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>($this$hasExecutableCodeInsideOnLine, document2, line, checker, project2){
            final /* synthetic */ KtElement $this_hasExecutableCodeInsideOnLine;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $line;
            final /* synthetic */ Function1<PsiElement, ApplicabilityResult> $checker;
            final /* synthetic */ Project $project;
            {
                this.$this_hasExecutableCodeInsideOnLine = $receiver;
                this.$document = $document;
                this.$line = $line;
                this.$checker = $checker;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                int minOffset = Math.max(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)this.$this_hasExecutableCodeInsideOnLine)), this.$document.getLineStartOffset(this.$line));
                int maxOffset = Math.min(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)this.$this_hasExecutableCodeInsideOnLine)), this.$document.getLineEndOffset(this.$line));
                return BreakpointTypeUtilsKt.access$hasExecutableCodeImpl(this.$checker, (Function1)new Function1<Processor<PsiElement>, Unit>(this.$project, this.$document, minOffset, maxOffset){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ int $minOffset;
                    final /* synthetic */ int $maxOffset;
                    {
                        this.$project = $project;
                        this.$document = $document;
                        this.$minOffset = $minOffset;
                        this.$maxOffset = $maxOffset;
                        super(1);
                    }

                    public final void invoke(@NotNull Processor<PsiElement> processor2) {
                        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                        XDebuggerUtil xDebuggerUtil = XDebuggerUtil.getInstance();
                        Intrinsics.checkNotNull((Object)xDebuggerUtil, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerUtilImpl");
                        ((XDebuggerUtilImpl)xDebuggerUtil).iterateOffsetRange(this.$project, this.$document, this.$minOffset, this.$maxOffset, processor2);
                    }
                }, (Function1)new Function1<PsiElement, PsiElement>(minOffset, maxOffset){
                    final /* synthetic */ int $minOffset;
                    final /* synthetic */ int $maxOffset;
                    {
                        this.$minOffset = $minOffset;
                        this.$maxOffset = $maxOffset;
                        super(1);
                    }

                    @NotNull
                    public final PsiElement invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return BreakpointTypeUtilsKt.access$getTopmostParentWithinOffsetRangeOrSelf(it, this.$minOffset, this.$maxOffset);
                    }
                });
            }
        }));
    }

    private static final boolean hasExecutableCodeImpl(Function1<? super PsiElement, ApplicabilityResult> checker, Function1<? super Processor<PsiElement>, Unit> visitElements, Function1<? super PsiElement, ? extends PsiElement> getParentToAnalyze) {
        Ref.BooleanRef isApplicable2 = new Ref.BooleanRef();
        HashSet checked = new HashSet();
        visitElements.invoke(arg_0 -> BreakpointTypeUtilsKt.hasExecutableCodeImpl$lambda$0(getParentToAnalyze, checked, checker, isApplicable2, arg_0));
        return isApplicable2.element;
    }

    private static final PsiElement getTopmostParentOnLineOrSelf(PsiElement element3, Document document, int line) {
        int offset2;
        PsiElement current = element3;
        PsiElement parent2 = current.getParent();
        while (!(parent2 == null || parent2 instanceof PsiFile || (offset2 = parent2.getTextOffset()) > document.getTextLength() || offset2 >= 0 && document.getLineNumber(offset2) != line)) {
            current = parent2;
            parent2 = current.getParent();
        }
        return current;
    }

    private static final PsiElement getTopmostParentWithinOffsetRangeOrSelf(PsiElement element3, int startOffset, int endOffset2) {
        PsiElement parent2;
        PsiElement node2 = element3;
        while ((parent2 = node2.getParent()) != null && PsiUtilsKt.getStartOffset((PsiElement)parent2) >= startOffset && PsiUtilsKt.getEndOffset((PsiElement)parent2) <= endOffset2) {
            node2 = parent2;
        }
        return node2;
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile2 = sourcePosition2.getFile();
        KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile2;
        return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, sourcePosition2.getLine());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends PsiElement> List<T> getElementsAtLineIfAny(KtFile file2, int line) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$getElementsAtLineIfAny = false;
        PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, line);
        KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement lineElement = ktElement;
        int start2 = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement));
        int end = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement));
        for (PsiElement nextSibling = lineElement.getNextSibling(); nextSibling != null && line == PsiLinesUtilsKt.getLineNumber$default(nextSibling, false, 1, null); nextSibling = nextSibling.getNextSibling()) {
            end = PsiUtilsKt.getEndOffset((PsiElement)nextSibling);
        }
        PsiFile psiFile2 = (PsiFile)file2;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        Iterable $this$filterIsInstance$iv = FindElementUtils.findElementsOfClassInRange(psiFile2, start2, end, classArray);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element$iv$iv instanceof Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull KtFile file2, int line) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Iterable $this$filter$iv = BreakpointTypeUtilsKt.getLambdasAtLine(file2, line);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(PsiLinesUtilsKt.getLineNumber$default((PsiElement)it, false, 1, null) == line)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFunction> getLambdasAtLine(@NotNull KtFile file2, int line) {
        void $this$filterTo$iv$iv;
        Iterable $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file2, line);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int start2 = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file2, line);
        if (n2 == null) {
            return CollectionsKt.emptyList();
        }
        int end = n2;
        Set result2 = new LinkedHashSet();
        int offset2 = start2;
        while (offset2 <= end) {
            PsiElement element3 = file2.findElementAt(offset2);
            if (element3 != null) {
                PsiElement psiElement2 = element3;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                KtFunction function2 = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
                if (function2 != null) {
                    result2.add(function2);
                }
                offset2 = PsiUtilsKt.getEndOffset((PsiElement)element3);
                continue;
            }
            ++offset2;
        }
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        $this$parentOfType$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtFunctionLiteral || it.getName() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isStartingOrEndingOnLine(@NotNull KtFunction $this$isStartingOrEndingOnLine, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$isStartingOrEndingOnLine, (String)"<this>");
        return line == PsiLinesUtilsKt.getLineNumber((PsiElement)$this$isStartingOrEndingOnLine, true) || line == PsiLinesUtilsKt.getLineNumber((PsiElement)$this$isStartingOrEndingOnLine, false);
    }

    public static final boolean isInlineOnly(@NotNull KtCallableDeclaration $this$isInlineOnly) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"<this>");
            if (!$this$isInlineOnly.hasModifier(KtTokens.INLINE_KEYWORD)) {
                return false;
            }
            List list2 = $this$isInlineOnly.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME().shortName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasExecutableCodeImpl$lambda$0(Function1<? super PsiElement, ? extends PsiElement> $getParentToAnalyze, HashSet<PsiElement> checked, Function1<? super PsiElement, ApplicabilityResult> $checker, Ref.BooleanRef isApplicable2, PsiElement element3) {
        block6: {
            block5: {
                void $this$getParentOfType$iv;
                if (element3 instanceof PsiWhiteSpace) break block5;
                PsiElement psiElement2 = element3;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiComment.class, (boolean)strict$iv) == null && element3.isValid()) break block6;
            }
            return true;
        }
        PsiElement parent2 = (PsiElement)$getParentToAnalyze.invoke((Object)element3);
        if (!checked.add(parent2)) {
            return true;
        }
        ApplicabilityResult result2 = (ApplicabilityResult)$checker.invoke((Object)parent2);
        if (result2.getShouldStop() && !result2.isApplicable()) {
            isApplicable2.element = false;
            return false;
        }
        isApplicable2.element |= result2.isApplicable();
        return !result2.getShouldStop();
    }

    public static final /* synthetic */ boolean access$hasExecutableCodeImpl(Function1 checker, Function1 visitElements, Function1 getParentToAnalyze) {
        return BreakpointTypeUtilsKt.hasExecutableCodeImpl((Function1<? super PsiElement, ApplicabilityResult>)checker, (Function1<? super Processor<PsiElement>, Unit>)visitElements, (Function1<? super PsiElement, ? extends PsiElement>)getParentToAnalyze);
    }

    public static final /* synthetic */ PsiElement access$getTopmostParentOnLineOrSelf(PsiElement element3, Document document, int line) {
        return BreakpointTypeUtilsKt.getTopmostParentOnLineOrSelf(element3, document, line);
    }

    public static final /* synthetic */ PsiElement access$getTopmostParentWithinOffsetRangeOrSelf(PsiElement element3, int startOffset, int endOffset2) {
        return BreakpointTypeUtilsKt.getTopmostParentWithinOffsetRangeOrSelf(element3, startOffset, endOffset2);
    }
}

