/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.idea.codeinsight.utils.ImplicitLambdaParameterUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextTuner;
import org.jetbrains.kotlin.idea.debugger.core.GetterDescriptor;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0014H\u0002J*\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e*\u00020\u0018H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionProvider;", "Lcom/intellij/debugger/engine/SourcePositionProvider;", "()V", "computeSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "descriptor", "Lcom/intellij/debugger/ui/tree/FieldDescriptor;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "nearest", "", "Lcom/intellij/debugger/ui/tree/LocalVariableDescriptor;", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/idea/debugger/core/GetterDescriptor;", "computeSourcePositionForDeclaration", "declaringType", "Lcom/sun/jdi/ReferenceType;", "declarationSelector", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "computeSourcePositionForPropertyDeclaration", "name", "", "findClassByType", "Lcom/intellij/psi/PsiElement;", "type", "getLastSourcePosition", "implicitLambdaParameterUsages", "", "Lcom/intellij/openapi/util/TextRange;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "getPropertyDeclarationNameVariations", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSourcePositionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourcePositionProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionProvider\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,207:1\n28#2,2:208\n36#3,8:210\n1549#4:218\n1620#4,3:219\n288#4,2:222\n1#5:224\n142#6:225\n*S KotlinDebug\n*F\n+ 1 KotlinSourcePositionProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionProvider\n*L\n68#1:208,2\n68#1:210,8\n118#1:218\n118#1:219,3\n128#1:222,2\n185#1:225\n*E\n"})
public final class KotlinSourcePositionProvider
extends SourcePositionProvider {
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor2, @NotNull Project project2, @NotNull DebuggerContextImpl context2, boolean nearest) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getFrameProxy() == null || DumbService.Companion.isDumb(project2)) {
            return null;
        }
        NodeDescriptor nodeDescriptor = descriptor2;
        return nodeDescriptor instanceof FieldDescriptor ? this.computeSourcePosition((FieldDescriptor)descriptor2, context2, nearest) : (nodeDescriptor instanceof GetterDescriptor ? this.computeSourcePosition((GetterDescriptor)descriptor2, context2, nearest) : (nodeDescriptor instanceof LocalVariableDescriptor ? this.computeSourcePosition((LocalVariableDescriptor)descriptor2, context2, nearest) : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final SourcePosition computeSourcePosition(LocalVariableDescriptor descriptor2, DebuggerContextImpl context2, boolean nearest) {
        void this_$iv$iv;
        PsiElement psiElement2 = PositionUtil.getContextElement((StackFrameContext)((StackFrameContext)context2));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement place = psiElement2;
        if (!(place.getContainingFile() instanceof KtFile)) {
            return null;
        }
        PsiElement psiElement3 = CodeFragmentContextTuner.Companion.getInstance().tuneContextElement(place);
        if (psiElement3 == null) {
            return null;
        }
        PsiElement contextElement = psiElement3;
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
        String string = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        KtExpressionCodeFragment codeFragment = ktPsiFactory.createExpressionCodeFragment(string, contextElement);
        KtExpression localReferenceExpression = codeFragment.getContentElement();
        if (!(localReferenceExpression instanceof KtSimpleNameExpression)) {
            return null;
        }
        boolean $i$f$analyze = false;
        Project project3 = ((KtElement)localReferenceExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project3);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)localReferenceExpression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)localReferenceExpression);
        try {
            KaSession $this$computeSourcePosition_u24lambda_u242 = analysisSession$iv$iv;
            boolean bl = false;
            for (KaSymbol symbol2 : $this$computeSourcePosition_u24lambda_u242.resolveToSymbols((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)localReferenceExpression)))) {
                if (!(symbol2 instanceof KaVariableSymbol)) continue;
                if (symbol2 instanceof KaValueParameterSymbol && ((KaValueParameterSymbol)symbol2).isImplicitLambdaParameter()) {
                    KtFunctionLiteral ktFunctionLiteral = ImplicitLambdaParameterUtilsKt.getFunctionLiteralByImplicitLambdaParameterSymbol($this$computeSourcePosition_u24lambda_u242, (KaValueParameterSymbol)symbol2);
                    if (ktFunctionLiteral == null) continue;
                    KtFunctionLiteral lambda2 = ktFunctionLiteral;
                    SourcePosition sourcePosition2 = nearest ? DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiFile)lambda2.getContainingFile(), arg_0 -> KotlinSourcePositionProvider.computeSourcePosition$lambda$2$lambda$0(this, lambda2, arg_0)) : SourcePosition.createFromOffset((PsiFile)lambda2.getContainingFile(), (int)lambda2.getLBrace().getTextOffset());
                    return sourcePosition2;
                }
                PsiElement psiElement4 = symbol2.getPsi();
                if (psiElement4 == null) continue;
                PsiElement element3 = psiElement4;
                boolean bl2 = false;
                SourcePosition sourcePosition3 = nearest ? DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiElement)element3, (PsiFile)element3.getContainingFile()) : SourcePosition.createFromOffset((PsiFile)element3.getContainingFile(), (int)element3.getTextOffset());
                return sourcePosition3;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)localReferenceExpression);
        }
        return null;
    }

    private final List<TextRange> implicitLambdaParameterUsages(KtFunctionLiteral lambda2) {
        List list2;
        List $this$implicitLambdaParameterUsages_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        lambda2.accept((PsiElementVisitor)new KtTreeVisitorVoid(lambda2, $this$implicitLambdaParameterUsages_u24lambda_u243){
            final /* synthetic */ KtFunctionLiteral $lambda;
            final /* synthetic */ List<TextRange> $this_buildList;
            {
                this.$lambda = $lambda;
                this.$this_buildList = $receiver;
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (expression2 instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)ImplicitLambdaParameterUtilsKt.getFunctionLiteralByImplicitLambdaParameter((KtNameReferenceExpression)expression2), (Object)this.$lambda)) {
                    TextRange textRange = ((KtNameReferenceExpression)expression2).getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    this.$this_buildList.add(textRange);
                }
            }
        });
        return CollectionsKt.build((List)list2);
    }

    private final SourcePosition computeSourcePositionForPropertyDeclaration(String name2, ReferenceType declaringType, DebuggerContextImpl context2, boolean nearest) {
        return this.computeSourcePositionForDeclaration(declaringType, context2, nearest, (Function1<? super KtDeclaration, Boolean>)((Function1)new Function1<KtDeclaration, Boolean>(name2, this){
            final /* synthetic */ String $name;
            final /* synthetic */ KotlinSourcePositionProvider this$0;
            {
                this.$name = $name;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$name) || CollectionsKt.contains((Iterable)KotlinSourcePositionProvider.access$getPropertyDeclarationNameVariations(this.this$0, this.$name), (Object)it.getName());
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPropertyDeclarationNameVariations(String $this$getPropertyDeclarationNameVariations) {
        void $this$mapTo$iv$iv;
        Name name2 = Name.guessByFirstCharacter((String)$this$getPropertyDeclarationNameVariations);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(...)");
        Name name3 = name2;
        Iterable $this$map$iv = PropertiesConventionUtilKt.possibleGetMethodNames((Name)name3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Name name4 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asString());
        }
        return (List)destination$iv$iv;
    }

    private final SourcePosition computeSourcePositionForDeclaration(ReferenceType declaringType, DebuggerContextImpl context2, boolean nearest, Function1<? super KtDeclaration, Boolean> declarationSelector) {
        Object v3;
        KtClassOrObject myClass;
        block4: {
            Project project2 = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            PsiElement psiElement2 = this.findClassByType(project2, declaringType, context2);
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getNavigationElement() : null;
            KtClassOrObject ktClassOrObject = psiElement3 instanceof KtClassOrObject ? (KtClassOrObject)psiElement3 : null;
            if (ktClassOrObject == null) {
                return null;
            }
            myClass = ktClassOrObject;
            Iterable $this$firstOrNull$iv = myClass.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)declarationSelector.invoke(element$iv)).booleanValue()) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        KtDeclaration ktDeclaration = v3;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration declaration2 = ktDeclaration;
        if (nearest) {
            return DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiElement)((PsiElement)declaration2), (PsiFile)myClass.getContainingFile());
        }
        return SourcePosition.createFromOffset((PsiFile)declaration2.getContainingFile(), (int)declaration2.getTextOffset());
    }

    private final SourcePosition computeSourcePosition(FieldDescriptor descriptor2, DebuggerContextImpl context2, boolean nearest) {
        String fieldName;
        block3: {
            block2: {
                fieldName = descriptor2.getField().name();
                if (Intrinsics.areEqual((Object)fieldName, (Object)"this$0") || Intrinsics.areEqual((Object)fieldName, (Object)"receiver$0")) break block2;
                Intrinsics.checkNotNull((Object)fieldName);
                if (!StringsKt.startsWith$default((String)fieldName, (String)"this_", (boolean)false, (int)2, null)) break block3;
            }
            return null;
        }
        ReferenceType referenceType = descriptor2.getField().declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
        return this.computeSourcePositionForDeclaration(referenceType, context2, nearest, (Function1<? super KtDeclaration, Boolean>)((Function1)new Function1<KtDeclaration, Boolean>(fieldName){
            final /* synthetic */ String $fieldName;
            {
                this.$fieldName = $fieldName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$fieldName);
            }
        }));
    }

    private final SourcePosition computeSourcePosition(GetterDescriptor descriptor2, DebuggerContextImpl context2, boolean nearest) {
        String name2 = descriptor2.getName();
        ReferenceType type2 = descriptor2.getGetter().declaringType();
        Intrinsics.checkNotNull((Object)type2);
        SourcePosition sourcePosition2 = this.computeSourcePositionForPropertyDeclaration(name2, type2, context2, nearest);
        if (sourcePosition2 != null) {
            SourcePosition it = sourcePosition2;
            boolean bl = false;
            return it;
        }
        if (type2 instanceof ClassType) {
            List superInterfaceTypes = CollectionsKt.distinct((Iterable)SafeUtilKt.safeAllInterfaces((ClassType)type2));
            for (InterfaceType interfaceType : superInterfaceTypes) {
                SourcePosition sourcePosition3 = this.computeSourcePositionForPropertyDeclaration(name2, interfaceType, context2, nearest);
                if (sourcePosition3 == null) continue;
                SourcePosition it = sourcePosition3;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final PsiElement findClassByType(Project project2, ReferenceType type2, DebuggerContextImpl context2) {
        PsiElement element3;
        DebuggerSession debuggerSession = context2.getDebuggerSession();
        if (debuggerSession == null || (debuggerSession = debuggerSession.getSearchScope()) == null) {
            debuggerSession = GlobalSearchScope.allScope((Project)project2);
        }
        DebuggerSession debuggerSession2 = debuggerSession;
        Intrinsics.checkNotNull((Object)debuggerSession2);
        DebuggerSession scope2 = debuggerSession2;
        String string = JvmClassName.byInternalName((String)type2.name()).getFqNameForClassNameWithoutDollars().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String className = string;
        PsiClass myClass = JavaPsiFacade.getInstance((Project)project2).findClass(className, (GlobalSearchScope)scope2);
        if (myClass != null) {
            return (PsiElement)myClass;
        }
        SourcePosition position = this.getLastSourcePosition(type2, context2);
        if (position != null && (element3 = position.getElementAt()) != null) {
            PsiElement $this$getStrictParentOfType$iv = element3;
            boolean $i$f$getStrictParentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
        }
        return null;
    }

    private final SourcePosition getLastSourcePosition(ReferenceType type2, DebuggerContextImpl context2) {
        DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
        if (debugProcessImpl == null) {
            return null;
        }
        DebugProcessImpl debugProcess = debugProcessImpl;
        try {
            List<Location> locations = SafeUtilKt.safeAllLineLocations(type2);
            if (!((Collection)locations).isEmpty()) {
                Location lastLocation = locations.get(locations.size() - 1);
                return debugProcess.getPositionManager().getSourcePosition(lastLocation);
            }
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return null;
    }

    private static final Collection computeSourcePosition$lambda$2$lambda$0(KotlinSourcePositionProvider this$0, KtFunctionLiteral $lambda, PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$lambda, (String)"$lambda");
        return this$0.implicitLambdaParameterUsages($lambda);
    }

    public static final /* synthetic */ List access$getPropertyDeclarationNameVariations(KotlinSourcePositionProvider $this, String $receiver) {
        return $this.getPropertyDeclarationNameVariations($receiver);
    }
}

