/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0004H\u0007\u001a\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007H\u0007R\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u0007H\u0007R\u00020\b\u00a2\u0006\u0002\u0010\u000b\u001a\u0015\u0010\f\u001a\u00020\r*\u00020\u000eH\u0007R\u00020\b\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"getByteCodeMethodName", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "getClassName", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getContainingClassOrObjectSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "getJvmInternalClassName", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;)Ljava/lang/String;", "isInlineClass", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\njvmNameUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jvmNameUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/JvmNameUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,68:1\n766#2:69\n857#2,2:70\n661#2,11:72\n14#3:83\n14#3:84\n28#4,2:85\n36#5,8:87\n*S KotlinDebug\n*F\n+ 1 jvmNameUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/JvmNameUtilKt\n*L\n23#1:69\n23#1:70,2\n25#1:72,11\n26#1:83\n27#1:84\n39#1:85,2\n39#1:87,8\n*E\n"})
public final class JvmNameUtilKt {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ApiStatus.Internal
    @NotNull
    public static final String getByteCodeMethodName(@NotNull KaNamedFunctionSymbol $this$getByteCodeMethodName) {
        Iterable jvmName;
        Iterable iterable;
        block11: {
            String string;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getByteCodeMethodName, (String)"<this>");
            Iterable $this$filter$iv = $this$getByteCodeMethodName.getAnnotations();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KaAnnotation it = (KaAnnotation)element$iv$iv;
                boolean bl = false;
                ClassId classId = it.getClassId();
                if (!Intrinsics.areEqual((Object)(classId != null ? classId.asFqNameString() : null), (Object)"kotlin.jvm.JvmName")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
            do {
                KaAnnotationValue kaAnnotationValue;
                Object v2;
                block12: {
                    if (!iterator2.hasNext()) {
                        iterable = null;
                        break block11;
                    }
                    KaAnnotation it = (KaAnnotation)iterator2.next();
                    boolean bl = false;
                    Iterable $this$singleOrNull$iv = it.getArguments();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        KaNamedAnnotationValue a = (KaNamedAnnotationValue)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)a.getName().asString(), (Object)"name")) continue;
                        if (found$iv) {
                            v2 = null;
                            break block12;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v2 = !found$iv ? null : single$iv;
                }
                KaNamedAnnotationValue kaNamedAnnotationValue = v2;
                if (kaNamedAnnotationValue != null && (kaAnnotationValue = kaNamedAnnotationValue.getExpression()) != null) {
                    KaConstantValue kaConstantValue;
                    KaAnnotationValue.ConstantValue constantValue;
                    KaAnnotationValue $this$asSafely$iv = kaAnnotationValue;
                    boolean $i$f$asSafely = false;
                    KaAnnotationValue kaAnnotationValue2 = $this$asSafely$iv;
                    if (!(kaAnnotationValue2 instanceof KaAnnotationValue.ConstantValue)) {
                        kaAnnotationValue2 = null;
                    }
                    if ((constantValue = (KaAnnotationValue.ConstantValue)kaAnnotationValue2) != null && (kaConstantValue = constantValue.getValue()) != null) {
                        KaConstantValue.StringValue stringValue;
                        KaConstantValue $this$asSafely$iv2 = kaConstantValue;
                        boolean $i$f$asSafely2 = false;
                        KaConstantValue kaConstantValue2 = $this$asSafely$iv2;
                        if (!(kaConstantValue2 instanceof KaConstantValue.StringValue)) {
                            kaConstantValue2 = null;
                        }
                        if ((stringValue = (KaConstantValue.StringValue)kaConstantValue2) != null) {
                            string = stringValue.getValue();
                            continue;
                        }
                    }
                }
                string = null;
            } while ((iterable2 = string) == null);
            iterable = iterable2;
        }
        Iterable iterable3 = jvmName = iterable;
        if (iterable3 != null) {
            return iterable3;
        }
        String string = $this$getByteCodeMethodName.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    @ApiStatus.Internal
    public static final boolean isInlineClass(@NotNull KaSession $context_receiver_0, @NotNull KaDeclarationSymbol $this$isInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return $this$isInlineClass instanceof KaNamedClassSymbol && ((KaNamedClassSymbol)$this$isInlineClass).isInline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @RequiresReadLock
    @Nullable
    public static final String getClassName(@NotNull KtDeclaration $this$getClassName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"<this>");
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)$this$getClassName).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$getClassName);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)$this$getClassName);
        try {
            String string2;
            KaSession $this$getClassName_u24lambda_u243 = analysisSession$iv$iv;
            boolean bl = false;
            KaDeclarationSymbol kaDeclarationSymbol = $this$getClassName_u24lambda_u243.getSymbol($this$getClassName);
            KaFunctionSymbol kaFunctionSymbol = kaDeclarationSymbol instanceof KaFunctionSymbol ? (KaFunctionSymbol)kaDeclarationSymbol : null;
            if (kaFunctionSymbol == null) {
                string2 = null;
            } else {
                KaFunctionSymbol symbol2 = kaFunctionSymbol;
                String string3 = JvmNameUtilKt.getJvmInternalClassName($this$getClassName_u24lambda_u243, symbol2);
                string2 = string3 != null ? JvmNameUtilsKt.internalNameToFqn(string3) : null;
            }
            string = string2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)$this$getClassName);
        }
        return string;
    }

    @ApiStatus.Internal
    @Nullable
    public static final String getJvmInternalClassName(@NotNull KaSession $context_receiver_0, @NotNull KaFunctionSymbol $this$getJvmInternalClassName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getJvmInternalClassName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        KaClassSymbol classOrObject = JvmNameUtilKt.getContainingClassOrObjectSymbol($context_receiver_0, $this$getJvmInternalClassName);
        if (classOrObject == null) {
            KaFileSymbol kaFileSymbol = $context_receiver_0.getContainingFile($this$getJvmInternalClassName);
            if (kaFileSymbol == null) {
                return null;
            }
            KaFileSymbol fileSymbol = kaFileSymbol;
            PsiElement psiElement2 = fileSymbol.getPsi();
            KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile2 == null) {
                return null;
            }
            KtFile file2 = ktFile2;
            String string2 = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file2).getFileClassFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            string = JvmNameUtilsKt.fqnToInternalName(string2);
        } else {
            ClassId classId = classOrObject.getClassId();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            string = JvmClassName.internalNameByClassId((ClassId)classId2);
        }
        return string;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaClassSymbol getContainingClassOrObjectSymbol(@NotNull KaSession $context_receiver_0, @NotNull KaFunctionSymbol $this$getContainingClassOrObjectSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingClassOrObjectSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        KaDeclarationSymbol symbol2 = $context_receiver_0.getContainingDeclaration($this$getContainingClassOrObjectSymbol);
        while (symbol2 != null) {
            if (symbol2 instanceof KaClassSymbol) {
                return (KaClassSymbol)symbol2;
            }
            symbol2 = $context_receiver_0.getContainingDeclaration(symbol2);
        }
        return null;
    }
}

