/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.BuilderSnapshot;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.testFramework.LightVirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptAdditionalIdeaDependenciesProvider;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitiesKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitiesKt$findDependentScripts$;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntity;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntityKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitySource;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptId;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptLibraryEntity;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptLibraryEntityKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptLibraryEntitySource;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptLibraryId;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptLibraryRoot;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptLibraryRootTypeId;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\n\u001a\u00020\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a6\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002\u001a\"\u0010\u0017\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0019*\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019*\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\u001a\u0014\u0010 \u001a\u00020\r*\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\"\u0010!\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\"\u001a\u00020\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002\u001a\u001a\u0010$\u001a\u00020\u0012*\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002\u001a0\u0010&\u001a\u00020\u0012*\u00020'2\u0006\u0010\b\u001a\u00020\t2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0000\u001a0\u0010&\u001a\u00020\u0012*\u00020\u00022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006*"}, d2={"addNewScriptEntity", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptEntity;", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "libraryRefs", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptLibraryId;", "project", "Lcom/intellij/openapi/project/Project;", "createLibraryEntity", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptLibraryEntity$Builder;", "name", "", "dependency", "rootTypeId", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptLibraryRootTypeId;", "fillWithFiles", "", "", "classFiles", "", "sourceFiles", "fillWithIdeSpecificDependencies", "findDependentScripts", "", "getActualScriptLibraries", "Lorg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptLibraryEntity;", "hasSameRootsAs", "", "listDependencies", "mergeClassAndSourceRoots", "relativeName", "removeOutdatedLibraries", "existingScriptEntity", "actualLibraries", "removeOutdatedScripts", "removedScriptPaths", "syncScriptEntities", "Lcom/intellij/platform/backend/workspace/BuilderSnapshot;", "scriptFilesToAddOrUpdate", "scriptFilesToRemove", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nkotlinScriptEntities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinScriptEntities.kt\norg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptEntitiesKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,258:1\n35#2:259\n473#3:260\n1549#4:261\n1620#4,3:262\n1855#4:265\n1549#4:266\n1620#4,3:267\n1855#4,2:270\n1856#4:272\n1855#4,2:273\n1603#4,9:275\n1855#4:284\n1856#4:286\n1612#4:287\n1855#4:288\n1603#4,9:289\n1855#4:298\n1856#4:300\n1612#4:301\n1855#4,2:302\n1856#4:304\n1855#4,2:305\n1855#4,2:307\n1549#4:309\n1620#4,3:310\n1477#4:313\n1502#4,3:314\n1505#4,3:324\n1549#4:327\n1620#4,2:328\n1360#4:330\n1446#4,5:331\n1622#4:336\n1855#4,2:337\n1#5:285\n1#5:299\n372#6,7:317\n*S KotlinDebug\n*F\n+ 1 kotlinScriptEntities.kt\norg/jetbrains/kotlin/idea/core/script/ucache/KotlinScriptEntitiesKt\n*L\n32#1:259\n53#1:260\n82#1:261\n82#1:262,3\n85#1:265\n91#1:266\n91#1:267,3\n108#1:270,2\n85#1:272\n128#1:273,2\n152#1:275,9\n152#1:284\n152#1:286\n152#1:287\n153#1:288\n155#1:289,9\n155#1:298\n155#1:300\n155#1:301\n156#1:302,2\n153#1:304\n174#1:305,2\n177#1:307,2\n197#1:309\n197#1:310,3\n213#1:313\n213#1:314,3\n213#1:324,3\n214#1:327\n214#1:328,2\n219#1:330\n219#1:331,5\n214#1:336\n228#1:337,2\n152#1:285\n155#1:299\n213#1:317,7\n*E\n"})
public final class KotlinScriptEntitiesKt {
    @NotNull
    public static final List<VirtualFile> listDependencies(@NotNull KotlinScriptEntity $this$listDependencies, @NotNull Project project2, @Nullable KotlinScriptLibraryRootTypeId rootTypeId) {
        Sequence sequence2;
        Intrinsics.checkNotNullParameter((Object)$this$listDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ImmutableEntityStorage storage = WorkspaceModel.Companion.getInstance(project2).getCurrentSnapshot();
        Sequence sequence3 = SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$this$listDependencies.getDependencies()), (Function1)((Function1)new Function1<KotlinScriptLibraryId, KotlinScriptLibraryEntity>(storage){
            final /* synthetic */ ImmutableEntityStorage $storage;
            {
                this.$storage = $storage;
                super(1);
            }

            @Nullable
            public final KotlinScriptLibraryEntity invoke(@NotNull KotlinScriptLibraryId it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (KotlinScriptLibraryEntity)this.$storage.resolve((SymbolicEntityId)it);
            }
        })), (Function1)listDependencies.2.INSTANCE);
        boolean condition$iv = rootTypeId != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$listDependencies_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            sequence2 = SequencesKt.filter((Sequence)$this$listDependencies_u24lambda_u240, (Function1)((Function1)new Function1<KotlinScriptLibraryRoot, Boolean>(rootTypeId){
                final /* synthetic */ KotlinScriptLibraryRootTypeId $rootTypeId;
                {
                    this.$rootTypeId = $rootTypeId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KotlinScriptLibraryRoot it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getType(), (Object)this.$rootTypeId);
                }
            }));
        } else {
            sequence2 = $this$applyIf$iv;
        }
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)sequence2, (Function1)listDependencies.4.INSTANCE), (Function1)listDependencies.5.INSTANCE));
    }

    public static /* synthetic */ List listDependencies$default(KotlinScriptEntity kotlinScriptEntity, Project project2, KotlinScriptLibraryRootTypeId kotlinScriptLibraryRootTypeId, int n, Object object) {
        if ((n & 2) != 0) {
            kotlinScriptLibraryRootTypeId = null;
        }
        return KotlinScriptEntitiesKt.listDependencies(kotlinScriptEntity, project2, kotlinScriptLibraryRootTypeId);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<KotlinScriptEntity> findDependentScripts(@NotNull VirtualFile $this$findDependentScripts, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$findDependentScripts, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        ImmutableEntityStorage storage = workspaceModel.getCurrentSnapshot();
        VirtualFileUrlIndex index = storage.getVirtualFileUrlIndex();
        VirtualFileUrlManager fileUrlManager = workspaceModel.getVirtualFileUrlManager();
        for (VirtualFile currentFile = $this$findDependentScripts; currentFile != null; currentFile = currentFile.getParent()) {
            void $this$filterIsInstance$iv;
            String string = currentFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            Sequence entities = index.findEntitiesByUrl(fileUrlManager.getOrCreateFromUrl(string));
            if (SequencesKt.none((Sequence)entities)) {
                continue;
            }
            Sequence sequence2 = entities;
            boolean $i$f$filterIsInstance = false;
            Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findDependentScripts$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)sequence3, (Function1)findDependentScripts.1.INSTANCE), (Function1)((Function1)new Function1<KotlinScriptId, KotlinScriptEntity>(storage){
                final /* synthetic */ ImmutableEntityStorage $storage;
                {
                    this.$storage = $storage;
                    super(1);
                }

                @NotNull
                public final KotlinScriptEntity invoke(@NotNull KotlinScriptId it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KotlinScriptEntity kotlinScriptEntity = (KotlinScriptEntity)this.$storage.resolve((SymbolicEntityId)it);
                    if (kotlinScriptEntity == null) {
                        throw new IllegalStateException(("Unresolvable script: " + it.getPath()).toString());
                    }
                    return kotlinScriptEntity;
                }
            })));
        }
        return null;
    }

    public static final void syncScriptEntities(@NotNull BuilderSnapshot $this$syncScriptEntities, @NotNull Project project2, @NotNull List<? extends VirtualFile> scriptFilesToAddOrUpdate, @NotNull List<? extends VirtualFile> scriptFilesToRemove) {
        Intrinsics.checkNotNullParameter((Object)$this$syncScriptEntities, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(scriptFilesToAddOrUpdate, (String)"scriptFilesToAddOrUpdate");
        Intrinsics.checkNotNullParameter(scriptFilesToRemove, (String)"scriptFilesToRemove");
        KotlinScriptEntitiesKt.syncScriptEntities($this$syncScriptEntities.getBuilder(), scriptFilesToAddOrUpdate, scriptFilesToRemove, project2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void syncScriptEntities(MutableEntityStorage $this$syncScriptEntities, List<? extends VirtualFile> scriptFilesToAddOrUpdate, List<? extends VirtualFile> scriptFilesToRemove, Project project2) {
        if (!((Collection)scriptFilesToRemove).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = scriptFilesToRemove;
            MutableEntityStorage mutableEntityStorage = $this$syncScriptEntities;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                collection.add(string);
            }
            KotlinScriptEntitiesKt.removeOutdatedScripts(mutableEntityStorage, (List)destination$iv$iv);
        }
        Iterable $this$forEach$iv = scriptFilesToAddOrUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            VirtualFile scriptFile = (VirtualFile)element$iv;
            boolean bl = false;
            List<KotlinScriptLibraryEntity> actualLibraries = KotlinScriptEntitiesKt.getActualScriptLibraries($this$syncScriptEntities, scriptFile, project2);
            if (actualLibraries.isEmpty()) continue;
            Iterable $this$map$iv = actualLibraries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinScriptLibraryEntity kotlinScriptLibraryEntity = (KotlinScriptLibraryEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSymbolicId());
            }
            Set actualLibRefs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String string = scriptFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            KotlinScriptEntity kotlinScriptEntity = (KotlinScriptEntity)$this$syncScriptEntities.resolve((SymbolicEntityId)new KotlinScriptId(string));
            if (kotlinScriptEntity == null) {
                kotlinScriptEntity = KotlinScriptEntitiesKt.addNewScriptEntity($this$syncScriptEntities, scriptFile, actualLibRefs, project2);
            }
            KotlinScriptEntity scriptEntity = kotlinScriptEntity;
            KotlinScriptEntitiesKt.removeOutdatedLibraries($this$syncScriptEntities, scriptEntity, actualLibraries);
            Set<KotlinScriptLibraryId> currentLibRefs = scriptEntity.getDependencies();
            Set refsToAdd = SetsKt.minus((Set)actualLibRefs, (Iterable)currentLibRefs);
            Set refsToRemove = SetsKt.minus(currentLibRefs, (Iterable)actualLibRefs);
            if (!((Collection)refsToAdd).isEmpty() || !((Collection)refsToRemove).isEmpty()) {
                KotlinScriptEntityKt.modifyKotlinScriptEntity($this$syncScriptEntities, scriptEntity, (Function1<? super KotlinScriptEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptEntity.Builder, Unit>((Set<KotlinScriptLibraryId>)refsToRemove, (Set<KotlinScriptLibraryId>)refsToAdd){
                    final /* synthetic */ Set<KotlinScriptLibraryId> $refsToRemove;
                    final /* synthetic */ Set<KotlinScriptLibraryId> $refsToAdd;
                    {
                        this.$refsToRemove = $refsToRemove;
                        this.$refsToAdd = $refsToAdd;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinScriptEntity.Builder $this$modifyKotlinScriptEntity) {
                        Intrinsics.checkNotNullParameter((Object)$this$modifyKotlinScriptEntity, (String)"$this$modifyKotlinScriptEntity");
                        $this$modifyKotlinScriptEntity.getDependencies().removeAll((Collection)this.$refsToRemove);
                        $this$modifyKotlinScriptEntity.getDependencies().addAll((Collection<KotlinScriptLibraryId>)this.$refsToAdd);
                    }
                }));
            }
            Iterable $this$forEach$iv2 = actualLibraries;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinScriptLibraryEntity it = (KotlinScriptLibraryEntity)element$iv2;
                boolean bl3 = false;
                if (it.getUsedInScripts().contains(scriptEntity.getSymbolicId())) continue;
                KotlinScriptLibraryEntityKt.modifyKotlinScriptLibraryEntity($this$syncScriptEntities, it, (Function1<? super KotlinScriptLibraryEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptLibraryEntity.Builder, Unit>(scriptEntity){
                    final /* synthetic */ KotlinScriptEntity $scriptEntity;
                    {
                        this.$scriptEntity = $scriptEntity;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinScriptLibraryEntity.Builder $this$modifyKotlinScriptLibraryEntity) {
                        Intrinsics.checkNotNullParameter((Object)$this$modifyKotlinScriptLibraryEntity, (String)"$this$modifyKotlinScriptLibraryEntity");
                        $this$modifyKotlinScriptLibraryEntity.getUsedInScripts().add(this.$scriptEntity.getSymbolicId());
                    }
                }));
            }
        }
    }

    private static final void removeOutdatedLibraries(MutableEntityStorage $this$removeOutdatedLibraries, KotlinScriptEntity existingScriptEntity, List<? extends KotlinScriptLibraryEntity> actualLibraries) {
        Set currentLibraries2 = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)$this$removeOutdatedLibraries.entities(KotlinScriptLibraryEntity.class), (Function1)((Function1)new Function1<KotlinScriptLibraryEntity, Boolean>(existingScriptEntity){
            final /* synthetic */ KotlinScriptEntity $existingScriptEntity;
            {
                this.$existingScriptEntity = $existingScriptEntity;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KotlinScriptLibraryEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getUsedInScripts().contains(this.$existingScriptEntity.getSymbolicId());
            }
        })));
        Set outdatedLibraries = SetsKt.minus((Set)currentLibraries2, (Iterable)CollectionsKt.toSet((Iterable)actualLibraries));
        Iterable $this$forEach$iv = outdatedLibraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinScriptLibraryEntity it = (KotlinScriptLibraryEntity)element$iv;
            boolean bl = false;
            if (it.getUsedInScripts().size() == 1) {
                $this$removeOutdatedLibraries.removeEntity((WorkspaceEntity)it);
                continue;
            }
            KotlinScriptLibraryEntityKt.modifyKotlinScriptLibraryEntity($this$removeOutdatedLibraries, it, (Function1<? super KotlinScriptLibraryEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptLibraryEntity.Builder, Unit>(existingScriptEntity){
                final /* synthetic */ KotlinScriptEntity $existingScriptEntity;
                {
                    this.$existingScriptEntity = $existingScriptEntity;
                    super(1);
                }

                public final void invoke(@NotNull KotlinScriptLibraryEntity.Builder $this$modifyKotlinScriptLibraryEntity) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyKotlinScriptLibraryEntity, (String)"$this$modifyKotlinScriptLibraryEntity");
                    $this$modifyKotlinScriptLibraryEntity.getUsedInScripts().remove(this.$existingScriptEntity.getSymbolicId());
                }
            }));
        }
    }

    private static final KotlinScriptEntity addNewScriptEntity(MutableEntityStorage $this$addNewScriptEntity, VirtualFile scriptFile, Set<KotlinScriptLibraryId> libraryRefs, Project project2) {
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager();
        KotlinScriptEntitySource scriptSource = new KotlinScriptEntitySource(VirtualFileUrls.toVirtualFileUrl((VirtualFile)scriptFile, (VirtualFileUrlManager)fileUrlManager));
        String string = scriptFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        KotlinScriptEntity.Builder scriptEntity = KotlinScriptEntity.Companion.create$default(KotlinScriptEntity.Companion, string, libraryRefs, scriptSource, null, 8, null);
        return (KotlinScriptEntity)$this$addNewScriptEntity.addEntity((WorkspaceEntity.Builder)scriptEntity);
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeOutdatedScripts(MutableEntityStorage $this$removeOutdatedScripts, List<String> removedScriptPaths) {
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = removedScriptPaths;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinScriptEntity it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((KotlinScriptEntity)$this$removeOutdatedScripts.resolve((SymbolicEntityId)new KotlinScriptId(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv2;
            KotlinScriptEntity outdatedScript = (KotlinScriptEntity)element$iv;
            boolean bl = false;
            Iterable $i$f$forEach3 = outdatedScript.getDependencies();
            boolean $i$f$mapNotNull2 = false;
            element$iv$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach4 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                KotlinScriptLibraryEntity it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator3.next();
                boolean bl4 = false;
                KotlinScriptLibraryId it = (KotlinScriptLibraryId)element$iv$iv;
                boolean bl5 = false;
                if ((KotlinScriptLibraryEntity)it.resolve((EntityStorage)$this$removeOutdatedScripts) == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach5 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinScriptLibraryEntity it = (KotlinScriptLibraryEntity)element$iv2;
                boolean bl7 = false;
                if (it.getUsedInScripts().size() == 1) {
                    $this$removeOutdatedScripts.removeEntity((WorkspaceEntity)it);
                    continue;
                }
                KotlinScriptLibraryEntityKt.modifyKotlinScriptLibraryEntity($this$removeOutdatedScripts, it, (Function1<? super KotlinScriptLibraryEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptLibraryEntity.Builder, Unit>(outdatedScript){
                    final /* synthetic */ KotlinScriptEntity $outdatedScript;
                    {
                        this.$outdatedScript = $outdatedScript;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinScriptLibraryEntity.Builder $this$modifyKotlinScriptLibraryEntity) {
                        Intrinsics.checkNotNullParameter((Object)$this$modifyKotlinScriptLibraryEntity, (String)"$this$modifyKotlinScriptLibraryEntity");
                        $this$modifyKotlinScriptLibraryEntity.getUsedInScripts().remove(this.$outdatedScript.getSymbolicId());
                    }
                }));
            }
            $this$removeOutdatedScripts.removeEntity((WorkspaceEntity)outdatedScript);
        }
    }

    private static final void fillWithFiles(List<KotlinScriptLibraryEntity.Builder> $this$fillWithFiles, Project project2, Collection<? extends VirtualFile> classFiles, Collection<? extends VirtualFile> sourceFiles2) {
        VirtualFile it;
        Iterable $this$forEach$iv = classFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFile)element$iv;
            boolean bl = false;
            String string = it.getPresentableUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
            $this$fillWithFiles.add(KotlinScriptEntitiesKt.createLibraryEntity(project2, string, it, KotlinScriptLibraryRootTypeId.Companion.getCOMPILED()));
        }
        $this$forEach$iv = sourceFiles2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFile)element$iv;
            boolean bl = false;
            String string = it.getPresentableUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
            $this$fillWithFiles.add(KotlinScriptEntitiesKt.createLibraryEntity(project2, string, it, KotlinScriptLibraryRootTypeId.Companion.getSOURCES()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinScriptLibraryEntity> getActualScriptLibraries(MutableEntityStorage $this$getActualScriptLibraries, VirtualFile scriptFile, Project project2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ScriptConfigurationManager configurationManager = ScriptConfigurationManager.Companion.getInstance(project2);
        Collection<VirtualFile> dependenciesClassFiles = ScriptDependencyAware.Companion.getInstance(project2).getScriptDependenciesClassFiles(scriptFile);
        Collection<VirtualFile> dependenciesSourceFiles = configurationManager.getScriptDependenciesSourceFiles(scriptFile);
        List libraries = new ArrayList();
        KotlinScriptEntitiesKt.fillWithFiles(libraries, project2, dependenciesClassFiles, dependenciesSourceFiles);
        KotlinScriptEntitiesKt.fillWithIdeSpecificDependencies(libraries, project2, scriptFile);
        List<KotlinScriptLibraryEntity.Builder> mergedLibraries = KotlinScriptEntitiesKt.mergeClassAndSourceRoots(libraries);
        Iterable iterable = mergedLibraries;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KotlinScriptLibraryEntity kotlinScriptLibraryEntity;
            void library2;
            KotlinScriptLibraryEntity.Builder builder2 = (KotlinScriptLibraryEntity.Builder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinScriptLibraryEntity existingLibrary = (KotlinScriptLibraryEntity)$this$getActualScriptLibraries.resolve((SymbolicEntityId)new KotlinScriptLibraryId(library2.getName()));
            if (existingLibrary != null) {
                if (!KotlinScriptEntitiesKt.hasSameRootsAs(existingLibrary, (KotlinScriptLibraryEntity.Builder)library2)) {
                    KotlinScriptLibraryEntityKt.modifyKotlinScriptLibraryEntity($this$getActualScriptLibraries, existingLibrary, (Function1<? super KotlinScriptLibraryEntity.Builder, Unit>)((Function1)new Function1<KotlinScriptLibraryEntity.Builder, Unit>((KotlinScriptLibraryEntity.Builder)library2){
                        final /* synthetic */ KotlinScriptLibraryEntity.Builder $library;
                        {
                            this.$library = $library;
                            super(1);
                        }

                        public final void invoke(@NotNull KotlinScriptLibraryEntity.Builder $this$modifyKotlinScriptLibraryEntity) {
                            Intrinsics.checkNotNullParameter((Object)$this$modifyKotlinScriptLibraryEntity, (String)"$this$modifyKotlinScriptLibraryEntity");
                            $this$modifyKotlinScriptLibraryEntity.setRoots(CollectionsKt.toMutableList((Collection)this.$library.getRoots()));
                        }
                    }));
                }
                kotlinScriptLibraryEntity = existingLibrary;
            } else {
                kotlinScriptLibraryEntity = (KotlinScriptLibraryEntity)$this$getActualScriptLibraries.addEntity((WorkspaceEntity.Builder)library2);
            }
            collection.add(kotlinScriptLibraryEntity);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinScriptLibraryEntity.Builder> mergeClassAndSourceRoots(List<KotlinScriptLibraryEntity.Builder> $this$mergeClassAndSourceRoots) {
        void $this$mapTo$iv$iv;
        List list$iv$iv;
        List answer$iv$iv$iv;
        Object key$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$mergeClassAndSourceRoots;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KotlinScriptLibraryEntity.Builder it = (KotlinScriptLibraryEntity.Builder)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KotlinScriptLibraryEntity.Builder builder2;
            void libsWithSameName;
            list$iv$iv = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            if (libsWithSameName.size() == 1) {
                builder2 = (KotlinScriptLibraryEntity.Builder)CollectionsKt.single((List)libsWithSameName);
            } else {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                key$iv$iv = (Iterable)libsWithSameName;
                String string = ((KotlinScriptLibraryEntity.Builder)CollectionsKt.first((List)libsWithSameName)).getName();
                KotlinScriptLibraryEntity.Companion companion = KotlinScriptLibraryEntity.Companion;
                boolean $i$f$flatMap = false;
                answer$iv$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KotlinScriptLibraryEntity.Builder it = (KotlinScriptLibraryEntity.Builder)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv2 = it.getRoots();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
                }
                List list2 = (List)destination$iv$iv2;
                builder2 = KotlinScriptLibraryEntity.Companion.create$default(companion, string, list2, false, ((KotlinScriptLibraryEntity.Builder)CollectionsKt.first((List)libsWithSameName)).getUsedInScripts(), ((KotlinScriptLibraryEntity.Builder)CollectionsKt.first((List)libsWithSameName)).getEntitySource(), null, 32, null);
            }
            object.add(builder2);
        }
        return (List)destination$iv$iv;
    }

    private static final void fillWithIdeSpecificDependencies(List<KotlinScriptLibraryEntity.Builder> $this$fillWithIdeSpecificDependencies, Project project2, VirtualFile scriptFile) {
        Iterable $this$forEach$iv = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedLibraries(scriptFile, project2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RootProvider provider;
            Library lib = (Library)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)lib.getRootProvider(), (String)"getRootProvider(...)");
            VirtualFile[] virtualFileArray = provider.getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
            Collection collection = ArraysKt.asList((Object[])virtualFileArray);
            VirtualFile[] virtualFileArray2 = provider.getFiles(OrderRootType.SOURCES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
            KotlinScriptEntitiesKt.fillWithFiles($this$fillWithIdeSpecificDependencies, project2, collection, ArraysKt.asList((Object[])virtualFileArray2));
        }
    }

    private static final boolean hasSameRootsAs(KotlinScriptLibraryEntity $this$hasSameRootsAs, KotlinScriptLibraryEntity.Builder dependency) {
        return $this$hasSameRootsAs.getRoots().containsAll((Collection)dependency.getRoots()) && dependency.getRoots().containsAll((Collection)$this$hasSameRootsAs.getRoots());
    }

    @NotNull
    public static final String relativeName(@NotNull VirtualFile $this$relativeName, @NotNull Project project2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$relativeName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (ScratchUtil.isScratch((VirtualFile)$this$relativeName) || $this$relativeName instanceof LightVirtualFile) {
            String string = $this$relativeName.getPresentableName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        } else {
            Path path2 = $this$relativeName.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            String string = project2.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            Path path3 = Path.of(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
            object = PathsKt.relativeToOrNull((Path)path2, (Path)path3);
            if (object == null || (object = object.toString()) == null) {
                String string2 = $this$relativeName.getPresentableName();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
            }
        }
        return object;
    }

    private static final KotlinScriptLibraryEntity.Builder createLibraryEntity(Project $this$createLibraryEntity, String name2, VirtualFile dependency, KotlinScriptLibraryRootTypeId rootTypeId) {
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.Companion.getInstance($this$createLibraryEntity).getVirtualFileUrlManager();
        VirtualFileUrl fileUrl = VirtualFileUrls.toVirtualFileUrl((VirtualFile)dependency, (VirtualFileUrlManager)fileUrlManager);
        KotlinScriptLibraryEntitySource libraryEntitySource = new KotlinScriptLibraryEntitySource(fileUrl);
        Object[] objectArray = new KotlinScriptLibraryRoot[]{new KotlinScriptLibraryRoot(fileUrl, rootTypeId)};
        List libraryRoots = CollectionsKt.mutableListOf((Object[])objectArray);
        return KotlinScriptLibraryEntity.Companion.create$default(KotlinScriptLibraryEntity.Companion, name2, libraryRoots, false, SetsKt.emptySet(), libraryEntitySource, null, 32, null);
    }
}

