/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.DependencyScope;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.DependenciesFiles;
import org.jetbrains.kotlin.idea.core.script.K2ScriptDefinitionProvider;
import org.jetbrains.kotlin.idea.core.script.K2ScriptDependenciesProvider;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptEntitySourceK2;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptModel;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a0\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014\u001a,\u0010\u0015\u001a\u00020\u0003*\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0086@\u00a2\u0006\u0002\u0010\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"KOTLIN_SCRIPTS_MODULE_NAME", "", "createPureScriptModules", "", "project", "Lcom/intellij/openapi/project/Project;", "scriptPaths", "", "Lorg/jetbrains/kotlin/idea/core/script/ScriptModel;", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getDependenciesFiles", "Lorg/jetbrains/kotlin/idea/core/script/DependenciesFiles;", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createDependencies", "", "Lcom/intellij/platform/workspace/jps/entities/ModuleDependencyItem;", "moduleName", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "createScriptModules", "scripts", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nmodule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 module.kt\norg/jetbrains/kotlin/idea/core/script/ModuleKt\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n18#2,4:121\n50#2,7:125\n1#3:132\n1549#4:133\n1620#4,3:134\n1549#4:137\n1620#4,3:138\n1549#4:141\n1620#4,3:142\n*S KotlinDebug\n*F\n+ 1 module.kt\norg/jetbrains/kotlin/idea/core/script/ModuleKt\n*L\n30#1:121,4\n30#1:125,7\n47#1:133\n47#1:134,3\n106#1:137\n106#1:138,3\n110#1:141\n110#1:142,3\n*E\n"})
public final class ModuleKt {
    @NotNull
    public static final String KOTLIN_SCRIPTS_MODULE_NAME = "Kotlin Scripts";

    @Nullable
    public static final Object createScriptModules(@NotNull Project $this$createScriptModules, @NotNull Set<ScriptModel> scripts, @Nullable MutableEntityStorage storage, @NotNull Continuation<? super Unit> $completion) {
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)$this$createScriptModules);
        ImmutableEntityStorage storageSnapshot = workspaceModel.getCurrentSnapshot();
        MutableEntityStorage tempStorage = MutableEntityStorage.Companion.from(storageSnapshot);
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        MutableEntityStorage mutableEntityStorage = storage;
        if (mutableEntityStorage == null) {
            mutableEntityStorage = tempStorage;
        }
        ModuleKt.createPureScriptModules($this$createScriptModules, scripts, mutableEntityStorage);
        long duration2 = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)new Function0<String>(duration2){
            final /* synthetic */ long $duration;
            {
                this.$duration = $duration;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "createPureScriptModules duration = " + Duration.toString-impl((long)this.$duration);
            }
        }, 1, null);
        if (storage == null) {
            Object object = workspaceModel.update("Updating kotlin scripts modules", (Function1)new Function1<MutableEntityStorage, Unit>(tempStorage){
                final /* synthetic */ MutableEntityStorage $tempStorage;
                {
                    this.$tempStorage = $tempStorage;
                    super(1);
                }

                public final void invoke(@NotNull MutableEntityStorage it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.applyChangesFrom(this.$tempStorage);
                }
            }, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object createScriptModules$default(Project project2, Set set, MutableEntityStorage mutableEntityStorage, Continuation continuation2, int n, Object object) {
        if ((n & 2) != 0) {
            mutableEntityStorage = null;
        }
        return ModuleKt.createScriptModules(project2, set, mutableEntityStorage, (Continuation<? super Unit>)continuation2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void createPureScriptModules(Project project2, Set<ScriptModel> scriptPaths, MutableEntityStorage storage) {
        void $this$mapTo$iv$iv;
        Path path2;
        String string = project2.getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            path2 = Path.of(it, new String[0]);
        } else {
            path2 = null;
        }
        if (path2 == null) {
            return;
        }
        Path projectPath2 = path2;
        Set sourcesToUpdate = new LinkedHashSet();
        MutableEntityStorage updatedStorage = MutableEntityStorage.Companion.create();
        Iterable $this$map$iv = scriptPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScriptModel scriptModel = (ScriptModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVirtualFile());
        }
        for (VirtualFile scriptFile : (List)destination$iv$iv) {
            String relativeLocation;
            ScriptDefinition definition2;
            Object object;
            File file2;
            File basePath;
            if (ScratchUtil.isScratch((VirtualFile)scriptFile) || FileUtil.getRelativePath((File)(basePath = projectPath2.toFile()), (File)(file2 = Path.of(scriptFile.getPath(), new String[0]).toFile())) == null || (object = (definition2 = K2ScriptDefinitionProvider.Companion.getInstance(project2).findDefinition(new VirtualFileScriptSource(scriptFile, null, 2, null)))) == null || (object = object.getName()) == null) continue;
            Object definitionName = object;
            String definitionScriptModuleName = "Kotlin Scripts." + (String)definitionName;
            String locationName = StringsKt.replace$default((String)relativeLocation, (char)'/', (char)':', (boolean)false, (int)4, null);
            String moduleName2 = definitionScriptModuleName + "." + locationName;
            KotlinScriptEntitySourceK2 source = new KotlinScriptEntitySourceK2(VirtualFileUrls.toVirtualFileUrl((VirtualFile)scriptFile, (VirtualFileUrlManager)WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager()));
            ((Collection)sourcesToUpdate).add(source);
            List<ModuleDependencyItem> dependencies2 = ModuleKt.createDependencies(updatedStorage, moduleName2, scriptFile, project2, source);
            updatedStorage.addEntity((WorkspaceEntity.Builder)ModuleEntity.Companion.create$default((ModuleEntity.Companion)ModuleEntity.Companion, (String)moduleName2, dependencies2, (EntitySource)source, null, (int)8, null));
        }
        storage.replaceBySource((Function1)new Function1<EntitySource, Boolean>((Set<KotlinScriptEntitySourceK2>)sourcesToUpdate){
            final /* synthetic */ Set<KotlinScriptEntitySourceK2> $sourcesToUpdate;
            {
                this.$sourcesToUpdate = $sourcesToUpdate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull EntitySource entitySource) {
                Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
                return CollectionsKt.contains((Iterable)this.$sourcesToUpdate, (Object)entitySource);
            }
        }, (EntityStorage)updatedStorage);
    }

    private static final DependenciesFiles getDependenciesFiles(VirtualFile scriptFile, Project project2) {
        SdkDependency sdkDependency;
        K2ScriptDependenciesProvider dependenciesProvider = K2ScriptDependenciesProvider.Companion.getInstance(project2);
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics = dependenciesProvider.getConfiguration(scriptFile);
        if (resultWithDiagnostics == null || (resultWithDiagnostics = ErrorHandlingKt.valueOrNull(resultWithDiagnostics)) == null) {
            return DependenciesFiles.Companion.getEMPTY();
        }
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> wrapper = resultWithDiagnostics;
        Sdk sdk2 = dependenciesProvider.getScriptSdk(scriptFile);
        if (sdk2 != null) {
            Sdk it = sdk2;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = it.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            sdkDependency = new SdkDependency(new SdkId(string, string2));
        } else {
            sdkDependency = null;
        }
        SdkDependency sdk3 = sdkDependency;
        List<VirtualFile> dependenciesClassFiles = ScriptConfigurationManager.Companion.toVfsRoots((Iterable<? extends File>)((ScriptCompilationConfigurationWrapper)((Object)wrapper)).getDependenciesClassPath());
        List<VirtualFile> dependenciesSourceFiles = ScriptConfigurationManager.Companion.toVfsRoots((Iterable<? extends File>)((ScriptCompilationConfigurationWrapper)((Object)wrapper)).getDependenciesSources());
        return new DependenciesFiles(dependenciesClassFiles, dependenciesSourceFiles, sdk3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleDependencyItem> createDependencies(@NotNull MutableEntityStorage $this$createDependencies, @NotNull String moduleName2, @NotNull VirtualFile scriptFile, @NotNull Project project2, @NotNull EntitySource entitySource) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$createDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        DependenciesFiles dependenciesFiles = ModuleKt.getDependenciesFiles(scriptFile, project2);
        List<VirtualFile> dependenciesClassFiles = dependenciesFiles.component1();
        List<VirtualFile> dependenciesSourceFiles = dependenciesFiles.component2();
        SdkDependency sdk2 = dependenciesFiles.component3();
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager();
        Iterable $this$map$iv = dependenciesClassFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LibraryRoot(VirtualFileUrls.toVirtualFileUrl((VirtualFile)it, (VirtualFileUrlManager)fileUrlManager), LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
        }
        List classRoots = (List)destination$iv$iv;
        Iterable $this$map$iv2 = dependenciesSourceFiles;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile bl = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new LibraryRoot(VirtualFileUrls.toVirtualFileUrl((VirtualFile)it, (VirtualFileUrlManager)fileUrlManager), LibraryRootTypeId.Companion.getSOURCES(), null, 4, null));
        }
        List sourceRoots2 = (List)destination$iv$iv2;
        LibraryTableId.ModuleLibraryTableId libraryTableId = new LibraryTableId.ModuleLibraryTableId(new ModuleId(moduleName2));
        LibraryEntity dependencyLibrary = (LibraryEntity)$this$createDependencies.addEntity((WorkspaceEntity.Builder)LibraryEntity.Companion.create$default((LibraryEntity.Companion)LibraryEntity.Companion, (String)(moduleName2 + " dependencies"), (LibraryTableId)((LibraryTableId)libraryTableId), (List)CollectionsKt.plus((Collection)classRoots, (Iterable)sourceRoots2), (EntitySource)entitySource, null, (int)16, null));
        Object[] objectArray = new ModuleDependencyItem[]{new LibraryDependency(dependencyLibrary.getSymbolicId(), false, DependencyScope.COMPILE), sdk2};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }
}

