/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared;

import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetectorKt;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/KotlinRunLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "getSlowInfo", "isDumbAware", "", "hasSingleMain", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "mainFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.code-insight.line-markers.shared"})
public final class KotlinRunLineMarkerContributor
extends RunLineMarkerContributor {
    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return null;
    }

    @Nullable
    public RunLineMarkerContributor.Info getSlowInfo(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getParent();
        KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function2 = ktNamedFunction;
        if (!Intrinsics.areEqual((Object)function2.getNameIdentifier(), (Object)element3)) {
            return null;
        }
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinMainFunctionDetector detector = KotlinMainFunctionDetector.Companion.getInstanceDumbAware(project2);
        if (!KotlinMainFunctionDetector.isMain$default(detector, function2, null, 2, null)) {
            return null;
        }
        Project project3 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project3) && !this.hasSingleMain(detector, function2)) {
            return null;
        }
        KtFile ktFile2 = function2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        Module module2 = GenericPsiUtils.getModule((PsiElement)ktFile2);
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        if (KotlinFacetUtils.isTestModule(module3)) {
            return null;
        }
        if (!IdePlatformKindToolingKt.getTooling(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)TargetPlatformDetectorUtils.getPlatform(module3))).acceptsAsEntryPoint((KtFunction)function2)) {
            return null;
        }
        Icon icon2 = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.TestStateRun);
        return new RunLineMarkerContributor.Info(icon2, ExecutorAction.Companion.getActions(Integer.MAX_VALUE), null);
    }

    private final boolean hasSingleMain(KotlinMainFunctionDetector $this$hasSingleMain, KtNamedFunction mainFunction) {
        return KotlinMainFunctionDetectorKt.findMainOwner($this$hasSingleMain, (PsiElement)mainFunction) != null;
    }
}

