/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.RunBlockingInspection;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.FunctionNode;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.GraphBuilder;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.RBGraph;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.ElementFilters;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.MyPsiUtils;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00102\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010!\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u001a\u0010\"\u001a\u00020\u00002\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0006J\u0014\u0010$\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u001a\u0010%\u001a\u00020\u00002\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0006R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/GraphBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "incrementFilesDone", "Lkotlin/Function1;", "", "", "level", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection$ExplorationLevel;", "rbFileFound", "Lcom/intellij/openapi/vfs/VirtualFile;", "rbGraph", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/RBGraph;", "relevantFiles", "", "totalFilesTodo", "", "urlToVirtualFileMap", "", "buildGraph", "createSubtree", "builder", "Lcom/intellij/psi/PsiElement;", "exploreFunDeclaration", "currentPsiEl", "currentNode", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/FunctionNode;", "extractCallsFromBody", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "body", "setExplorationLevel", "setIncrementFilesDoneFunction", "setRbFileFound", "fileFound", "setRelevantFiles", "setTotalFilesTodo", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphBuilder.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/GraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1855#2,2:172\n1864#2,3:174\n800#2,11:177\n800#2,11:188\n766#2:199\n857#2,2:200\n1360#2:202\n1446#2,5:203\n1855#2,2:208\n*S KotlinDebug\n*F\n+ 1 GraphBuilder.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/GraphBuilder\n*L\n42#1:172,2\n67#1:174,3\n106#1:177,11\n111#1:188,11\n114#1:199\n114#1:200,2\n117#1:202\n117#1:203,5\n158#1:208,2\n*E\n"})
public final class GraphBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private Function1<? super Integer, Unit> totalFilesTodo;
    @NotNull
    private Function1<? super String, Unit> incrementFilesDone;
    @NotNull
    private Function1<? super VirtualFile, Unit> rbFileFound;
    @NotNull
    private List<? extends VirtualFile> relevantFiles;
    @NotNull
    private RunBlockingInspection.ExplorationLevel level;
    @NotNull
    private Map<String, VirtualFile> urlToVirtualFileMap;
    @NotNull
    private final RBGraph rbGraph;

    public GraphBuilder(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.totalFilesTodo = totalFilesTodo.1.INSTANCE;
        this.incrementFilesDone = incrementFilesDone.1.INSTANCE;
        this.rbFileFound = rbFileFound.1.INSTANCE;
        this.relevantFiles = CollectionsKt.emptyList();
        this.level = RunBlockingInspection.ExplorationLevel.DECLARATION;
        this.urlToVirtualFileMap = new LinkedHashMap();
        this.rbGraph = new RBGraph();
    }

    @NotNull
    public final GraphBuilder setRelevantFiles(@NotNull List<? extends VirtualFile> relevantFiles) {
        Intrinsics.checkNotNullParameter(relevantFiles, (String)"relevantFiles");
        this.relevantFiles = relevantFiles;
        Iterable $this$forEach$iv = relevantFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            Map<String, VirtualFile> map2 = this.urlToVirtualFileMap;
            String string = it.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            map2.put(string, it);
        }
        return this;
    }

    @NotNull
    public final GraphBuilder setIncrementFilesDoneFunction(@NotNull Function1<? super String, Unit> incrementFilesDone2) {
        Intrinsics.checkNotNullParameter(incrementFilesDone2, (String)"incrementFilesDone");
        this.incrementFilesDone = incrementFilesDone2;
        return this;
    }

    @NotNull
    public final GraphBuilder setTotalFilesTodo(@NotNull Function1<? super Integer, Unit> totalFilesTodo2) {
        Intrinsics.checkNotNullParameter(totalFilesTodo2, (String)"totalFilesTodo");
        this.totalFilesTodo = totalFilesTodo2;
        return this;
    }

    @NotNull
    public final GraphBuilder setRbFileFound(@NotNull Function1<? super VirtualFile, Unit> fileFound) {
        Intrinsics.checkNotNullParameter(fileFound, (String)"fileFound");
        this.rbFileFound = fileFound;
        return this;
    }

    @NotNull
    public final GraphBuilder setExplorationLevel(@NotNull RunBlockingInspection.ExplorationLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RBGraph buildGraph() {
        this.totalFilesTodo.invoke((Object)this.relevantFiles.size());
        Iterable $this$forEachIndexed$iv = this.relevantFiles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void file2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualFile virtualFile2 = (VirtualFile)item$iv;
            int index = n;
            boolean bl = false;
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this, (VirtualFile)file2){
                final /* synthetic */ GraphBuilder this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(0);
                }

                public final void invoke() {
                    Iterable $this$forEach$iv;
                    Function1 function1 = GraphBuilder.access$getIncrementFilesDone$p(this.this$0);
                    String string = this.$file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    function1.invoke((Object)string);
                    Iterable iterable = MyPsiUtils.Companion.findRunBlockings(this.$file, GraphBuilder.access$getProject$p(this.this$0));
                    GraphBuilder graphBuilder = this.this$0;
                    VirtualFile virtualFile2 = this.$file;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PsiElement rb = (PsiElement)element$iv;
                        boolean bl = false;
                        GraphBuilder.access$createSubtree(graphBuilder, rb);
                        GraphBuilder.access$getRbFileFound$p(graphBuilder).invoke((Object)virtualFile2);
                    }
                    $this$forEach$iv = MyPsiUtils.Companion.findNonBlockingBuilders(this.$file, GraphBuilder.access$getProject$p(this.this$0));
                    graphBuilder = this.this$0;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        PsiElement builder2 = (PsiElement)element$iv;
                        boolean bl = false;
                        GraphBuilder.access$createSubtree(graphBuilder, builder2);
                    }
                    $this$forEach$iv = MyPsiUtils.Companion.findSuspendFuns(this.$file, GraphBuilder.access$getProject$p(this.this$0));
                    graphBuilder = this.this$0;
                    $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        PsiElement susFun = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(susFun instanceof KtNamedFunction) || ((KtNamedFunction)susFun).getFqName() == null) continue;
                        GraphBuilder.access$exploreFunDeclaration(graphBuilder, susFun, GraphBuilder.access$getRbGraph$p(graphBuilder).getOrCreateFunction((KtNamedFunction)susFun));
                    }
                }
            }));
        }
        return this.rbGraph;
    }

    private final void createSubtree(PsiElement builder2) {
        FunctionNode runBlockingNode = this.rbGraph.addBuilder(builder2);
        if (builder2 instanceof KtCallExpression) {
            List list2 = ((KtCallExpression)builder2).getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.lastOrNull((List)list2);
            if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
                return;
            }
            KtLambdaArgument lam = ktLambdaArgument;
            this.exploreFunDeclaration((PsiElement)lam, runBlockingNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtCallExpression> extractCallsFromBody(PsiElement body2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2 = MyPsiUtils.Companion.findAllChildren(body2, (Function1<? super PsiElement, Boolean>)((Function1)extractCallsFromBody.methodCalls.1.INSTANCE), (Function1<? super PsiElement, Boolean>)((Function1)extractCallsFromBody.methodCalls.2.INSTANCE));
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof KtCallExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methodCalls2 = (List)destination$iv$iv;
        Iterable $i$f$filterIsInstance22 = MyPsiUtils.Companion.findAllChildren(body2, (Function1<? super PsiElement, Boolean>)((Function1)extractCallsFromBody.lambdaExprs.1.INSTANCE), (Function1<? super PsiElement, Boolean>)((Function1)extractCallsFromBody.lambdaExprs.2.INSTANCE));
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtLambdaExpression)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List lambdaExprs2 = (List)destination$iv$iv2;
        Iterable $this$filter$iv = lambdaExprs2;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtLambdaExpression it = (KtLambdaExpression)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ElementFilters.Companion.getLambdaAsArgForInlineFun().isAccepted((PsiElement)it) || ElementFilters.Companion.isSuspendLambda().isAccepted((PsiElement)it);
            if (!bl2) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List inlineLams = (List)destination$iv$iv3;
        $this$filter$iv = inlineLams;
        Collection collection = methodCalls2;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiElement p0 = (PsiElement)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.extractCallsFromBody(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv3));
    }

    private final void exploreFunDeclaration(PsiElement currentPsiEl, FunctionNode currentNode) {
        if (currentNode.getVisited()) {
            return;
        }
        currentNode.setVisited(true);
        List<KtCallExpression> methodCalls2 = this.extractCallsFromBody(currentPsiEl);
        for (KtCallExpression call2 : methodCalls2) {
            VirtualFile funFile;
            KtExpression callee = call2.getCalleeExpression();
            if (!(callee instanceof KtNameReferenceExpression)) continue;
            PsiReference psiReference = ((KtNameReferenceExpression)callee).getReference();
            Object psiFn = psiReference != null ? psiReference.resolve() : null;
            if (!(psiFn instanceof KtNamedFunction) || !this.relevantFiles.contains(funFile = MyPsiUtils.Companion.getFileForElement((PsiElement)psiFn))) continue;
            List toExplore = new ArrayList();
            switch (WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
                case 1: {
                    if (OverridersSearchKt.hasOverridingElement((KtNamedDeclaration)psiFn)) break;
                    toExplore.add(psiFn);
                    break;
                }
                case 2: {
                    toExplore.add(psiFn);
                    break;
                }
                case 3: {
                    toExplore.add(psiFn);
                    OverridersSearchKt.forEachOverridingElement$default((KtNamedDeclaration)psiFn, null, false, (Function2)new Function2<PsiElement, PsiElement, Boolean>(this, (List<KtNamedFunction>)toExplore){
                        final /* synthetic */ GraphBuilder this$0;
                        final /* synthetic */ List<KtNamedFunction> $toExplore;
                        {
                            this.this$0 = $receiver;
                            this.$toExplore = $toExplore;
                            super(2);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull PsiElement psiElement2, @NotNull PsiElement overrideFn) {
                            Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"<anonymous parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)overrideFn, (String)"overrideFn");
                            if (overrideFn instanceof KtNamedFunction && GraphBuilder.access$getRelevantFiles$p(this.this$0).contains(MyPsiUtils.Companion.getFileForElement(overrideFn))) {
                                this.$toExplore.add((KtNamedFunction)overrideFn);
                            }
                            return true;
                        }
                    }, 3, null);
                }
            }
            Iterable $this$forEach$iv = toExplore;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction fn = (KtNamedFunction)element$iv;
                boolean bl = false;
                if (fn.getFqName() == null) continue;
                FunctionNode functionNode = this.rbGraph.getOrCreateFunction(fn);
                String string = MyPsiUtils.Companion.getUrl((PsiElement)call2);
                Intrinsics.checkNotNull((Object)string);
                this.rbGraph.connect(currentNode, functionNode, string, MyPsiUtils.Companion.getFileAndLine((PsiElement)call2));
                this.exploreFunDeclaration((PsiElement)fn, functionNode);
            }
        }
    }

    public static final /* synthetic */ List access$getRelevantFiles$p(GraphBuilder $this) {
        return $this.relevantFiles;
    }

    public static final /* synthetic */ Function1 access$getIncrementFilesDone$p(GraphBuilder $this) {
        return $this.incrementFilesDone;
    }

    public static final /* synthetic */ Project access$getProject$p(GraphBuilder $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$createSubtree(GraphBuilder $this, PsiElement builder2) {
        $this.createSubtree(builder2);
    }

    public static final /* synthetic */ Function1 access$getRbFileFound$p(GraphBuilder $this) {
        return $this.rbFileFound;
    }

    public static final /* synthetic */ void access$exploreFunDeclaration(GraphBuilder $this, PsiElement currentPsiEl, FunctionNode currentNode) {
        $this.exploreFunDeclaration(currentPsiEl, currentNode);
    }

    public static final /* synthetic */ RBGraph access$getRbGraph$p(GraphBuilder $this) {
        return $this.rbGraph;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RunBlockingInspection.ExplorationLevel.values().length];
            try {
                nArray[RunBlockingInspection.ExplorationLevel.STRICT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RunBlockingInspection.ExplorationLevel.DECLARATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RunBlockingInspection.ExplorationLevel.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

