/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManagerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "dependencyManager", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "quickFixText", "", "(Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "kotlin.code-insight.inspections.shared"})
public final class AddKotlinLibraryQuickFix
implements IntentionAction,
HighPriorityAction {
    @NotNull
    private final KotlinBuildSystemDependencyManager dependencyManager;
    @NotNull
    private final ExternalLibraryDescriptor libraryDescriptor;
    @NotNull
    private final String quickFixText;

    public AddKotlinLibraryQuickFix(@NotNull KotlinBuildSystemDependencyManager dependencyManager, @NotNull ExternalLibraryDescriptor libraryDescriptor, @IntentionName @NotNull String quickFixText) {
        Intrinsics.checkNotNullParameter((Object)dependencyManager, (String)"dependencyManager");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        Intrinsics.checkNotNullParameter((Object)quickFixText, (String)"quickFixText");
        this.dependencyManager = dependencyManager;
        this.libraryDescriptor = libraryDescriptor;
        this.quickFixText = quickFixText;
    }

    @NotNull
    public String getText() {
        return this.quickFixText;
    }

    @NotNull
    public String getFamilyName() {
        return this.quickFixText;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiFile psiFile2 = file2;
        if (psiFile2 == null || (psiFile2 = GenericPsiUtils.getModule((PsiElement)psiFile2)) == null) {
            return false;
        }
        PsiFile module2 = psiFile2;
        return this.dependencyManager.isApplicable((Module)module2) && !KotlinBuildSystemDependencyManagerKt.isProjectSyncPendingOrInProgress(this.dependencyManager);
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (editor2 == null || file2 == null) {
            return;
        }
        PsiFile psiFile2 = file2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
        PsiFile psiFile3 = psiFile2;
        Module module2 = GenericPsiUtils.getModule((PsiElement)psiFile3);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        this.dependencyManager.addDependency(module3, this.libraryDescriptor);
        this.dependencyManager.startProjectSync();
        VirtualFile buildScriptFile = this.dependencyManager.getBuildScriptFile(module3);
        if (buildScriptFile != null) {
            FileEditorManager.getInstance((Project)module3.getProject()).openFile(buildScriptFile, false);
        }
    }
}

