/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.RedundantLabeledReturnOnLastExpressionInLambdaInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0019\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantLabeledReturnOnLastExpressionInLambdaInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "getProblemDescription", "", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lkotlin/Unit;)Ljava/lang/String;", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtReturnExpression;)V", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRedundantLabeledReturnOnLastExpressionInLambdaInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantLabeledReturnOnLastExpressionInLambdaInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantLabeledReturnOnLastExpressionInLambdaInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n142#2:91\n1#3:92\n*S KotlinDebug\n*F\n+ 1 RedundantLabeledReturnOnLastExpressionInLambdaInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantLabeledReturnOnLastExpressionInLambdaInspection\n*L\n42#1:91\n*E\n"})
public final class RedundantLabeledReturnOnLastExpressionInLambdaInspection
extends KotlinApplicableInspectionBase.Simple<KtReturnExpression, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtReturnExpression element3, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"inspection.redundant.labeled.return.on.last.expression.in.lambda.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.returnExpressionVisitor((Function1)((Function1)new Function1<KtReturnExpression, Unit>(this, holder, isOnTheFly){
            final /* synthetic */ RedundantLabeledReturnOnLastExpressionInLambdaInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
                super(1);
            }

            public final void invoke(@NotNull KtReturnExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RedundantLabeledReturnOnLastExpressionInLambdaInspection.access$visitTargetElement(this.this$0, it, this.$holder, this.$isOnTheFly);
            }
        }));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtReturnExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String string = element3.getLabelName();
        if (string == null) {
            return false;
        }
        String labelName2 = string;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block2 = ktBlockExpression;
        List list2 = block2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)list2), (Object)element3)) {
            return false;
        }
        String string2 = KotlinPsiUtils.getParentLambdaLabelName(block2);
        if (string2 == null) {
            return false;
        }
        String callName = string2;
        return Intrinsics.areEqual((Object)labelName2, (Object)callName);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtReturnExpression element3) {
        TextRange textRange;
        TextRange textRange2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getLabeledExpression();
        if (psiElement2 != null && (textRange2 = psiElement2.getTextRangeInParent()) != null) {
            TextRange it = textRange2;
            boolean bl = false;
            textRange = element3.getReturnKeyword().getTextRangeInParent().union(it);
        } else {
            textRange = null;
        }
        TextRange labelRange = textRange;
        return CollectionsKt.listOfNotNull(labelRange);
    }

    @Override
    public void prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtReturnExpression element3) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtReturnExpression> createQuickFix(@NotNull KtReturnExpression element3, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SmartPsiElementPointer smartPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element3));
        return new KotlinModCommandQuickFix<KtReturnExpression>((SmartPsiElementPointer<KtReturnExpression>)smartPointer){
            final /* synthetic */ SmartPsiElementPointer<KtReturnExpression> $smartPointer;
            {
                this.$smartPointer = $smartPointer;
            }

            @NotNull
            public String getFamilyName() {
                return KotlinBundle.message((String)"remove.labeled.return.from.last.expression.in.a.lambda", (Object[])new Object[0]);
            }

            @NotNull
            public String getName() {
                return this.getName(this.$smartPointer, createQuickFix.getName.1.INSTANCE);
            }

            protected void applyFix(@NotNull Project project2, @NotNull KtReturnExpression element3, @NotNull ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtExpression returnedExpression = element3.getReturnedExpression();
                if (returnedExpression == null) {
                    element3.delete();
                } else {
                    element3.replace((PsiElement)returnedExpression);
                }
            }
        };
    }

    public static final /* synthetic */ void access$visitTargetElement(RedundantLabeledReturnOnLastExpressionInLambdaInspection $this, KtReturnExpression element3, ProblemsHolder holder, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element3, holder, isOnTheFly);
    }
}

