/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.MergedDiagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/MergedDiagnostics;", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "noSuppressionDiagnostics", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "(Ljava/util/Collection;Ljava/util/Collection;Lcom/intellij/openapi/util/ModificationTracker;)V", "getDiagnostics", "()Ljava/util/Collection;", "elementsCache", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache;", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "getNoSuppressionDiagnostics", "all", "forElement", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "noSuppression", "kotlin.base.fe10.analysis"})
final class MergedDiagnostics
implements Diagnostics {
    @NotNull
    private final Collection<Diagnostic> diagnostics;
    @NotNull
    private final Collection<Diagnostic> noSuppressionDiagnostics;
    @NotNull
    private final ModificationTracker modificationTracker;
    @NotNull
    private final DiagnosticsElementsCache elementsCache;

    public MergedDiagnostics(@NotNull Collection<? extends Diagnostic> diagnostics2, @NotNull Collection<? extends Diagnostic> noSuppressionDiagnostics, @NotNull ModificationTracker modificationTracker) {
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        Intrinsics.checkNotNullParameter(noSuppressionDiagnostics, (String)"noSuppressionDiagnostics");
        Intrinsics.checkNotNullParameter((Object)modificationTracker, (String)"modificationTracker");
        this.diagnostics = diagnostics2;
        this.noSuppressionDiagnostics = noSuppressionDiagnostics;
        this.modificationTracker = modificationTracker;
        this.elementsCache = new DiagnosticsElementsCache((Diagnostics)this, (Function1)elementsCache.1.INSTANCE);
    }

    @NotNull
    public final Collection<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final Collection<Diagnostic> getNoSuppressionDiagnostics() {
        return this.noSuppressionDiagnostics;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @NotNull
    public Collection<Diagnostic> all() {
        return this.diagnostics;
    }

    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        Collection collection = this.elementsCache.getDiagnostics(psiElement2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDiagnostics(...)");
        return collection;
    }

    @NotNull
    public MergedDiagnostics noSuppression() {
        return this.noSuppressionDiagnostics.isEmpty() ? this : new MergedDiagnostics(this.noSuppressionDiagnostics, CollectionsKt.emptyList(), this.getModificationTracker());
    }
}

