/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.utils.fqname;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u0018B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/utils/fqname/ImportableFqNameClassifier;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isImportedByDefault", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;)V", "allUnderImports", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "excludedImports", "preciseImportPackages", "preciseImports", "classify", "Lorg/jetbrains/kotlin/idea/base/utils/fqname/ImportableFqNameClassifier$Classification;", "fqName", "isPackage", "hasPreciseImportFromPackage", "packageName", "isImportedWithAllUnderImport", "name", "isImportedWithPreciseImport", "Classification", "kotlin.fir.frontend-independent"})
public final class ImportableFqNameClassifier {
    @NotNull
    private final KtFile file;
    @NotNull
    private final Function1<FqName, Boolean> isImportedByDefault;
    @NotNull
    private final HashSet<FqName> preciseImports;
    @NotNull
    private final HashSet<FqName> preciseImportPackages;
    @NotNull
    private final HashSet<FqName> allUnderImports;
    @NotNull
    private final HashSet<FqName> excludedImports;

    public ImportableFqNameClassifier(@NotNull KtFile file2, @NotNull Function1<? super FqName, Boolean> isImportedByDefault2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(isImportedByDefault2, (String)"isImportedByDefault");
        this.file = file2;
        this.isImportedByDefault = isImportedByDefault2;
        this.preciseImports = new HashSet();
        this.preciseImportPackages = new HashSet();
        this.allUnderImports = new HashSet();
        this.excludedImports = new HashSet();
        for (KtImportDirective ktImportDirective : this.file.getImportDirectives()) {
            ImportPath importPath;
            if (ktImportDirective.getImportPath() == null) continue;
            FqName fqName2 = importPath.getFqName();
            if (importPath.isAllUnder()) {
                this.allUnderImports.add(fqName2);
                continue;
            }
            if (!importPath.hasAlias()) {
                this.preciseImports.add(fqName2);
                this.preciseImportPackages.add(fqName2.parent());
                continue;
            }
            this.excludedImports.add(fqName2);
        }
    }

    @NotNull
    public final Classification classify(@NotNull FqName fqName2, boolean isPackage) {
        Classification classification;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (isPackage) {
            return this.isImportedWithPreciseImport(fqName2) ? Classification.preciseImport : (fqName2.parent().isRoot() ? Classification.topLevelPackage : Classification.notImported);
        }
        if (FqNameUtilsKt.isJavaClassNotToBeUsedInKotlin(fqName2)) {
            classification = Classification.notToBeUsedInKotlin;
        } else if (Intrinsics.areEqual((Object)fqName2.parent(), (Object)this.file.getPackageFqName())) {
            classification = Classification.fromCurrentPackage;
        } else if (((Boolean)this.isImportedByDefault.invoke((Object)fqName2)).booleanValue()) {
            classification = Classification.defaultImport;
        } else if (this.isImportedWithPreciseImport(fqName2)) {
            classification = Classification.preciseImport;
        } else if (this.isImportedWithAllUnderImport(fqName2)) {
            classification = Classification.allUnderImport;
        } else {
            FqName fqName3 = fqName2.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"parent(...)");
            classification = this.hasPreciseImportFromPackage(fqName3) ? Classification.siblingImported : Classification.notImported;
        }
        return classification;
    }

    private final boolean isImportedWithPreciseImport(FqName name2) {
        return this.preciseImports.contains(name2);
    }

    private final boolean isImportedWithAllUnderImport(FqName name2) {
        return this.allUnderImports.contains(name2.parent()) && !this.excludedImports.contains(name2);
    }

    private final boolean hasPreciseImportFromPackage(FqName packageName) {
        return this.preciseImportPackages.contains(packageName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/utils/fqname/ImportableFqNameClassifier$Classification;", "", "(Ljava/lang/String;I)V", "fromCurrentPackage", "topLevelPackage", "preciseImport", "defaultImport", "allUnderImport", "siblingImported", "notImported", "notToBeUsedInKotlin", "kotlin.fir.frontend-independent"})
    public static final class Classification
    extends Enum<Classification> {
        public static final /* enum */ Classification fromCurrentPackage = new Classification();
        public static final /* enum */ Classification topLevelPackage = new Classification();
        public static final /* enum */ Classification preciseImport = new Classification();
        public static final /* enum */ Classification defaultImport = new Classification();
        public static final /* enum */ Classification allUnderImport = new Classification();
        public static final /* enum */ Classification siblingImported = new Classification();
        public static final /* enum */ Classification notImported = new Classification();
        public static final /* enum */ Classification notToBeUsedInKotlin = new Classification();
        private static final /* synthetic */ Classification[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Classification[] values() {
            return (Classification[])$VALUES.clone();
        }

        public static Classification valueOf(String value2) {
            return Enum.valueOf(Classification.class, value2);
        }

        @NotNull
        public static EnumEntries<Classification> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = classificationArray = new Classification[]{Classification.fromCurrentPackage, Classification.topLevelPackage, Classification.preciseImport, Classification.defaultImport, Classification.allUnderImport, Classification.siblingImported, Classification.notImported, Classification.notToBeUsedInKotlin};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

