/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.SdkInfoBase;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkScope;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010(H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010*H\u0016J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SdkInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/SdkInfoBase;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "component1", "component2", "copy", "dependencies", "", "dependenciesWithoutSelf", "Lkotlin/sequences/Sequence;", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.base.project-structure"})
public final class SdkInfo
implements IdeaModuleInfo,
SdkInfoBase {
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final Name name;

    public SdkInfo(@NotNull Project project2, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.project = project2;
        this.sdk = sdk2;
        Name name2 = Name.special((String)("<sdk " + this.sdk.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        this.name = name2;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.sdk.getName(), (String)"getName(...)");
        return KotlinBaseProjectStructureBundle.message("sdk.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        return (GlobalSearchScope)new SdkScope(this.getProject(), this.sdk);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public Sequence<IdeaModuleInfo> dependenciesWithoutSelf() {
        return SequencesKt.emptySequence();
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.sdk.getSdkType() instanceof KotlinSdkType ? CommonPlatforms.INSTANCE.getDefaultCommonPlatform() : JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Sdk component2() {
        return this.sdk;
    }

    @NotNull
    public final SdkInfo copy(@NotNull Project project2, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return new SdkInfo(project2, sdk2);
    }

    public static /* synthetic */ SdkInfo copy$default(SdkInfo sdkInfo, Project project2, Sdk sdk2, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = sdkInfo.project;
        }
        if ((n & 2) != 0) {
            sdk2 = sdkInfo.sdk;
        }
        return sdkInfo.copy(project2, sdk2);
    }

    @NotNull
    public String toString() {
        return "SdkInfo(project=" + this.project + ", sdk=" + this.sdk + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.sdk.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof SdkInfo)) {
            return false;
        }
        SdkInfo sdkInfo = (SdkInfo)other2;
        if (!Intrinsics.areEqual((Object)this.project, (Object)sdkInfo.project)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sdk, (Object)sdkInfo.sdk);
    }
}

