/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.idea.base.platforms.IdePlatformKindProjectStructure;
import org.jetbrains.kotlin.idea.base.platforms.KLibUtils;
import org.jetbrains.kotlin.idea.base.platforms.KotlinCommonLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmEffectiveLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinNativeLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmJsLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmWasiLibraryKind;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmJsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmWasiIdePlatformKind;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms;
import org.jetbrains.kotlin.utils.PathUtil;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ%\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00152\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getLibraryJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "jarPattern", "Ljava/util/regex/Pattern;", "([Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/regex/Pattern;)Lcom/intellij/openapi/vfs/VirtualFile;", "getLibraryJarVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "getLibraryVersionProvider", "Lkotlin/Function1;", "Companion", "kotlin.base.platforms"})
@SourceDebugExtension(value={"SMAP\nIdePlatformKindProjectStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,103:1\n1282#2,2:104\n*S KotlinDebug\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure\n*L\n55#1:104,2\n*E\n"})
public final class IdePlatformKindProjectStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Map<String, IdePlatformKind> PLATFORM_EXTENSIONS;

    public IdePlatformKindProjectStructure(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Nullable
    public final CommonCompilerArguments getCompilerArguments(@NotNull IdePlatformKind platformKind) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
        IdePlatformKind idePlatformKind = platformKind;
        if (idePlatformKind instanceof CommonIdePlatformKind) {
            commonCompilerArguments = null;
        } else if (idePlatformKind instanceof JvmIdePlatformKind) {
            commonCompilerArguments = (CommonCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings();
        } else if (idePlatformKind instanceof JsIdePlatformKind) {
            commonCompilerArguments = (CommonCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings();
        } else if (idePlatformKind instanceof WasmIdePlatformKind) {
            commonCompilerArguments = (CommonCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings();
        } else if (idePlatformKind instanceof NativeIdePlatformKind) {
            commonCompilerArguments = null;
        } else {
            throw new IllegalStateException(("Unsupported platform kind: " + platformKind).toString());
        }
        return commonCompilerArguments;
    }

    @NotNull
    public final Function1<Library, IdeKotlinVersion> getLibraryVersionProvider(@NotNull IdePlatformKind platformKind) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
        IdePlatformKind idePlatformKind = platformKind;
        if (idePlatformKind instanceof CommonIdePlatformKind) {
            function1 = (Function1)new Function1<Library, IdeKotlinVersion>(this){
                final /* synthetic */ IdePlatformKindProjectStructure this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final IdeKotlinVersion invoke(@NotNull Library library2) {
                    Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                    return IdePlatformKindProjectStructure.access$getLibraryJarVersion(this.this$0, library2, PathUtil.INSTANCE.getKOTLIN_STDLIB_COMMON_JAR_PATTERN());
                }
            };
        } else if (idePlatformKind instanceof JvmIdePlatformKind) {
            function1 = (Function1)new Function1<Library, IdeKotlinVersion>(this){
                final /* synthetic */ IdePlatformKindProjectStructure this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final IdeKotlinVersion invoke(@NotNull Library library2) {
                    Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                    return IdePlatformKindProjectStructure.access$getLibraryJarVersion(this.this$0, library2, PathUtil.KOTLIN_RUNTIME_JAR_PATTERN);
                }
            };
        } else if (idePlatformKind instanceof JsIdePlatformKind) {
            function1 = (Function1)new Function1<Library, IdeKotlinVersion>(this){
                final /* synthetic */ IdePlatformKindProjectStructure this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final IdeKotlinVersion invoke(@NotNull Library library2) {
                    Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                    return KotlinJavaScriptStdlibDetectorFacility.INSTANCE.getStdlibVersion(IdePlatformKindProjectStructure.access$getProject$p(this.this$0), library2);
                }
            };
        } else if (idePlatformKind instanceof WasmIdePlatformKind ? true : idePlatformKind instanceof NativeIdePlatformKind) {
            function1 = getLibraryVersionProvider.4.INSTANCE;
        } else {
            throw new IllegalStateException(("Unsupported platform kind: " + platformKind).toString());
        }
        return function1;
    }

    private final VirtualFile getLibraryJar(VirtualFile[] roots2, Pattern jarPattern) {
        VirtualFile virtualFile2;
        block1: {
            VirtualFile[] $this$firstOrNull$iv = roots2;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$firstOrNull$iv[j];
                boolean bl = false;
                if (!jarPattern.matcher(it.getName()).matches()) continue;
                virtualFile2 = element$iv;
                break block1;
            }
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    private final IdeKotlinVersion getLibraryJarVersion(Library library2, Pattern jarPattern) {
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile virtualFile2 = this.getLibraryJar(virtualFileArray, jarPattern);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile libraryJar = virtualFile2;
        return IdeKotlinVersion.Companion.fromManifest(libraryJar);
    }

    @JvmStatic
    @NotNull
    public static final IdePlatformKindProjectStructure getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    public static final /* synthetic */ IdeKotlinVersion access$getLibraryJarVersion(IdePlatformKindProjectStructure $this, Library library2, Pattern jarPattern) {
        return $this.getLibraryJarVersion(library2, jarPattern);
    }

    public static final /* synthetic */ Project access$getProject$p(IdePlatformKindProjectStructure $this) {
        return $this.project;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin_metadata", (Object)CommonIdePlatformKind.INSTANCE), TuplesKt.to((Object)"js", (Object)JsIdePlatformKind.INSTANCE), TuplesKt.to((Object)"kjsm", (Object)JsIdePlatformKind.INSTANCE)};
        PLATFORM_EXTENSIONS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure$Companion;", "", "()V", "PLATFORM_EXTENSIONS", "", "", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getInstance", "Lorg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure;", "project", "Lcom/intellij/openapi/project/Project;", "getLibraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "platformKind", "getLibraryPlatformKind", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.base.platforms"})
    @SourceDebugExtension(value={"SMAP\nIdePlatformKindProjectStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n31#2,2:104\n1#3:106\n*S KotlinDebug\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure$Companion\n*L\n65#1:104,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdePlatformKindProjectStructure getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<IdePlatformKindProjectStructure> serviceClass$iv = IdePlatformKindProjectStructure.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (IdePlatformKindProjectStructure)object;
        }

        @Nullable
        public final IdePlatformKind getLibraryPlatformKind(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            IdePlatformKind idePlatformKind = (IdePlatformKind)PLATFORM_EXTENSIONS.get(file2.getExtension());
            if (idePlatformKind != null) {
                IdePlatformKind it = idePlatformKind;
                boolean bl = false;
                return it;
            }
            if (!KLibUtils.isKLibRootCandidate(file2)) {
                return null;
            }
            return KLibUtils.isKlibLibraryRootForPlatform(file2, CommonPlatforms.INSTANCE.getDefaultCommonPlatform()) ? (IdePlatformKind)CommonIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file2, JsPlatforms.INSTANCE.getDefaultJsPlatform()) ? (IdePlatformKind)JsIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file2, WasmPlatforms.INSTANCE.getWasmWasi()) ? (IdePlatformKind)WasmWasiIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file2, WasmPlatforms.INSTANCE.getWasmJs()) ? (IdePlatformKind)WasmJsIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file2, WasmPlatforms.INSTANCE.getUnspecifiedWasmPlatform()) ? (IdePlatformKind)WasmJsIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file2, NativePlatforms.INSTANCE.getUnspecifiedNativePlatform()) ? (IdePlatformKind)NativeIdePlatformKind.INSTANCE : null)))));
        }

        @NotNull
        public final PersistentLibraryKind<?> getLibraryKind(@NotNull IdePlatformKind platformKind) {
            PersistentLibraryKind persistentLibraryKind;
            Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
            IdePlatformKind idePlatformKind = platformKind;
            if (idePlatformKind instanceof CommonIdePlatformKind) {
                persistentLibraryKind = KotlinCommonLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof JvmIdePlatformKind) {
                persistentLibraryKind = KotlinJvmEffectiveLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof JsIdePlatformKind) {
                persistentLibraryKind = KotlinJavaScriptLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof WasmJsIdePlatformKind) {
                persistentLibraryKind = KotlinWasmJsLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof WasmWasiIdePlatformKind) {
                persistentLibraryKind = KotlinWasmWasiLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof NativeIdePlatformKind) {
                persistentLibraryKind = KotlinNativeLibraryKind.INSTANCE;
            } else {
                throw new IllegalStateException(("Unsupported platform kind: " + platformKind).toString());
            }
            return persistentLibraryKind;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

