/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.ManyLambdaExpressionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameForAmbiguousParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ForbiddenNamedArgumentsTarget;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001:\u0001IB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001402J\u0018\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u000bH\u0002J\u0018\u00106\u001a\u0002002\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u0002002\u0006\u00104\u001a\u000208H\u0002J\u000e\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\u0014J\u0014\u0010;\u001a\u0002002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001402J\u0006\u0010=\u001a\u000200J\b\u0010>\u001a\u000200H\u0002J\u0010\u0010?\u001a\u0002002\u0006\u00104\u001a\u00020\u0014H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00182\u0006\u0010A\u001a\u00020\u0017H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010\u00182\u0006\u00104\u001a\u000208H\u0002J\u0010\u0010C\u001a\u0002002\u0006\u0010D\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR.\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u00132\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R-\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020%0$j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020%`&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\u0004\u0018\u00010*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b+\u0010,R\u0018\u0010E\u001a\u00020\u000b*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\u0018028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\"\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor;", "", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "isIndexedSetOperator", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Z)V", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "currentPositionedParameterIndex", "", "varargArguments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "namedDynamicArgumentsNamesImpl", "", "namedDynamicArgumentsNames", "getNamedDynamicArgumentsNames", "()Ljava/util/Set;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "result", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "forbiddenNamedArgumentsTarget", "Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "getForbiddenNamedArgumentsTarget", "()Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget$delegate", "Lkotlin/Lazy;", "processNonLambdaArguments", "", "arguments", "", "processNonLambdaArgument", "argument", "isLastArgument", "processPositionArgument", "processNamedArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "processExternalArgument", "externalArgument", "processExcessLambdaArguments", "excessLambdaArguments", "processDefaultsAndRunChecks", "completeVarargPositionArguments", "addVarargArgument", "getParameterByName", "name", "findParameterByName", "addDiagnostic", "diagnostic", "isSpread", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "parameters", "getParameters", "State", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,437:1\n1#2:438\n1863#3,2:439\n1261#3,4:452\n346#3,8:456\n1261#3,4:464\n360#3,7:468\n81#4,7:441\n76#4,2:448\n57#4:450\n78#4:451\n*S KotlinDebug\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor\n*L\n271#1:439,2\n346#1:452,4\n409#1:456,8\n336#1:464,4\n382#1:468,7\n278#1:441,7\n278#1:448,2\n278#1:450\n278#1:451\n*E\n"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final FirFunction function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    private final boolean isIndexedSetOperator;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<FirExpression> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private Set<Name> namedDynamicArgumentsNamesImpl;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> result;
    @NotNull
    private final Lazy forbiddenNamedArgumentsTarget$delegate;

    public FirCallArgumentsProcessor(@NotNull FirSession useSiteSession, @NotNull FirFunction function2, @NotNull BodyResolveComponents bodyResolveComponents2, @Nullable FirScope originScope, boolean isIndexedSetOperator) {
        Intrinsics.checkNotNullParameter((Object)((Object)useSiteSession), (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents2, (String)"bodyResolveComponents");
        this.useSiteSession = useSiteSession;
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents2;
        this.originScope = originScope;
        this.isIndexedSetOperator = isIndexedSetOperator;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
        this.forbiddenNamedArgumentsTarget$delegate = LazyKt.lazy(() -> FirCallArgumentsProcessor.forbiddenNamedArgumentsTarget_delegate$lambda$1(this));
    }

    private final Set<Name> getNamedDynamicArgumentsNames() {
        Set set = this.namedDynamicArgumentsNamesImpl;
        if (set == null) {
            Set set2;
            Set it = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            this.namedDynamicArgumentsNamesImpl = it;
            set = set2;
        }
        return set;
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getResult() {
        return this.result;
    }

    @Nullable
    public final ForbiddenNamedArgumentsTarget getForbiddenNamedArgumentsTarget() {
        Lazy lazy = this.forbiddenNamedArgumentsTarget$delegate;
        return (ForbiddenNamedArgumentsTarget)lazy.getValue();
    }

    public final void processNonLambdaArguments(@NotNull List<? extends FirExpression> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Iterator iterator2 = ((Iterable)arguments2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int argumentIndex = n++;
            FirExpression argument2 = (FirExpression)iterator2.next();
            this.processNonLambdaArgument(argument2, argumentIndex == CollectionsKt.getLastIndex(arguments2));
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final void processNonLambdaArgument(FirExpression argument2, boolean isLastArgument) {
        if (!(argument2 instanceof FirNamedArgumentExpression)) {
            if (this.state == State.VARARG_POSITION && this.isIndexedSetOperator && isLastArgument) {
                this.completeVarargPositionArguments();
            }
            this.processPositionArgument(argument2, isLastArgument);
        } else if (Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            this.processPositionArgument(((FirNamedArgumentExpression)argument2).getExpression(), isLastArgument);
            if (!this.getNamedDynamicArgumentsNames().add(((FirNamedArgumentExpression)argument2).getName())) {
                this.addDiagnostic(new ArgumentPassedTwice((FirNamedArgumentExpression)argument2));
            }
        } else {
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument((FirNamedArgumentExpression)argument2);
        }
    }

    private final void processPositionArgument(FirExpression argument2, boolean isLastArgument) {
        int n;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument2));
            return;
        }
        if (this.isIndexedSetOperator) {
            int lastParameterIndex = CollectionsKt.getLastIndex(this.getParameters());
            n = isLastArgument ? lastParameterIndex : (this.currentPositionedParameterIndex >= lastParameterIndex ? -1 : this.currentPositionedParameterIndex);
        } else {
            n = this.currentPositionedParameterIndex;
        }
        int assignedParameterIndex = n;
        FirValueParameter parameter = (FirValueParameter)CollectionsKt.getOrNull(this.getParameters(), (int)assignedParameterIndex);
        if (parameter == null) {
            this.addDiagnostic(new TooManyArguments(argument2, this.function));
            return;
        }
        if (!parameter.isVararg()) {
            int n2 = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n2 + 1;
            ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument(argument2));
            this.state = State.POSITION_ARGUMENTS;
        } else {
            this.addVarargArgument(argument2);
            this.state = State.VARARG_POSITION;
        }
    }

    private final void processNamedArgument(FirNamedArgumentExpression argument2) {
        ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget = this.getForbiddenNamedArgumentsTarget();
        if (forbiddenNamedArgumentsTarget != null) {
            ForbiddenNamedArgumentsTarget it = forbiddenNamedArgumentsTarget;
            boolean bl = false;
            this.addDiagnostic(new NamedArgumentNotAllowed(argument2, this.function, it));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        FirValueParameter firValueParameter = this.findParameterByName(argument2);
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter parameter = firValueParameter;
        ResolvedCallArgument resolvedCallArgument = this.result.get(parameter);
        if (resolvedCallArgument != null) {
            ResolvedCallArgument it = resolvedCallArgument;
            boolean bl = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument2));
            return;
        }
        ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument(argument2));
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex), (Object)parameter)) {
            this.state = State.POSITION_ARGUMENTS;
            int n = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull FirExpression externalArgument) {
        Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
        FirValueParameter lastParameter = (FirValueParameter)CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        if (!Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            if (lastParameter.isVararg()) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
                return;
            }
            ResolvedCallArgument previousOccurrence = this.result.get(lastParameter);
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
                return;
            }
            ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument(externalArgument));
        } else {
            ResolvedCallArgument existing = this.result.get(lastParameter);
            if (existing == null) {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument(externalArgument));
            } else {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.plus((Collection)existing.getArguments(), (Object)externalArgument)));
            }
        }
    }

    public final void processExcessLambdaArguments(@NotNull List<? extends FirExpression> excessLambdaArguments) {
        Intrinsics.checkNotNullParameter(excessLambdaArguments, (String)"excessLambdaArguments");
        Iterable $this$forEach$iv = excessLambdaArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirExpression arg = (FirExpression)element$iv;
            boolean bl = false;
            this.addDiagnostic(new ManyLambdaExpressionArguments(arg));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processDefaultsAndRunChecks() {
        for (Map.Entry entry : ((Map)this.result).entrySet()) {
            FirValueParameter parameter = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            if (parameter.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Incorrect resolved argument for parameter " + parameter.getClass() + ": " + resolvedArgument.getClass();
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = (KotlinExceptionWithAttachments)exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$processDefaultsAndRunChecks_u24lambda_u246 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$processDefaultsAndRunChecks_u24lambda_u246, "parameter", parameter);
                $this$processDefaultsAndRunChecks_u24lambda_u246.withEntryGroup("arguments", arg_0 -> FirCallArgumentsProcessor.processDefaultsAndRunChecks$lambda$6$lambda$5(resolvedArgument, arg_0));
                kotlinExceptionWithAttachments.withAttachment(string, (Object)exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            if (!this.isSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument())) continue;
            this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
        }
        Iterator iterator2 = ((Iterable)this.getParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            FirValueParameter parameter = (FirValueParameter)((Object)iterator2.next());
            if (this.result.containsKey(parameter)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(this.useSiteSession, this.bodyResolveComponents.getScopeSession(), this.function, this.originScope, index)) {
                ((Map)this.result).put(parameter, ResolvedCallArgument.DefaultArgument.INSTANCE);
                continue;
            }
            if (parameter.isVararg()) {
                ((Map)this.result).put(parameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl;
        boolean bl2 = bl = this.state == State.VARARG_POSITION;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Incorrect state: " + (Object)((Object)this.state);
            throw new AssertionError((Object)string);
        }
        FirValueParameter parameter = this.getParameters().get(this.currentPositionedParameterIndex);
        Map map2 = this.result;
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        map2.put(parameter, new ResolvedCallArgument.VarargArgument(list2));
    }

    private final void addVarargArgument(FirExpression argument2) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        list2.add(argument2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name2) {
        if (this.nameToParameter == null) {
            if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden(this.function) && this.getForbiddenNamedArgumentsTarget() == null) {
                FirNamedFunctionSymbol symbol2;
                FirFunctionSymbol<FirFunction> firFunctionSymbol = this.function.getSymbol();
                FirNamedFunctionSymbol firNamedFunctionSymbol = symbol2 = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                if (symbol2 != null) {
                    FirScope firScope = this.originScope;
                    FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                    if (firTypeScope != null) {
                        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.getParameterByName$lambda$9(this, arg_0)));
                    }
                }
                if (this.nameToParameter == null) {
                    this.nameToParameter = MapsKt.emptyMap();
                }
            } else {
                void $this$associateTo$iv;
                Iterable symbol2 = this.getParameters();
                Map map2 = new LinkedHashMap();
                FirCallArgumentsProcessor firCallArgumentsProcessor = this;
                boolean $i$f$associateTo = false;
                for (Object element$iv : $this$associateTo$iv) {
                    void destination$iv;
                    void var7_11 = destination$iv;
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getName(), (Object)it);
                    var7_11.put(pair.getFirst(), pair.getSecond());
                }
                firCallArgumentsProcessor.nameToParameter = map2;
            }
        }
        Map<Name, ? extends FirValueParameter> map3 = this.nameToParameter;
        Intrinsics.checkNotNull(map3);
        return map3.get(name2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter findParameterByName(FirNamedArgumentExpression argument2) {
        Ref.ObjectRef parameter;
        block9: {
            int n;
            int n2;
            Ref.IntRef matchedIndex;
            FirNamedFunctionSymbol symbol2;
            block7: {
                void $this$indexOfFirst$iv;
                block8: {
                    parameter = new Ref.ObjectRef();
                    parameter.element = this.getParameterByName(argument2.getName());
                    FirFunctionSymbol<FirFunction> firFunctionSymbol = this.function.getSymbol();
                    symbol2 = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                    matchedIndex = new Ref.IntRef();
                    matchedIndex.element = -1;
                    if (parameter.element != null) break block8;
                    if (symbol2 != null && (ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) || DeclarationUtilsKt.isJavaOrEnhancement(this.function))) {
                        Ref.ObjectRef allowedParameters = new Ref.ObjectRef();
                        FirScope firScope = this.originScope;
                        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                        if (firTypeScope != null) {
                            FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$12(matchedIndex, parameter, this, allowedParameters, argument2, arg_0)));
                        }
                    }
                    if (parameter.element != null) break block9;
                    this.addDiagnostic(new NameNotFound(argument2, this.function));
                    break block9;
                }
                if (symbol2 == null || !ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) && !DeclarationUtilsKt.isJavaOrEnhancement(this.function)) break block9;
                Map<Name, ? extends FirValueParameter> map2 = this.nameToParameter;
                Intrinsics.checkNotNull(map2);
                Iterable allowedParameters = map2.entrySet();
                Ref.IntRef intRef = matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Map.Entry it = (Map.Entry)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getKey(), (Object)argument2.getName())) {
                        n2 = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if (matchedIndex.element != -1) {
                FirScope firScope = this.originScope;
                FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                if (firTypeScope != null) {
                    FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$14(matchedIndex, argument2, this, arg_0)));
                }
            }
        }
        return (FirValueParameter)parameter.element;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list2 = this.diagnostics;
        Intrinsics.checkNotNull(list2);
        list2.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirWrappedArgumentExpression && ((FirWrappedArgumentExpression)$this$isSpread).isSpread();
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    private static final ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget_delegate$lambda$1(FirCallArgumentsProcessor this$0) {
        FirScope firScope = this$0.originScope;
        return ResolveUtilsKt.forbiddenNamedArgumentsTargetOrNull(this$0.function, firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null);
    }

    private static final Unit processDefaultsAndRunChecks$lambda$6$lambda$5(ResolvedCallArgument $resolvedArgument, ExceptionAttachmentBuilder $this$withEntryGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$withEntryGroup, (String)"$this$withEntryGroup");
        Iterator iterator2 = ((Iterable)$resolvedArgument.getArguments()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            FirExpression argument2 = (FirExpression)iterator2.next();
            FirExceptionUtilsKt.withFirEntry($this$withEntryGroup, "argument" + index, argument2);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction getParameterByName$lambda$9(FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol overrideSymbol) {
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter((Object)overrideSymbol, (String)"overrideSymbol");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)overrideSymbol.getFir())) {
            return ProcessorAction.NEXT;
        }
        Iterable iterable = CollectionsKt.withIndex((Iterable)this$0.getParameters());
        Map map2 = new LinkedHashMap();
        FirCallArgumentsProcessor firCallArgumentsProcessor = this$0;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            void destination$iv;
            void var7_8 = destination$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl = false;
            int i2 = indexedValue.component1();
            FirValueParameter p = (FirValueParameter)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)((FirSimpleFunction)overrideSymbol.getFir()).getValueParameters().get(i2).getName(), (Object)p);
            var7_8.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        firCallArgumentsProcessor.nameToParameter = map2;
        return ProcessorAction.STOP;
    }

    private static final ProcessorAction findParameterByName$findAndReportValueParameterWithDifferentName(List<FirValueParameterSymbol> $this$findParameterByName_u24findAndReportValueParameterWithDifferentName, Ref.IntRef matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0) {
        Name someName;
        FirValueParameter someParameter;
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.getOrNull($this$findParameterByName_u24findAndReportValueParameterWithDifferentName, (int)matchedIndex.element);
        FirValueParameter firValueParameter = someParameter = firValueParameterSymbol != null ? (FirValueParameter)firValueParameterSymbol.getFir() : null;
        Object object = someName = firValueParameter != null ? firValueParameter.getName() : null;
        if (someName != null && !Intrinsics.areEqual((Object)someName, (Object)$argument.getName())) {
            this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction findParameterByName$lambda$12(Ref.IntRef $matchedIndex, Ref.ObjectRef $parameter, FirCallArgumentsProcessor this$0, Ref.ObjectRef $allowedParameters, FirNamedArgumentExpression $argument, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        List<FirValueParameterSymbol> someParameterSymbols = it.getValueParameterSymbols();
        if ($matchedIndex.element != -1) {
            processorAction = FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(someParameterSymbols, $matchedIndex, $argument, this$0);
        } else {
            int n;
            int n2;
            block9: {
                void $this$indexOfFirst$iv;
                List<FirValueParameterSymbol> list2 = someParameterSymbols;
                Ref.IntRef intRef = $matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FirValueParameterSymbol originalParameter = (FirValueParameterSymbol)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)originalParameter.getName(), (Object)$argument.getName())) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if ($matchedIndex.element != -1) {
                FirValueParameter someParameter;
                $parameter.element = this$0.getParameters().get($matchedIndex.element);
                Object object = (List)$allowedParameters.element;
                FirValueParameter firValueParameter = object != null && (object = (FirValueParameterSymbol)CollectionsKt.getOrNull((List)object, (int)$matchedIndex.element)) != null ? (FirValueParameter)((FirBasedSymbol)object).getFir() : (someParameter = null);
                if (someParameter != null) {
                    this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
            } else {
                $allowedParameters.element = someParameterSymbols;
                processorAction = ProcessorAction.NEXT;
            }
        }
        return processorAction;
    }

    private static final ProcessorAction findParameterByName$lambda$14(Ref.IntRef $matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        return FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(it.getValueParameterSymbols(), $matchedIndex, $argument, this$0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "", "<init>", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

