/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.jvm.FirJvmNamesChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInvalidAndDangerousCharactersChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmInvalidAndDangerousCharactersChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmInvalidAndDangerousCharactersChecker INSTANCE = new FirJvmInvalidAndDangerousCharactersChecker();

    private FirJvmInvalidAndDangerousCharactersChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement source = declaration2.getSource();
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirRegularClass)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirSimpleFunction)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeParameter) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirTypeParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirProperty) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirProperty)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeAlias) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirTypeAlias)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirValueParameter) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirValueParameter)declaration2).getName(), source, context2, reporter);
        } else {
            return;
        }
    }
}

