/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirWhenGuardChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "checkPsiOrLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkBranch", "branch", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenBranch;", "checkers"})
public final class FirWhenGuardChecker
extends FirExpressionSyntaxChecker<FirWhenExpression, PsiElement> {
    @NotNull
    public static final FirWhenGuardChecker INSTANCE = new FirWhenGuardChecker();

    private FirWhenGuardChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirWhenExpression element3, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirWhenBranch branch2 : element3.getBranches()) {
            this.checkBranch(element3, branch2, context2, reporter);
        }
    }

    private final void checkBranch(FirWhenExpression element3, FirWhenBranch branch2, CheckerContext context2, DiagnosticReporter reporter) {
        if (!branch2.getHasGuard()) {
            return;
        }
        KtSourceElement ktSourceElement = branch2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.WhenGuards)) {
            KtDiagnosticReportHelpersKt.reportOn((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.WhenGuards, (Object)FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession())), (DiagnosticContext)context2, (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getWHEN_GUARD()));
        }
        if (element3.getSubject() == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getWHEN_GUARD_WITHOUT_SUBJECT(), (DiagnosticContext)context2, null, (int)8, null);
        } else {
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COMMA");
            if (FirSourceUtilsKt.getChild$default(source, (IElementType)ktSingleValueToken, 0, 1, false, 10, null) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getCOMMA_IN_WHEN_CONDITION_WITH_WHEN_GUARD(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
    }
}

