/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.EnumValueArgumentInfo;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.SymbolInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001EB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ$\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ*\u0010\u000b\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018J.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\"\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0007\u001a\u00020\bJV\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JN\u0010'\u001a\u00020\f*\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002J<\u0010+\u001a\u00020\f*\u00020,2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002J4\u0010-\u001a\u00020\f*\u0004\u0018\u00010\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&H\u0002J\"\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020.2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J8\u0010/\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u00102\u001a\u0002032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\n\b\u0002\u00106\u001a\u0004\u0018\u000107J2\u00108\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0007J \u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010<\u001a\u00020\u0012*\u00020=2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010>\u001a\u00020\u0012*\u00020=H\u0002J\u001c\u0010?\u001a\u00020\u0012*\u00020=2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010:\u001a\u00020;H\u0002J\u001c\u0010@\u001a\u00020\u0012*\u00020=2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010A\u001a\u00020\u0012*\u00020=2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010:\u001a\u00020;H\u0002R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker;", "", "<init>", "()V", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "annotatedOwnerClassName", "", "loadExperimentalitiesFromAnnotationTo", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "result", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "fromSupertype", "", "loadExperimentalitiesFromTypeArguments", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "loadExperimentalitiesFromConeArguments", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "loadExperimentalities", "fromSetter", "dispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "loadExperimentalitiesFromSupertype", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isExperimentalMarker", "knownExperimentalities", "Lorg/jetbrains/kotlin/utils/SmartSet;", "visited", "", "loadCallableSpecificExperimentalities", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "loadClassLikeSpecificExperimentalities", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "addExperimentalities", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "reportNotAcceptedExperimentalities", "experimentalities", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reportNotAcceptedOverrideExperimentalities", "isExperimentalityAcceptableInContext", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isExperimentalityAcceptable", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "isImplicitDeclaration", "primaryConstructorParameterIsExperimentalityAcceptable", "isAnnotatedWithOptIn", "isAnnotatedWithSubclassOptInRequired", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "Experimentality", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageBaseChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageBaseChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n26#2:421\n26#2:430\n1557#3:422\n1628#3,3:423\n1863#3,2:426\n1863#3,2:428\n1863#3,2:432\n808#3,11:435\n295#3,2:446\n295#3,2:450\n1755#3,3:453\n24#4:431\n57#4:434\n13409#5,2:448\n1#6:452\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageBaseChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker\n*L\n97#1:421\n211#1:430\n125#1:422\n125#1:423,3\n134#1:426,2\n184#1:428,2\n218#1:432,2\n227#1:435,11\n228#1:446,2\n285#1:450,2\n393#1:453,3\n214#1:431\n223#1:434\n268#1:448,2\n*E\n"})
public final class FirOptInUsageBaseChecker {
    @NotNull
    public static final FirOptInUsageBaseChecker INSTANCE = new FirOptInUsageBaseChecker();
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;

    private FirOptInUsageBaseChecker() {
    }

    @Nullable
    public final Experimentality loadExperimentalityForMarkerAnnotation(@NotNull FirRegularClassSymbol $this$loadExperimentalityForMarkerAnnotation, @NotNull FirSession session, @Nullable String annotatedOwnerClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$loadExperimentalityForMarkerAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalityForMarkerAnnotation, FirResolvePhase.BODY_RESOLVE);
        return this.loadExperimentalityForMarkerAnnotation((FirRegularClass)$this$loadExperimentalityForMarkerAnnotation.getFir(), session, annotatedOwnerClassName);
    }

    public static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClassSymbol firRegularClassSymbol, FirSession firSession, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClassSymbol, firSession, string);
    }

    public final void loadExperimentalitiesFromAnnotationTo(@NotNull FirBasedSymbol<?> $this$loadExperimentalitiesFromAnnotationTo, @NotNull FirSession session, @NotNull Collection<Experimentality> result2) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromAnnotationTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalitiesFromAnnotationTo, FirResolvePhase.STATUS);
        this.loadExperimentalitiesFromAnnotationTo((FirDeclaration)$this$loadExperimentalitiesFromAnnotationTo.getFir(), session, result2, false);
    }

    private final void loadExperimentalitiesFromAnnotationTo(FirDeclaration $this$loadExperimentalitiesFromAnnotationTo, FirSession session, Collection<Experimentality> result2, boolean fromSupertype) {
        for (FirAnnotation annotation : $this$loadExperimentalitiesFromAnnotationTo.getAnnotations()) {
            Experimentality experimentality;
            FirExpression annotationClass;
            ConeClassLikeType annotationType;
            FqName fqName2;
            Object $this$coneTypeSafe$iv = annotation.getAnnotationTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
            $this$coneTypeSafe$iv = $this$loadExperimentalitiesFromAnnotationTo;
            String className = $this$coneTypeSafe$iv instanceof FirRegularClass ? ((FirRegularClass)$this$loadExperimentalitiesFromAnnotationTo).getName().asString() : ($this$coneTypeSafe$iv instanceof FirCallableDeclaration ? ((fqName2 = ((FirCallableDeclaration)$this$loadExperimentalitiesFromAnnotationTo).getSymbol().getCallableId().getClassName()) != null && (fqName2 = fqName2.shortName()) != null ? fqName2.asString() : null) : null);
            $this$coneTypeSafe$iv = LookupTagUtilsKt.toFirRegularClassSymbol(annotationType.getLookupTag(), session);
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, $this$coneTypeSafe$iv != null ? this.loadExperimentalityForMarkerAnnotation((FirRegularClassSymbol)$this$coneTypeSafe$iv, session, className) : null);
            if (!fromSupertype || !Intrinsics.areEqual((Object)annotationType.getLookupTag().getClassId(), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirAnnotationHelpersKt.extractClassFromArgument(annotationClass, session);
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, firRegularClassSymbol != null && (experimentality = FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default(this, firRegularClassSymbol, session, null, 2, null)) != null ? Experimentality.copy$default(experimentality, null, null, null, null, true, 15, null) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromTypeArguments(@NotNull CheckerContext context2, @NotNull List<? extends FirTypeProjection> typeArguments2) {
        Collection<ConeTypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        if (typeArguments2.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = typeArguments2;
        CheckerContext checkerContext = context2;
        FirOptInUsageBaseChecker firOptInUsageBaseChecker = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it));
        }
        collection = (List)destination$iv$iv;
        return firOptInUsageBaseChecker.loadExperimentalitiesFromConeArguments(checkerContext, (List<? extends ConeTypeProjection>)collection);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromConeArguments(@NotNull CheckerContext context2, @NotNull List<? extends ConeTypeProjection> typeArguments2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        if (typeArguments2.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartSet result2 = SmartSet.Companion.create();
        Iterable $this$forEach$iv = typeArguments2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeTypeProjection it = (ConeTypeProjection)element$iv;
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it)) continue;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
            if (coneKotlinType == null) continue;
            FirOptInUsageBaseChecker.addExperimentalities$default(INSTANCE, coneKotlinType, context2, result2, null, 4, null);
        }
        return (Set)result2;
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalities(@NotNull FirBasedSymbol<?> $this$loadExperimentalities, @NotNull CheckerContext context2, boolean fromSetter, @Nullable ConeKotlinType dispatchReceiverType) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalities, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.loadExperimentalities($this$loadExperimentalities, context2, null, new LinkedHashSet(), fromSetter, dispatchReceiverType, false);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromSupertype(@NotNull FirClassLikeSymbol<?> $this$loadExperimentalitiesFromSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromSupertype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.loadExperimentalities((FirBasedSymbol)$this$loadExperimentalitiesFromSupertype, context2, null, new LinkedHashSet(), false, null, true);
    }

    public final boolean isExperimentalMarker(@NotNull FirClassLikeSymbol<?> $this$isExperimentalMarker, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isExperimentalMarker, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        return $this$isExperimentalMarker instanceof FirRegularClassSymbol && FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$isExperimentalMarker, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session) != null;
    }

    private final Set<Experimentality> loadExperimentalities(FirBasedSymbol<?> $this$loadExperimentalities, CheckerContext context2, SmartSet<Experimentality> knownExperimentalities, Set<FirDeclaration> visited, boolean fromSetter, ConeKotlinType dispatchReceiverType, boolean fromSupertype) {
        FirSinceKotlinAccessibility accessibility;
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalities, FirResolvePhase.STATUS);
        Object fir = $this$loadExperimentalities.getFir();
        if (!visited.add((FirDeclaration)fir)) {
            return SetsKt.emptySet();
        }
        SmartSet smartSet = knownExperimentalities;
        if (smartSet == null) {
            smartSet = SmartSet.Companion.create();
        }
        SmartSet result2 = smartSet;
        FirSession session = context2.getSession();
        Object obj = fir;
        if (obj instanceof FirCallableDeclaration) {
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)fir;
            Intrinsics.checkNotNull($this$loadExperimentalities, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            this.loadCallableSpecificExperimentalities(firCallableDeclaration, (FirCallableSymbol)$this$loadExperimentalities, context2, visited, fromSetter, dispatchReceiverType, (SmartSet<Experimentality>)result2);
        } else if (obj instanceof FirClassLikeDeclaration) {
            this.loadClassLikeSpecificExperimentalities((FirClassLikeDeclaration)fir, $this$loadExperimentalities, context2, visited, (SmartSet<Experimentality>)result2);
        } else if (!(obj instanceof FirAnonymousInitializer || obj instanceof FirDanglingModifierList || obj instanceof FirFile || obj instanceof FirTypeParameter || obj instanceof FirScript || obj instanceof FirCodeFragment)) {
            throw new NoWhenBranchMatchedException();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalities, FirResolvePhase.ANNOTATION_ARGUMENTS);
        this.loadExperimentalitiesFromAnnotationTo((FirDeclaration)fir, session, (Collection)result2, fromSupertype);
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)fir, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID(), session) != null && (accessibility = FirSinceKotlinHelpersKt.checkSinceKotlinVersionAccessibility(fir, context2)) instanceof FirSinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            Iterable $this$forEach$iv = ((FirSinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)((Collection)result2), (Object)FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default(INSTANCE, (FirRegularClass)it.getFir(), session, null, 2, null));
            }
        }
        return (Set)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadCallableSpecificExperimentalities(FirCallableDeclaration $this$loadCallableSpecificExperimentalities, FirCallableSymbol<?> symbol2, CheckerContext context2, Set<FirDeclaration> visited, boolean fromSetter, ConeKotlinType dispatchReceiverType, SmartSet<Experimentality> result2) {
        block16: {
            FirRegularClassSymbol parentClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$loadCallableSpecificExperimentalities);
            FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = parentClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if ($this$loadCallableSpecificExperimentalities instanceof FirConstructor) {
                FirClassLikeSymbol ownerClassLikeSymbol;
                FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructor)$this$loadCallableSpecificExperimentalities);
                FirClassLikeSymbol firClassLikeSymbol2 = ownerClassLikeSymbol = firTypeAliasSymbol != null ? (FirClassLikeSymbol)firTypeAliasSymbol : (FirClassLikeSymbol)parentClassSymbol;
                if (firClassLikeSymbol2 != null) {
                    this.loadExperimentalities(firClassLikeSymbol2, context2, result2, visited, false, null, false);
                }
            } else {
                FirTypeRef $this$coneTypeSafe$iv = $this$loadCallableSpecificExperimentalities.getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeKotlinType)) {
                    coneKotlinType = null;
                }
                this.addExperimentalities(coneKotlinType != null ? AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(coneKotlinType) : null, context2, result2, visited);
                Object object = $this$loadCallableSpecificExperimentalities.getReceiverParameter();
                this.addExperimentalities(object != null && (object = ((FirReceiverParameter)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf((ConeKotlinType)object) : null, context2, result2, visited);
            }
            FirCallableSymbol<?> $this$isStatic$iv = symbol2;
            boolean $i$f$isStatic = false;
            if (!$this$isStatic$iv.getRawStatus().isStatic()) {
                ConeKotlinType coneKotlinType = dispatchReceiverType;
                if (coneKotlinType != null) {
                    this.addExperimentalities(coneKotlinType, context2, result2, visited);
                }
            }
            if ($this$loadCallableSpecificExperimentalities instanceof FirFunction) {
                boolean bl;
                Iterable $this$forEach$iv = ((FirFunction)$this$loadCallableSpecificExperimentalities).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    INSTANCE.addExperimentalities(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(it.getReturnTypeRef())), context2, result2, visited);
                }
                FirRegularClassSymbol firRegularClassSymbol2 = parentClassSymbol;
                if (firRegularClassSymbol2 != null) {
                    FirClassLikeSymbol $this$isData$iv = firRegularClassSymbol2;
                    boolean $i$f$isData = false;
                    bl = $this$isData$iv.getRawStatus().isData();
                } else {
                    bl = false;
                }
                if (bl && DataClassResolver.INSTANCE.isComponentLike(FirDeclarationUtilKt.getNameOrSpecialName($this$loadCallableSpecificExperimentalities)) && parentClassSymbol.getClassKind() == ClassKind.CLASS) {
                    FirPropertySymbol property2;
                    Object v14;
                    block15: {
                        void $this$filterIsInstanceTo$iv$iv;
                        List<FirValueParameterSymbol> valueParameters;
                        String string = FirDeclarationUtilKt.getNameOrSpecialName($this$loadCallableSpecificExperimentalities).getIdentifier();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                        int componentNIndex = DataClassResolver.INSTANCE.getComponentIndex(string);
                        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorSymbol(parentClassSymbol, context2.getSession());
                        List<FirValueParameterSymbol> list2 = valueParameters = firConstructorSymbol != null ? firConstructorSymbol.getValueParameterSymbols() : null;
                        FirValueParameterSymbol valueParameter = list2 != null ? (FirValueParameterSymbol)CollectionsKt.getOrNull(list2, (int)(componentNIndex - 1)) : null;
                        Iterable $this$filterIsInstance$iv = parentClassSymbol.getDeclarationSymbols();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List properties = (List)destination$iv$iv;
                        Iterable $this$firstOrNull$iv = properties;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            FirPropertySymbol it = (FirPropertySymbol)element$iv;
                            boolean bl3 = false;
                            FirValueParameterSymbol firValueParameterSymbol = valueParameter;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)(firValueParameterSymbol != null ? firValueParameterSymbol.getName() : null))) continue;
                            v14 = element$iv;
                            break block15;
                        }
                        v14 = null;
                    }
                    FirPropertySymbol firPropertySymbol = property2 = (FirPropertySymbol)v14;
                    if (firPropertySymbol != null) {
                        this.loadExperimentalities(firPropertySymbol, context2, result2, visited, false, dispatchReceiverType, false);
                    }
                }
            }
            if (!fromSetter || !(symbol2 instanceof FirPropertySymbol)) break block16;
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)symbol2).getSetterSymbol();
            if (firPropertyAccessorSymbol != null) {
                this.loadExperimentalities(firPropertyAccessorSymbol, context2, result2, visited, false, dispatchReceiverType, false);
            }
        }
    }

    private final void loadClassLikeSpecificExperimentalities(FirClassLikeDeclaration $this$loadClassLikeSpecificExperimentalities, FirBasedSymbol<?> symbol2, CheckerContext context2, Set<FirDeclaration> visited, SmartSet<Experimentality> result2) {
        FirClassLikeDeclaration firClassLikeDeclaration = $this$loadClassLikeSpecificExperimentalities;
        if (firClassLikeDeclaration instanceof FirRegularClass) {
            if (symbol2 instanceof FirRegularClassSymbol) {
                FirClassLikeSymbol<?> parentClassSymbol;
                FirClassLikeSymbol<?> firClassLikeSymbol = parentClassSymbol = FirHelpersKt.outerClassSymbol((FirClassLikeSymbol)symbol2, context2);
                if (firClassLikeSymbol != null) {
                    this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context2, result2, visited, false, null, false);
                }
            }
        } else if (!(firClassLikeDeclaration instanceof FirAnonymousObject) && !(firClassLikeDeclaration instanceof FirTypeAlias)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void addExperimentalities(ConeKotlinType $this$addExperimentalities, CheckerContext context2, SmartSet<Experimentality> result2, Set<FirDeclaration> visited) {
        if (!($this$addExperimentalities instanceof ConeClassLikeType)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)$this$addExperimentalities).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol != null) {
            this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context2, result2, visited, false, null, false);
        }
        ConeTypeProjection[] $this$forEach$iv = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$addExperimentalities, context2.getSession(), null, 2, null).getTypeArguments();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it)) continue;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
            if (coneKotlinType == null) continue;
            INSTANCE.addExperimentalities(coneKotlinType, context2, result2, visited);
        }
    }

    static /* synthetic */ void addExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, SmartSet smartSet, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firOptInUsageBaseChecker.addExperimentalities(coneKotlinType, checkerContext, (SmartSet<Experimentality>)smartSet, set);
    }

    private final Experimentality loadExperimentalityForMarkerAnnotation(FirRegularClass $this$loadExperimentalityForMarkerAnnotation, FirSession session, String annotatedOwnerClassName) {
        Experimentality.Severity severity;
        Object v2;
        FirAnnotation experimental;
        block3: {
            FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$loadExperimentalityForMarkerAnnotation, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session);
            if (firAnnotation == null) {
                return null;
            }
            experimental = firAnnotation;
            FirExpression levelArgument = FirAnnotationUtilsKt.findArgumentByName$default(experimental, LEVEL, false, 2, null);
            Object object = levelArgument;
            String levelName = object != null && (object = FirAnnotationUtilsKt.extractEnumValueArgumentInfo((FirExpression)object)) != null && (object = ((EnumValueArgumentInfo)object).getEnumEntryName()) != null ? object.asString() : null;
            Iterable $this$firstOrNull$iv = (Iterable)Experimentality.Severity.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Experimentality.Severity it = (Experimentality.Severity)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)levelName)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((severity = (Experimentality.Severity)v2) == null) {
            severity = Experimentality.Companion.getDEFAULT_SEVERITY();
        }
        Experimentality.Severity severity2 = severity;
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(experimental, MESSAGE, false, 2, null);
        FirLiteralExpression firLiteralExpression = firExpression instanceof FirLiteralExpression ? (FirLiteralExpression)firExpression : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String message2 = object instanceof String ? (String)object : null;
        return new Experimentality($this$loadExperimentalityForMarkerAnnotation.getSymbol().getClassId(), severity2, message2, annotatedOwnerClassName, false, 16, null);
    }

    static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClass firRegularClass, FirSession firSession, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClass, firSession, string);
    }

    public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirElement element3, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (Experimentality experimentality : experimentalities) {
            String string;
            KtDiagnosticFactory2 diagnostic;
            ClassId annotationClassId;
            block9: {
                String verb;
                boolean fromSupertype;
                block8: {
                    String string2;
                    Pair pair;
                    annotationClassId = experimentality.component1();
                    Experimentality.Severity severity = experimentality.component2();
                    String message2 = experimentality.component3();
                    fromSupertype = experimentality.component5();
                    if (this.isExperimentalityAcceptableInContext(annotationClassId, context2, fromSupertype)) continue;
                    switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                        case 1: {
                            pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_USAGE(), (Object)"should");
                            break;
                        }
                        case 2: {
                            pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_USAGE_ERROR(), (Object)"must");
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Pair pair2 = pair;
                    diagnostic = (KtDiagnosticFactory2)pair2.component1();
                    verb = (String)pair2.component2();
                    string = message2;
                    if (string == null) break block8;
                    String it = string2 = string;
                    boolean bl = false;
                    string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                    if (string != null) break block9;
                }
                string = OptInNames.INSTANCE.buildDefaultDiagnosticMessage(OptInNames.INSTANCE.buildMessagePrefix(verb), annotationClassId.asFqNameString(), fromSupertype);
            }
            String reportedMessage = string;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory2)diagnostic, (Object)annotationClassId, (Object)reportedMessage, (DiagnosticContext)context2, null, (int)32, null);
        }
    }

    public static /* synthetic */ void reportNotAcceptedExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, Collection collection, FirElement firElement, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktSourceElement = firElement.getSource();
        }
        firOptInUsageBaseChecker.reportNotAcceptedExperimentalities(collection, firElement, checkerContext, diagnosticReporter, ktSourceElement);
    }

    @SymbolInternals
    public final void reportNotAcceptedOverrideExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirCallableSymbol<?> symbol2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (Experimentality experimentality : experimentalities) {
            Pair pair;
            ClassId annotationClassId = experimentality.component1();
            Experimentality.Severity severity = experimentality.component2();
            String markerMessage = experimentality.component3();
            String supertypeName = experimentality.component4();
            if (this.isExperimentalityAcceptable((FirAnnotationContainer)symbol2.getFir(), context2.getSession(), annotationClassId, false) || this.isExperimentalityAcceptableInContext(annotationClassId, context2, false)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE(), (Object)"should");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE_ERROR(), (Object)"must");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            KtDiagnosticFactory2 diagnostic = (KtDiagnosticFactory2)pair2.component1();
            String verb = (String)pair2.component2();
            String string = supertypeName;
            if (string == null) {
                string = "???";
            }
            String message2 = OptInNames.INSTANCE.buildOverrideMessage(string, markerMessage, verb, annotationClassId.asFqNameString());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)symbol2.getSource()), (KtDiagnosticFactory2)diagnostic, (Object)annotationClassId, (Object)message2, (DiagnosticContext)context2, null, (int)32, null);
        }
    }

    private final boolean isExperimentalityAcceptableInContext(ClassId annotationClassId, CheckerContext context2, boolean fromSupertype) {
        LanguageVersionSettings languageVersionSettings2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        String fqNameAsString = annotationClassId.asFqNameString();
        if (((List)languageVersionSettings2.getFlag(AnalysisFlags.getOptIn())).contains(fqNameAsString)) {
            return true;
        }
        for (FirAnnotationContainer annotationContainer : context2.getAnnotationContainers()) {
            if (!this.isExperimentalityAcceptable(annotationContainer, context2.getSession(), annotationClassId, fromSupertype)) continue;
            return true;
        }
        return false;
    }

    private final boolean isExperimentalityAcceptable(FirAnnotationContainer $this$isExperimentalityAcceptable, FirSession session, ClassId annotationClassId, boolean fromSupertype) {
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$isExperimentalityAcceptable, annotationClassId, session) != null || this.isAnnotatedWithOptIn($this$isExperimentalityAcceptable, annotationClassId, session) || fromSupertype && this.isAnnotatedWithSubclassOptInRequired($this$isExperimentalityAcceptable, session, annotationClassId) || this.primaryConstructorParameterIsExperimentalityAcceptable($this$isExperimentalityAcceptable, session, annotationClassId) || this.isImplicitDeclaration($this$isExperimentalityAcceptable);
    }

    private final boolean isImplicitDeclaration(FirAnnotationContainer $this$isImplicitDeclaration) {
        return $this$isImplicitDeclaration instanceof FirDeclaration && !Intrinsics.areEqual((Object)((FirDeclaration)$this$isImplicitDeclaration).getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE);
    }

    private final boolean primaryConstructorParameterIsExperimentalityAcceptable(FirAnnotationContainer $this$primaryConstructorParameterIsExperimentalityAcceptable, FirSession session, ClassId annotationClassId) {
        if (!($this$primaryConstructorParameterIsExperimentalityAcceptable instanceof FirProperty)) {
            return false;
        }
        FirValueParameterSymbol firValueParameterSymbol = DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirProperty)$this$primaryConstructorParameterIsExperimentalityAcceptable);
        if (firValueParameterSymbol == null) {
            return false;
        }
        FirValueParameterSymbol parameterSymbol = firValueParameterSymbol;
        return this.isExperimentalityAcceptable((FirAnnotationContainer)parameterSymbol.getFir(), session, annotationClassId, false);
    }

    private final boolean isAnnotatedWithOptIn(FirAnnotationContainer $this$isAnnotatedWithOptIn, ClassId annotationClassId, FirSession session) {
        for (FirAnnotation annotation : $this$isAnnotatedWithOptIn.getAnnotations()) {
            boolean bl;
            block4: {
                FirExpression annotationClasses;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                Object object = coneType;
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses, session);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getClassId(), (Object)annotationClassId)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private final boolean isAnnotatedWithSubclassOptInRequired(FirAnnotationContainer $this$isAnnotatedWithSubclassOptInRequired, FirSession session, ClassId annotationClassId) {
        for (FirAnnotation annotation : $this$isAnnotatedWithSubclassOptInRequired.getAnnotations()) {
            FirExpression annotationClass;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
            ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            Object object = coneType;
            if (!Intrinsics.areEqual((Object)(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirAnnotationHelpersKt.extractClassFromArgument(annotationClass, session);
            if (!Intrinsics.areEqual((Object)(firRegularClassSymbol != null ? firRegularClassSymbol.getClassId() : null), (Object)annotationClassId)) continue;
            return true;
        }
        return false;
    }

    static {
        Name name2 = Name.identifier((String)"level");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        LEVEL = name2;
        Name name3 = Name.identifier((String)"message");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        MESSAGE = name3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J?\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "severity", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "message", "", "supertypeName", "fromSupertype", "", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;Ljava/lang/String;Ljava/lang/String;Z)V", "getAnnotationClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getSeverity", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getMessage", "()Ljava/lang/String;", "getSupertypeName", "getFromSupertype", "()Z", "equals", "other", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "copy", "toString", "Severity", "Companion", "checkers"})
    public static final class Experimentality {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClassId annotationClassId;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String message;
        @Nullable
        private final String supertypeName;
        private final boolean fromSupertype;
        @NotNull
        private static final Severity DEFAULT_SEVERITY = Severity.ERROR;

        public Experimentality(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            this.annotationClassId = annotationClassId;
            this.severity = severity;
            this.message = message2;
            this.supertypeName = supertypeName;
            this.fromSupertype = fromSupertype;
        }

        public /* synthetic */ Experimentality(ClassId classId, Severity severity, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(classId, severity, string, string2, bl);
        }

        @NotNull
        public final ClassId getAnnotationClassId() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getSupertypeName() {
            return this.supertypeName;
        }

        public final boolean getFromSupertype() {
            return this.fromSupertype;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Experimentality)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotationClassId, (Object)((Experimentality)other2).annotationClassId)) {
                return false;
            }
            if (this.severity != ((Experimentality)other2).severity) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)((Experimentality)other2).message);
        }

        public int hashCode() {
            int result2 = this.annotationClassId.hashCode();
            result2 = 31 * result2 + this.severity.hashCode();
            String string = this.message;
            result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
            return result2;
        }

        @NotNull
        public final ClassId component1() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @Nullable
        public final String component3() {
            return this.message;
        }

        @Nullable
        public final String component4() {
            return this.supertypeName;
        }

        public final boolean component5() {
            return this.fromSupertype;
        }

        @NotNull
        public final Experimentality copy(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new Experimentality(annotationClassId, severity, message2, supertypeName, fromSupertype);
        }

        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, ClassId classId, Severity severity, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classId = experimentality.annotationClassId;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 4) != 0) {
                string = experimentality.message;
            }
            if ((n & 8) != 0) {
                string2 = experimentality.supertypeName;
            }
            if ((n & 0x10) != 0) {
                bl = experimentality.fromSupertype;
            }
            return experimentality.copy(classId, severity, string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationClassId=" + this.annotationClassId + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", supertypeName=" + this.supertypeName + ", fromSupertype=" + this.fromSupertype + ')';
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Companion;", "", "<init>", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "", "<init>", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "checkers"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING = new Severity();
            public static final /* enum */ Severity ERROR = new Severity();
            private static final /* synthetic */ Severity[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String value2) {
                return Enum.valueOf(Severity.class, value2);
            }

            @NotNull
            public static EnumEntries<Severity> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = severityArray = new Severity[]{Severity.WARNING, Severity.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Experimentality.Severity.values().length];
            try {
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

