/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J>\u0010\u001c\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001d*\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001f2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSupertypes", "checkParameterBounds", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "visitedTypes", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,269:1\n28#2:270\n28#2:272\n28#2:273\n28#2:274\n49#2:275\n28#2:277\n28#2:278\n28#2:279\n26#3:271\n1#4:276\n45#5:280\n45#5:281\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n48#1:270\n74#1:272\n94#1:273\n113#1:274\n114#1:275\n157#1:277\n183#1:278\n210#1:279\n55#1:271\n240#1:280\n241#1:281\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirResolvedDeclarationStatus classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes) {
            Pair pair;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeClassLikeType supertype;
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE)) continue;
            FirTypeRef $this$coneTypeSafe$iv = supertypeRef;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null || TypeUtilsKt.toRegularClassSymbol(supertype, context2.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, supertype, context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
            FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
            KtSourceElement ktSourceElement2 = ((FirResolvedTypeRef)supertypeRef).getSource();
            if (ktSourceElement2 == null) {
                ktSourceElement2 = declaration2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement2), isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), (Object)classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, (int)64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirResolvedDeclarationStatus classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration2.getTypeParameters()) {
            for (FirResolvedTypeRef bound2 : parameter.getSymbol().getResolvedBounds()) {
                Pair pair;
                if (FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(bound2), context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
                FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)bound2.getSource()), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), (Object)classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, (int)64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirResolvedDeclarationStatus typeAliasVisibility;
        ConeClassLikeType expandedType = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(typeAliasVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        ConeClassLikeType coneClassLikeType = expandedType;
        if (coneClassLikeType == null || (coneClassLikeType = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, coneClassLikeType, context2, (EffectiveVisibility)typeAliasVisibility, null, 4, null)) == null) {
            return;
        }
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
        FirBasedSymbol restricting = (FirBasedSymbol)coneClassLikeType2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)coneClassLikeType2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), (Object)typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, (int)64, null);
    }

    private final void checkFunction(FirFunction declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        boolean isNonLocal;
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        FirResolvedDeclarationStatus functionVisibility = null;
        Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration2 instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration2;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl = isNonLocal = !Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        if (!(declaration2 instanceof FirPropertyAccessor)) {
            EffectiveVisibility restrictingVisibility;
            Pair pair;
            if (isNonLocal && !(declaration2 instanceof FirConstructor) && (pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null)) != null) {
                Pair pair2 = pair;
                boolean bl2 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
                restrictingVisibility = (EffectiveVisibility)pair2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), (Object)functionVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, (int)64, null);
            }
            for (FirValueParameter valueParameter : declaration2.getValueParameters()) {
                Pair pair3;
                FirResolvedDeclarationStatus propertyVisibility;
                FirProperty property2;
                Pair bl2;
                boolean exposureFound = false;
                if (isNonLocal && (bl2 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(valueParameter.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null)) != null) {
                    restrictingVisibility = bl2;
                    boolean bl3 = false;
                    FirBasedSymbol restricting = (FirBasedSymbol)restrictingVisibility.component1();
                    EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)restrictingVisibility.component2();
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)valueParameter.getSource()), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), (Object)functionVisibility, (Object)restricting, (Object)restrictingVisibility2, (DiagnosticContext)context2, null, (int)64, null);
                    exposureFound = true;
                }
                if (exposureFound || ClassMembersKt.getCorrespondingProperty(valueParameter) == null || property2.isLocal()) continue;
                FirMemberDeclaration $this$effectiveVisibility$iv2 = property2;
                boolean $i$f$getEffectiveVisibility2 = false;
                FirDeclarationStatus firDeclarationStatus2 = $this$effectiveVisibility$iv2.getStatus();
                FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = firDeclarationStatus2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus2 : null;
                if (firResolvedDeclarationStatus2 == null || (firResolvedDeclarationStatus2 = firResolvedDeclarationStatus2.getEffectiveVisibility()) == null) {
                    firResolvedDeclarationStatus2 = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)(propertyVisibility = firResolvedDeclarationStatus2), (Object)EffectiveVisibility.Local.INSTANCE) || (pair3 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null)) == null) continue;
                firDeclarationStatus2 = pair3;
                boolean bl4 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)firDeclarationStatus2.component1();
                EffectiveVisibility restrictingVisibility3 = (EffectiveVisibility)firDeclarationStatus2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)valueParameter.getSource()), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), (Object)propertyVisibility, (Object)restricting, (Object)restrictingVisibility3, (DiagnosticContext)context2, null, (int)64, null);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
            this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null, reporter, context2);
        }
    }

    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirResolvedDeclarationStatus propertyVisibility;
        if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration2), (Object)true)) {
            return;
        }
        if (declaration2.isLocal()) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE) || Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null);
        if (pair != null) {
            firDeclarationStatus = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)firDeclarationStatus.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)firDeclarationStatus.component2();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), (Object)propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, (int)64, null);
        }
        FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2, reporter, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        FirResolvedDeclarationStatus memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, receiverParameterType, context2, (EffectiveVisibility)memberVisibility, null, 4, null);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typeRef.getSource()), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), (Object)memberVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, (int)64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, (TypeCheckerProviderContext)TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to(classSymbol, (Object)effectiveVisibility);
                }
            }
        }
        object = type2.getTypeArguments();
        int n = ((ConeTypeProjection[])object).length;
        for (int j = 0; j < n; ++j) {
            Object it;
            Object object2;
            int index = j;
            ConeTypeProjection it2 = object[j];
            ConeTypeProjection coneTypeProjection = it2;
            if (coneTypeProjection instanceof ConeClassLikeType) {
                object2 = this.findVisibilityExposure((ConeKotlinType)it2, context2, base, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                object2 = this.findVisibilityExposure(((ConeKotlinTypeProjection)it2).getType(), context2, base, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeStarProjection) {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
                block20: {
                    Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2;
                    List<FirResolvedTypeRef> list2;
                    FirTypeParameterSymbol firTypeParameterSymbol;
                    List<FirTypeParameterSymbol> list3;
                    object2 = TypeUtilsKt.toRegularClassSymbol(type2, context2.getSession());
                    if (object2 == null || (list3 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(list3, (int)index)) == null || (list2 = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                    for (Pair<FirBasedSymbol<?>, EffectiveVisibility> it3 : (Iterable)list2) {
                        boolean bl = false;
                        if ((it3 = INSTANCE.findVisibilityExposure(it3.getType(), context2, base, visitedTypes)) == null) continue;
                        pair2 = it3;
                        break block20;
                    }
                    pair2 = pair = null;
                }
                if (pair == null) continue;
                Pair<FirBasedSymbol<?>, EffectiveVisibility> it4 = pair;
                boolean bl = false;
                return it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    static /* synthetic */ Pair findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, EffectiveVisibility effectiveVisibility, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(coneKotlinType, checkerContext, effectiveVisibility, set);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

