/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a.\u0010\u0000\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"checkMissingDependencySuperTypes", "", "classifierType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "checkers"})
public final class FirMissingDependencySupertypeUtilsKt {
    public static final boolean checkMissingDependencySuperTypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = classifierType;
        return FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes((FirBasedSymbol)(coneKotlinType != null ? TypeUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null), source, reporter, context2);
    }

    public static final boolean checkMissingDependencySuperTypes(@Nullable FirBasedSymbol<?> declaration2, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof FirClassSymbol)) {
            return false;
        }
        Set<ConeKotlinType> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context2.getSession()).getMissingSuperTypes((FirClassSymbol)declaration2);
        for (ConeKotlinType superType2 : missingSuperTypes) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS(), (Object)TypeUtilsKt.withNullability$default(TypeUtilsKt.withArguments(superType2, new ConeTypeProjection[0]), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration2, new ConeTypeProjection[0], false, null, 4, null), (DiagnosticContext)context2, null, (int)32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }
}

